/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.client.gui.GuiLogisticalSorter;
import mekanism.client.gui.GuiTFilterSelect;
import mekanism.client.gui.GuiTItemStackFilter;
import mekanism.client.gui.GuiTMaterialFilter;
import mekanism.client.gui.GuiTModIDFilter;
import mekanism.client.gui.GuiTOreDictFilter;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.TileEntityLogisticalSorter;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketLogisticalSorterGui
implements IMessageHandler<LogisticalSorterGuiMessage, IMessage> {
    public IMessage onMessage(final LogisticalSorterGuiMessage message, MessageContext context) {
        final EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(new Runnable(){

            @Override
            public void run() {
                if (!player.field_70170_p.field_72995_K) {
                    WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.coord4D.dimensionId);
                    if (worldServer != null && message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityLogisticalSorter) {
                        LogisticalSorterGuiMessage.openServerGui(message.packetType, message.guiType, (World)worldServer, (EntityPlayerMP)player, message.coord4D, message.index);
                    }
                } else if (message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p) instanceof TileEntityLogisticalSorter) {
                    try {
                        if (message.packetType == SorterGuiPacket.CLIENT) {
                            FMLCommonHandler.instance().showGuiScreen((Object)LogisticalSorterGuiMessage.getGui(message.packetType, message.guiType, player, player.field_70170_p, message.coord4D.getPos(), -1));
                        } else if (message.packetType == SorterGuiPacket.CLIENT_INDEX) {
                            FMLCommonHandler.instance().showGuiScreen((Object)LogisticalSorterGuiMessage.getGui(message.packetType, message.guiType, player, player.field_70170_p, message.coord4D.getPos(), message.index));
                        }
                        player.field_71070_bA.field_75152_c = message.windowId;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }, player);
        return null;
    }

    public static enum SorterGuiPacket {
        SERVER,
        CLIENT,
        SERVER_INDEX,
        CLIENT_INDEX;

    }

    public static class LogisticalSorterGuiMessage
    implements IMessage {
        public Coord4D coord4D;
        public SorterGuiPacket packetType;
        public int guiType;
        public int windowId = -1;
        public int index = -1;

        public LogisticalSorterGuiMessage() {
        }

        public LogisticalSorterGuiMessage(SorterGuiPacket type, Coord4D coord, int guiId, int extra, int extra2) {
            this.packetType = type;
            this.coord4D = coord;
            this.guiType = guiId;
            if (this.packetType == SorterGuiPacket.CLIENT) {
                this.windowId = extra;
            } else if (this.packetType == SorterGuiPacket.SERVER_INDEX) {
                this.index = extra;
            } else if (this.packetType == SorterGuiPacket.CLIENT_INDEX) {
                this.windowId = extra2;
                this.index = extra2;
            }
        }

        public static void openServerGui(SorterGuiPacket t, int guiType, World world, EntityPlayerMP playerMP, Coord4D obj, int i) {
            Container container = null;
            playerMP.func_71128_l();
            if (guiType == 0) {
                container = new ContainerNull((EntityPlayer)playerMP, (TileEntityContainerBlock)obj.getTileEntity((IBlockAccess)world));
            } else if (guiType == 4) {
                container = new ContainerNull((EntityPlayer)playerMP, (TileEntityContainerBlock)obj.getTileEntity((IBlockAccess)world));
            } else if (guiType == 1 || guiType == 2 || guiType == 3 || guiType == 5) {
                container = new ContainerFilter(playerMP.field_71071_by, (TileEntityContainerBlock)obj.getTileEntity((IBlockAccess)world));
            }
            playerMP.func_71117_bO();
            int window = playerMP.field_71139_cq;
            if (t == SorterGuiPacket.SERVER) {
                Mekanism.packetHandler.sendTo(new LogisticalSorterGuiMessage(SorterGuiPacket.CLIENT, obj, guiType, window, 0), playerMP);
            } else if (t == SorterGuiPacket.SERVER_INDEX) {
                Mekanism.packetHandler.sendTo(new LogisticalSorterGuiMessage(SorterGuiPacket.CLIENT_INDEX, obj, guiType, window, i), playerMP);
            }
            playerMP.field_71070_bA = container;
            playerMP.field_71070_bA.field_75152_c = window;
            playerMP.field_71070_bA.func_75132_a((IContainerListener)playerMP);
        }

        @SideOnly(value=Side.CLIENT)
        public static GuiScreen getGui(SorterGuiPacket packetType, int type, EntityPlayer player, World world, BlockPos pos, int index) {
            if (type == 0) {
                return new GuiLogisticalSorter(player, (TileEntityLogisticalSorter)world.func_175625_s(pos));
            }
            if (type == 4) {
                return new GuiTFilterSelect(player, (TileEntityLogisticalSorter)world.func_175625_s(pos));
            }
            if (packetType == SorterGuiPacket.CLIENT) {
                if (type == 1) {
                    return new GuiTItemStackFilter(player, (TileEntityLogisticalSorter)world.func_175625_s(pos));
                }
                if (type == 2) {
                    return new GuiTOreDictFilter(player, (TileEntityLogisticalSorter)world.func_175625_s(pos));
                }
                if (type == 3) {
                    return new GuiTMaterialFilter(player, (TileEntityLogisticalSorter)world.func_175625_s(pos));
                }
                if (type == 5) {
                    return new GuiTModIDFilter(player, (TileEntityLogisticalSorter)world.func_175625_s(pos));
                }
            } else if (packetType == SorterGuiPacket.CLIENT_INDEX) {
                if (type == 1) {
                    return new GuiTItemStackFilter(player, (TileEntityLogisticalSorter)world.func_175625_s(pos), index);
                }
                if (type == 2) {
                    return new GuiTOreDictFilter(player, (TileEntityLogisticalSorter)world.func_175625_s(pos), index);
                }
                if (type == 3) {
                    return new GuiTMaterialFilter(player, (TileEntityLogisticalSorter)world.func_175625_s(pos), index);
                }
                if (type == 5) {
                    return new GuiTModIDFilter(player, (TileEntityLogisticalSorter)world.func_175625_s(pos), index);
                }
            }
            return null;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            this.coord4D.write(dataStream);
            dataStream.writeInt(this.guiType);
            if (this.packetType == SorterGuiPacket.CLIENT || this.packetType == SorterGuiPacket.CLIENT_INDEX) {
                dataStream.writeInt(this.windowId);
            }
            if (this.packetType == SorterGuiPacket.SERVER_INDEX || this.packetType == SorterGuiPacket.CLIENT_INDEX) {
                dataStream.writeInt(this.index);
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = SorterGuiPacket.values()[dataStream.readInt()];
            this.coord4D = Coord4D.read(dataStream);
            this.guiType = dataStream.readInt();
            if (this.packetType == SorterGuiPacket.CLIENT || this.packetType == SorterGuiPacket.CLIENT_INDEX) {
                this.windowId = dataStream.readInt();
            }
            if (this.packetType == SorterGuiPacket.SERVER_INDEX || this.packetType == SorterGuiPacket.CLIENT_INDEX) {
                this.index = dataStream.readInt();
            }
        }
    }
}

