/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.init.XRRecipes;
import xreliquary.items.ItemEnderStaff;
import xreliquary.items.ItemHarvestRod;
import xreliquary.items.ItemPyromancerStaff;
import xreliquary.items.ItemRendingGale;
import xreliquary.items.ItemSojournerStaff;
import xreliquary.items.ItemVoidTear;
import xreliquary.reference.Colors;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;
import xreliquary.util.XpHelper;

public class ClientEventHandler {
    private static RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
    private static int time;
    private static final HashMap<Integer, CharmToDraw> charmsToDraw;
    private static final ResourceLocation XP_BAR;

    private static synchronized HashMap<Integer, CharmToDraw> getCharmsToDraw() {
        return charmsToDraw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCharmToDraw(byte type, int damage, int slot) {
        int maxMobCharmsToDisplay = Settings.MobCharm.maxCharmsToDisplay;
        HashMap<Integer, CharmToDraw> hashMap = charmsToDraw;
        synchronized (hashMap) {
            if (charmsToDraw.size() == maxMobCharmsToDisplay) {
                charmsToDraw.remove(0);
            }
            if (charmsToDraw.keySet().contains(slot)) {
                charmsToDraw.remove(slot);
            }
            if (damage > ModItems.mobCharm.func_77612_l()) {
                charmsToDraw.remove(slot);
            }
            if (damage <= ModItems.mobCharm.func_77612_l()) {
                charmsToDraw.put(slot, new CharmToDraw(type, damage, System.currentTimeMillis()));
            }
        }
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre event) {
        if (event.getEntity() instanceof EntityPlayer) {
            boolean handgunInMain;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            boolean handgunInOff = player.func_184586_b(EnumHand.OFF_HAND) != null && player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == ModItems.handgun;
            boolean bl = handgunInMain = player.func_184586_b(EnumHand.MAIN_HAND) != null && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ModItems.handgun;
            if (handgunInOff || handgunInMain) {
                ModelBiped model = (ModelBiped)event.getRenderer().func_177087_b();
                if (this.isHandgunActive(player, handgunInMain, handgunInOff)) {
                    EnumHand hand = this.getActiveHandgunHand(player, handgunInMain, handgunInOff);
                    EnumHandSide primaryHand = player.func_184591_cq();
                    if ((hand == EnumHand.MAIN_HAND && primaryHand == EnumHandSide.RIGHT || hand == EnumHand.OFF_HAND && primaryHand == EnumHandSide.LEFT) && model.field_187076_m != ModelBiped.ArmPose.BOW_AND_ARROW) {
                        model.field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
                    } else if ((hand == EnumHand.OFF_HAND && primaryHand == EnumHandSide.RIGHT || hand == EnumHand.MAIN_HAND && primaryHand == EnumHandSide.LEFT) && model.field_187075_l != ModelBiped.ArmPose.BOW_AND_ARROW) {
                        model.field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                } else {
                    if (model.field_187076_m == ModelBiped.ArmPose.BOW_AND_ARROW) {
                        model.field_187076_m = ModelBiped.ArmPose.ITEM;
                    }
                    if (model.field_187075_l == ModelBiped.ArmPose.BOW_AND_ARROW) {
                        model.field_187075_l = ModelBiped.ArmPose.ITEM;
                    }
                }
            }
        }
    }

    private EnumHand getActiveHandgunHand(EntityPlayer player, boolean handgunInMain, boolean handgunInOff) {
        boolean offValid;
        if (handgunInMain != handgunInOff) {
            return handgunInMain ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        }
        boolean mainValid = this.isValidTimeFrame(player.field_70170_p, player.func_184614_ca());
        if (mainValid != (offValid = this.isValidTimeFrame(player.field_70170_p, player.func_184592_cb()))) {
            return mainValid ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        }
        return ModItems.handgun.getCooldown(player.func_184614_ca()) < ModItems.handgun.getCooldown(player.func_184592_cb()) ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    private boolean isHandgunActive(EntityPlayer player, boolean handgunInMain, boolean handgunInOff) {
        return handgunInMain && this.isValidTimeFrame(player.field_70170_p, player.func_184614_ca()) || handgunInOff && this.isValidTimeFrame(player.field_70170_p, player.func_184592_cb());
    }

    private boolean isValidTimeFrame(World world, ItemStack handgun) {
        long cooldownTime = ModItems.handgun.getCooldown(handgun) + 5L;
        return cooldownTime - world.func_72820_D() <= (long)ModItems.handgun.func_77626_a(handgun) && cooldownTime >= world.func_72820_D();
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Minecraft.func_71382_s() || !mc.field_71415_G || mc.func_175598_ae().func_78716_a() == null) {
            return;
        }
        this.handleTickIncrement(event);
        this.handleHandgunHUDCheck(mc);
        this.handleSojournerHUDCheck(mc);
        this.handleTomeHUDCheck(mc);
        this.handleDestructionCatalystHUDCheck(mc);
        this.handleEnderStaffHUDCheck(mc);
        this.handleGlacialStaffHUDCheck(mc);
        this.handleIceMagusRodHUDCheck(mc);
        this.handleVoidTearHUDCheck(mc);
        this.handleMidasTouchstoneHUDCheck(mc);
        this.handleHarvestRodHUDCheck(mc);
        this.handleInfernalChaliceHUDCheck(mc);
        this.handleHeroMedallionHUDCheck(mc);
        this.handlePyromancerStaffHUDCheck(mc);
        this.handleRendingGaleHUDCheck(mc);
        this.handleMobCharmDisplay(mc);
    }

    private void handleMobCharmDisplay(Minecraft minecraft) {
        int hudOverlayX;
        int hudOverlayY;
        int numberItems = ClientEventHandler.getCharmsToDraw().size();
        int itemSize = 16;
        int borderSpacing = 8;
        int itemSpacing = 2;
        int displayPosition = Settings.MobCharm.displayPosition;
        if (numberItems <= 0) {
            return;
        }
        this.removeExpiredMobCharms();
        ScaledResolution sr = new ScaledResolution(minecraft);
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179145_e();
        if (displayPosition == 1 || displayPosition == 3) {
            hudOverlayY = sr.func_78328_b() / 2 - itemSize / 2 - Math.max(0, (numberItems - 1) * (itemSize + itemSpacing) / 2);
            hudOverlayX = displayPosition == 1 ? sr.func_78326_a() - (itemSize + borderSpacing) : borderSpacing;
        } else {
            hudOverlayY = borderSpacing;
            hudOverlayX = sr.func_78326_a() / 2 - itemSize / 2 - Math.max(0, (numberItems - 1) * (itemSize + itemSpacing) / 2);
        }
        HashMap<Integer, CharmToDraw> charmsToDrawCopy = new HashMap<Integer, CharmToDraw>(ClientEventHandler.getCharmsToDraw());
        for (CharmToDraw charmToDraw : charmsToDrawCopy.values()) {
            ItemStack stackToRender = XRRecipes.mobCharm(charmToDraw.type);
            stackToRender.func_77964_b(charmToDraw.damage);
            IBakedModel bakedModel = renderItem.func_184393_a(stackToRender, null, null);
            GlStateManager.func_179094_E();
            TextureManager textureManager = minecraft.func_110434_K();
            textureManager.func_110577_a(TextureMap.field_110575_b);
            textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179091_B();
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)hudOverlayX, (float)hudOverlayY, (float)100.0f);
            GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)16.0f, (float)16.0f, (float)16.0f);
            bakedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
            renderItem.func_180454_a(stackToRender, bakedModel);
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179140_f();
            GlStateManager.func_179121_F();
            textureManager.func_110577_a(TextureMap.field_110575_b);
            textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
            renderItem.func_180453_a(minecraft.func_175598_ae().func_78716_a(), stackToRender, hudOverlayX, hudOverlayY, null);
            if (displayPosition == 1 || displayPosition == 3) {
                hudOverlayY += itemSize + itemSpacing;
                continue;
            }
            hudOverlayX += itemSize + itemSpacing;
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredMobCharms() {
        int secondsToExpire = 4;
        HashMap<Integer, CharmToDraw> hashMap = charmsToDraw;
        synchronized (hashMap) {
            Iterator<Map.Entry<Integer, CharmToDraw>> iterator = charmsToDraw.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, CharmToDraw> entry = iterator.next();
                if (Settings.MobCharm.keepAlmostDestroyedDisplayed && (double)entry.getValue().damage >= (double)ModItems.mobCharm.func_77612_l() * 0.9 || entry.getValue().time + (long)(secondsToExpire * 1000) >= System.currentTimeMillis()) continue;
                iterator.remove();
            }
        }
    }

    private void handleTickIncrement(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        time = ClientEventHandler.getTime() > 4096 ? 0 : ++time;
    }

    private static int getTime() {
        return time;
    }

    private EnumHand getHandHoldingCorrectItem(EntityPlayer player, Item item) {
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == item) {
            return EnumHand.MAIN_HAND;
        }
        if (player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() == item) {
            return EnumHand.OFF_HAND;
        }
        return null;
    }

    private ItemStack getCorrectItemFromEitherHand(EntityPlayer player, Item item) {
        if (player == null) {
            return null;
        }
        EnumHand itemInHand = this.getHandHoldingCorrectItem(player, item);
        if (itemInHand == null) {
            return null;
        }
        return player.func_184586_b(itemInHand);
    }

    private void handleTomeHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack tomeStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.alkahestryTome);
        if (tomeStack == null) {
            return;
        }
        ItemStack chargeStack = Settings.AlkahestryTome.baseItem.func_77946_l();
        chargeStack.field_77994_a = NBTHelper.getInteger("charge", tomeStack);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, tomeStack, chargeStack, Settings.HudPositions.alkahestryTome, 0, 0);
    }

    private void handleDestructionCatalystHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack destructionCatalystStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.destructionCatalyst);
        if (destructionCatalystStack == null) {
            return;
        }
        ItemStack gunpowderStack = new ItemStack(Items.field_151016_H, NBTHelper.getInteger("gunpowder", destructionCatalystStack), 0);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, destructionCatalystStack, gunpowderStack, Settings.HudPositions.destructionCatalyst, 0, 0);
    }

    private void handleEnderStaffHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack enderStaffStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.enderStaff);
        if (enderStaffStack == null) {
            return;
        }
        ItemEnderStaff enderStaffItem = ModItems.enderStaff;
        String staffMode = enderStaffItem.getMode(enderStaffStack);
        ItemStack displayItemStack = new ItemStack(Items.field_151079_bi, enderStaffItem.getPearlCount(enderStaffStack), 0);
        if (staffMode.equals("node_warp")) {
            displayItemStack = new ItemStack((Block)ModBlocks.wraithNode, enderStaffItem.getPearlCount(enderStaffStack), 0);
        } else if (staffMode.equals("long_cast")) {
            displayItemStack = new ItemStack(Items.field_151061_bv, enderStaffItem.getPearlCount(enderStaffStack), 0);
        }
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, enderStaffStack, displayItemStack, Settings.HudPositions.enderStaff, 0, 0);
    }

    private void handleIceMagusRodHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack iceRodStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.iceMagusRod);
        if (iceRodStack == null) {
            return;
        }
        ItemStack snowballStack = new ItemStack(Items.field_151126_ay, NBTHelper.getInteger("snowballs", iceRodStack), 0);
        int hudPosition = Settings.HudPositions.iceMagusRod;
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, iceRodStack, snowballStack, hudPosition, 0, NBTHelper.getInteger("snowballs", iceRodStack));
    }

    private void handleGlacialStaffHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack glacialStaff = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.glacialStaff);
        if (glacialStaff == null) {
            return;
        }
        ItemStack snowballStack = new ItemStack(Items.field_151126_ay, NBTHelper.getInteger("snowballs", glacialStaff), 0);
        int hudPosition = Settings.HudPositions.glacialStaff;
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, glacialStaff, snowballStack, hudPosition, 0, NBTHelper.getInteger("snowballs", glacialStaff));
    }

    private void handleVoidTearHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack voidTearStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.filledVoidTear);
        if (voidTearStack == null) {
            return;
        }
        ItemVoidTear voidTearItem = (ItemVoidTear)voidTearStack.func_77973_b();
        ItemStack containedItemStack = voidTearItem.getContainerItem(voidTearStack);
        String mode = LanguageHelper.getLocalization("item.void_tear.mode." + ModItems.filledVoidTear.getMode(voidTearStack).toString().toLowerCase());
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, voidTearStack, containedItemStack, Settings.HudPositions.voidTear, 0, 0, 0, mode);
    }

    private void handleMidasTouchstoneHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack midasTouchstoneStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.midasTouchstone);
        if (midasTouchstoneStack == null) {
            return;
        }
        ItemStack glowstoneStack = new ItemStack(Items.field_151114_aO, NBTHelper.getInteger("glowstone", midasTouchstoneStack), 0);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, midasTouchstoneStack, glowstoneStack, Settings.HudPositions.midasTouchstone, 0, 0);
    }

    private void handleHarvestRodHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack harvestRodStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.harvestRod);
        if (harvestRodStack == null) {
            return;
        }
        ItemStack secondaryStack = null;
        ItemHarvestRod harvestRod = ModItems.harvestRod;
        if (harvestRod.getMode(harvestRodStack).equals("plantable")) {
            ItemStack currenPlantable = harvestRod.getCurrentPlantable(harvestRodStack);
            if (currenPlantable != null) {
                secondaryStack = currenPlantable.func_77946_l();
                secondaryStack.field_77994_a = harvestRod.getPlantableQuantity(harvestRodStack, harvestRod.getCurrentPlantableSlot(harvestRodStack));
            }
        } else if (harvestRod.getMode(harvestRodStack).equals("bone_meal")) {
            int boneMealCount = harvestRod.getBoneMealCount(harvestRodStack);
            secondaryStack = new ItemStack(Items.field_151100_aR, boneMealCount, 15);
        } else {
            secondaryStack = new ItemStack(Items.field_151017_I);
        }
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, harvestRodStack, secondaryStack, Settings.HudPositions.harvestRod, 0, 0);
    }

    private void handleInfernalChaliceHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack infernalChaliceStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.infernalChalice);
        if (infernalChaliceStack == null) {
            return;
        }
        ItemStack lavaStack = new ItemStack(Items.field_151129_at, NBTHelper.getInteger("fluidStacks", infernalChaliceStack), 0);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, infernalChaliceStack, lavaStack, Settings.HudPositions.infernalChalice, Colors.get("AA0000"), lavaStack.field_77994_a / 1000);
    }

    private void handleHeroMedallionHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack heroMedallionStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.heroMedallion);
        if (heroMedallionStack == null) {
            return;
        }
        int experience = NBTHelper.getInteger("experience", heroMedallionStack);
        int level = XpHelper.getLevelForExperience(experience);
        int remainingExperience = experience - XpHelper.getExperienceForLevel(level);
        int maxBarExperience = XpHelper.getExperienceLimitOnLevel(level);
        this.renderHeroXpBar(mc, remainingExperience, maxBarExperience, Settings.HudPositions.heroMedallion);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, heroMedallionStack, null, Settings.HudPositions.heroMedallion, Colors.get("009900"), level, 20);
    }

    private void renderHeroXpBar(Minecraft mc, int partialExperience, int experienceLimit, int hudPosition) {
        mc.field_71446_o.func_110577_a(XP_BAR);
        ScaledResolution sr = new ScaledResolution(mc);
        int hudOverlayX = 10;
        int hudOverlayY = 84;
        switch (hudPosition) {
            case 1: {
                hudOverlayX = sr.func_78326_a() - 19;
                break;
            }
            case 2: {
                hudOverlayY = sr.func_78328_b() - 8;
                break;
            }
            case 3: {
                hudOverlayX = sr.func_78326_a() - 19;
                hudOverlayY = sr.func_78328_b() - 8;
                break;
            }
        }
        float experience = (float)partialExperience / (float)experienceLimit;
        int k = (int)(experience * 74.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        this.drawTexturedModalRect(hudOverlayX, hudOverlayY, 0.0, 0.0, 11.0, 74.0);
        if (k > 0) {
            this.drawTexturedModalRect(hudOverlayX, hudOverlayY, 11.0, 0.0, 11.0, k);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    private void drawTexturedModalRect(double x, double y, double textureX, double textureY, double width, double height) {
        double minU = textureX / 22.0;
        double maxU = (textureX + width) / 22.0;
        double minV = textureY + (74.0 - height) / 74.0;
        double maxV = 1.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(x, y, 0.0).func_187315_a(minU, maxV).func_181675_d();
        vertexbuffer.func_181662_b(x + width, y, 0.0).func_187315_a(maxU, maxV).func_181675_d();
        vertexbuffer.func_181662_b(x + width, y - height, 0.0).func_187315_a(maxU, minV).func_181675_d();
        vertexbuffer.func_181662_b(x, y - height, 0.0).func_187315_a(minU, minV).func_181675_d();
        tessellator.func_78381_a();
    }

    private void handlePyromancerStaffHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack pyromancerStaffStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.pyromancerStaff);
        if (pyromancerStaffStack == null) {
            return;
        }
        int charge = 0;
        int blaze = 0;
        NBTTagCompound tagCompound = NBTHelper.getTag(pyromancerStaffStack);
        if (tagCompound != null) {
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagItemData = tagList.func_150305_b(i);
                String itemName = tagItemData.func_74779_i("Name");
                Item containedItem = RegistryHelper.getItemFromName(itemName);
                int quantity = tagItemData.func_74762_e("Quantity");
                if (containedItem == Items.field_151065_br) {
                    blaze = quantity;
                    continue;
                }
                if (containedItem != Items.field_151059_bz) continue;
                charge = quantity;
            }
        }
        String staffMode = ((ItemPyromancerStaff)pyromancerStaffStack.func_77973_b()).getMode(pyromancerStaffStack);
        ItemStack fireChargeStack = new ItemStack(Items.field_151059_bz, charge, 0);
        ItemStack blazePowderStack = new ItemStack(Items.field_151065_br, blaze, 0);
        ClientEventHandler.renderPyromancerStaffHUD(mc, (EntityPlayer)player, pyromancerStaffStack, fireChargeStack, blazePowderStack, staffMode);
    }

    private static void renderPyromancerStaffHUD(Minecraft minecraft, EntityPlayer player, ItemStack hudStack, ItemStack secondaryStack, ItemStack tertiaryStack, String staffMode) {
        int color = Colors.get("FFFFFF");
        float overlayScale = 2.5f;
        float overlayOpacity = 0.75f;
        GlStateManager.func_179094_E();
        ScaledResolution sr = new ScaledResolution(minecraft);
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        int hudOverlayX = 8;
        int hudOverlayY = 8;
        boolean leftSide = Settings.HudPositions.pyromancerStaff == 0 || Settings.HudPositions.pyromancerStaff == 2;
        switch (Settings.HudPositions.pyromancerStaff) {
            case 1: {
                hudOverlayX = sr.func_78326_a() - 8;
                break;
            }
            case 2: {
                hudOverlayY = (int)((float)sr.func_78328_b() - 18.0f * overlayScale);
                break;
            }
            case 3: {
                hudOverlayX = sr.func_78326_a() - 8;
                hudOverlayY = (int)((float)sr.func_78328_b() - 18.0f * overlayScale);
                break;
            }
        }
        ClientEventHandler.renderItemIntoGUI(minecraft.func_175598_ae().func_78716_a(), hudStack, hudOverlayX - (leftSide ? 0 : 15), hudOverlayY, overlayOpacity, overlayScale);
        String friendlyStaffMode = "";
        if (staffMode.equals("eruption")) {
            friendlyStaffMode = "ERUPT";
        }
        if (secondaryStack != null && staffMode.equals("charge")) {
            renderItem.func_180450_b(secondaryStack, hudOverlayX + (leftSide ? 0 : -(16 + Integer.toString(secondaryStack.field_77994_a).length() * 6)), hudOverlayY + 24);
            minecraft.func_175598_ae().func_78716_a().func_175063_a(Integer.toString(secondaryStack.field_77994_a), (float)(hudOverlayX + (leftSide ? 16 : -(Integer.toString(secondaryStack.field_77994_a).length() * 6))), (float)(hudOverlayY + 30), color);
        } else if (tertiaryStack != null && (staffMode.equals("eruption") || staffMode.equals("blaze"))) {
            renderItem.func_180450_b(tertiaryStack, hudOverlayX + (leftSide ? 0 : -(16 + Integer.toString(tertiaryStack.field_77994_a).length() * 6)), hudOverlayY + 24);
            minecraft.func_175598_ae().func_78716_a().func_175063_a(Integer.toString(tertiaryStack.field_77994_a), (float)(hudOverlayX + (leftSide ? 16 : -(Integer.toString(tertiaryStack.field_77994_a).length() * 6))), (float)(hudOverlayY + 30), color);
            if (staffMode.equals("eruption")) {
                minecraft.func_175598_ae().func_78716_a().func_175063_a(friendlyStaffMode, (float)(hudOverlayX - (leftSide ? 0 : friendlyStaffMode.length() * 6)), (float)(hudOverlayY + 18), color);
            }
        } else if (staffMode.equals("flint_and_steel")) {
            renderItem.func_180450_b(new ItemStack(Items.field_151033_d, 1, 0), hudOverlayX - (leftSide ? 0 : 15), hudOverlayY + 24);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private void handleRendingGaleHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack rendingGaleStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.rendingGale);
        if (rendingGaleStack == null) {
            return;
        }
        int currentCost = 0;
        if (!player.field_71075_bZ.field_75098_d && player.func_184587_cr()) {
            int ticksInUse = ModItems.rendingGale.func_77626_a(rendingGaleStack) - player.func_184605_cv();
            if (ModItems.rendingGale.isFlightMode(rendingGaleStack)) {
                currentCost = ItemRendingGale.getChargeCost() * ticksInUse;
            } else if (ModItems.rendingGale.isBoltMode(rendingGaleStack)) {
                currentCost = ItemRendingGale.getBoltChargeCost() * (ticksInUse / 8);
            }
        }
        ItemStack featherStack = new ItemStack(Items.field_151008_G, ModItems.rendingGale.getFeatherCount(rendingGaleStack) - currentCost, 0);
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, rendingGaleStack, featherStack, Settings.HudPositions.rendingGale, 0, Math.max(featherStack.field_77994_a / 100, 0));
    }

    private void handleHandgunHUDCheck(Minecraft mc) {
        ItemStack offHandgunStack;
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack mainHandgunStack = player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == ModItems.handgun ? player.func_184614_ca() : null;
        ItemStack itemStack = offHandgunStack = player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() == ModItems.handgun ? player.func_184592_cb() : null;
        if (mainHandgunStack == null && offHandgunStack == null) {
            return;
        }
        ItemStack mainBulletStack = null;
        if (mainHandgunStack != null) {
            mainBulletStack = this.getBulletStackFromHandgun(mainHandgunStack);
        }
        ItemStack offBulletStack = null;
        if (offHandgunStack != null) {
            offBulletStack = this.getBulletStackFromHandgun(offHandgunStack);
        }
        ClientEventHandler.renderHandgunHUD(mc, (EntityPlayer)player, mainHandgunStack, mainBulletStack, offHandgunStack, offBulletStack);
    }

    private ItemStack getBulletStackFromHandgun(ItemStack handgun) {
        ItemStack bulletStack = new ItemStack((Item)ModItems.bullet, (int)ModItems.handgun.getBulletCount(handgun), (int)ModItems.handgun.getBulletType(handgun));
        List<PotionEffect> potionEffects = ModItems.handgun.getPotionEffects(handgun);
        if (potionEffects != null && potionEffects.size() > 0) {
            PotionUtils.func_185184_a((ItemStack)bulletStack, potionEffects);
        }
        return bulletStack;
    }

    private static void renderHandgunHUD(Minecraft minecraft, EntityPlayer player, ItemStack mainHandgunStack, ItemStack mainBulletStack, ItemStack offHandgunStack, ItemStack offBulletStack) {
        float overlayScale = 2.5f;
        float overlayOpacity = 0.75f;
        float segmentHeight = 6.0f * overlayScale;
        GlStateManager.func_179094_E();
        ScaledResolution sr = new ScaledResolution(minecraft);
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        int hudOverlayX = (int)(16.0f * overlayScale);
        int hudOverlayY = (int)(6.0f * overlayScale);
        boolean twoHandguns = mainHandgunStack != null && offHandgunStack != null;
        switch (Settings.HudPositions.handgun) {
            case 0: {
                hudOverlayX = (int)(44.0f * overlayScale);
                break;
            }
            case 1: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 12.0f * overlayScale);
                break;
            }
            case 2: {
                hudOverlayX = (int)(44.0f * overlayScale);
                hudOverlayY = (int)((float)sr.func_78328_b() - (16.0f * overlayScale + (twoHandguns ? segmentHeight : 0.0f)));
                break;
            }
            case 3: {
                hudOverlayX = (int)((float)sr.func_78326_a() - 12.0f * overlayScale);
                hudOverlayY = (int)((float)sr.func_78328_b() - (16.0f * overlayScale + (twoHandguns ? segmentHeight : 0.0f)));
                break;
            }
        }
        if (mainHandgunStack != null) {
            ClientEventHandler.renderHandgunAndBullets(EnumHand.MAIN_HAND, minecraft, mainHandgunStack, mainBulletStack, overlayScale, overlayOpacity, hudOverlayX, hudOverlayY);
            hudOverlayY = (int)((float)hudOverlayY + segmentHeight);
        }
        if (offHandgunStack != null) {
            ClientEventHandler.renderHandgunAndBullets(EnumHand.OFF_HAND, minecraft, offHandgunStack, offBulletStack, overlayScale, overlayOpacity, hudOverlayX, hudOverlayY);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private static void renderHandgunAndBullets(EnumHand hand, Minecraft minecraft, ItemStack handgunStack, ItemStack bulletStack, float overlayScale, float overlayOpacity, int hudOverlayX, int hudOverlayY) {
        int adjustedHudOverlayX;
        ClientEventHandler.renderItemIntoGUI(minecraft.func_175598_ae().func_78716_a(), handgunStack, hudOverlayX - (hand == EnumHand.OFF_HAND ? 100 : 0), hudOverlayY, overlayOpacity, overlayScale);
        int n = adjustedHudOverlayX = hand == EnumHand.MAIN_HAND ? (int)((float)hudOverlayX - 6.0f * overlayScale) : (int)((float)hudOverlayX - 2.0f * overlayScale);
        if (bulletStack.field_77994_a == 0) {
            if (ClientEventHandler.getTime() % 32 > 16) {
                ClientEventHandler.renderItemIntoGUI(minecraft.func_175598_ae().func_78716_a(), new ItemStack((Item)ModItems.magazine, 1, 0), adjustedHudOverlayX, hudOverlayY, overlayOpacity, overlayScale / 2.0f);
            }
        } else {
            adjustedHudOverlayX -= hand == EnumHand.OFF_HAND ? 10 : 0;
            for (int xOffset = 0; xOffset < bulletStack.field_77994_a; ++xOffset) {
                ClientEventHandler.renderItemIntoGUI(minecraft.func_175598_ae().func_78716_a(), bulletStack, (int)((float)adjustedHudOverlayX - (float)(xOffset * 4) * overlayScale), hudOverlayY, 1.0f, overlayScale / 2.0f);
            }
        }
    }

    private void handleSojournerHUDCheck(Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack sojournerStack = this.getCorrectItemFromEitherHand((EntityPlayer)player, ModItems.sojournerStaff);
        if (sojournerStack == null) {
            return;
        }
        ItemSojournerStaff sojournerItem = (ItemSojournerStaff)sojournerStack.func_77973_b();
        String placementItemName = sojournerItem.getTorchPlacementMode(sojournerStack);
        int amountOfItem = sojournerItem.getTorchCount(sojournerStack);
        Item placementItem = null;
        if (placementItemName != null) {
            placementItem = RegistryHelper.getItemFromName(placementItemName);
        }
        ItemStack placementStack = null;
        if (placementItem != null) {
            placementStack = new ItemStack(placementItem, amountOfItem, 0);
        }
        ClientEventHandler.renderStandardTwoItemHUD(mc, (EntityPlayer)player, sojournerStack, placementStack, Settings.HudPositions.sojournerStaff, 0, 0);
    }

    private static void renderStandardTwoItemHUD(Minecraft minecraft, EntityPlayer player, ItemStack hudStack, ItemStack secondaryStack, int hudPosition, int colorOverride, int stackSizeOverride) {
        ClientEventHandler.renderStandardTwoItemHUD(minecraft, player, hudStack, secondaryStack, hudPosition, colorOverride, stackSizeOverride, 0);
    }

    private static void renderStandardTwoItemHUD(Minecraft minecraft, EntityPlayer player, ItemStack hudStack, ItemStack secondaryStack, int hudPosition, int colorOverride, int stackSizeOverride, int xOffset) {
        ClientEventHandler.renderStandardTwoItemHUD(minecraft, player, hudStack, secondaryStack, hudPosition, colorOverride, stackSizeOverride, xOffset, null);
    }

    private static void renderStandardTwoItemHUD(Minecraft minecraft, EntityPlayer player, ItemStack hudStack, ItemStack secondaryStack, int hudPosition, int colorOverride, int stackSizeOverride, int xOffset, String additionalText) {
        int stackSize = 0;
        if (stackSizeOverride > 0) {
            stackSize = stackSizeOverride;
        }
        int color = Colors.get("FFFFFF");
        if (colorOverride > 0) {
            color = colorOverride;
        }
        float overlayScale = 2.5f;
        float overlayOpacity = 0.75f;
        GlStateManager.func_179094_E();
        ScaledResolution sr = new ScaledResolution(minecraft);
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)sr.func_78327_c(), (double)sr.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        int hudOverlayX = 8 + xOffset;
        int hudOverlayY = 8;
        boolean leftSide = hudPosition == 0 || hudPosition == 2;
        switch (hudPosition) {
            case 1: {
                hudOverlayX = sr.func_78326_a() - (8 + xOffset);
                break;
            }
            case 2: {
                hudOverlayY = (int)((float)sr.func_78328_b() - 18.0f * overlayScale);
                break;
            }
            case 3: {
                hudOverlayX = sr.func_78326_a() - (8 + xOffset);
                hudOverlayY = (int)((float)sr.func_78328_b() - 18.0f * overlayScale);
                break;
            }
        }
        ClientEventHandler.renderItemIntoGUI(minecraft.func_175598_ae().func_78716_a(), hudStack, hudOverlayX - (leftSide ? 0 : 15), hudOverlayY, overlayOpacity, overlayScale);
        if (hudStack.func_77973_b() == ModItems.rendingGale || additionalText != null && !additionalText.isEmpty()) {
            if (hudStack.func_77973_b() == ModItems.rendingGale) {
                String staffMode;
                ItemRendingGale staffItem = (ItemRendingGale)hudStack.func_77973_b();
                switch (staffMode = staffItem.getMode(hudStack)) {
                    case "flight": {
                        additionalText = "FLIGHT";
                        break;
                    }
                    case "push": {
                        additionalText = "PUSH";
                        break;
                    }
                    case "pull": {
                        additionalText = "PULL";
                        break;
                    }
                    default: {
                        additionalText = "BOLT";
                    }
                }
            }
            minecraft.func_175598_ae().func_78716_a().func_175063_a(additionalText, (float)(hudOverlayX - (leftSide ? 0 : additionalText.length() * 6)), (float)(hudOverlayY + 18), color);
        }
        if (secondaryStack != null) {
            if (stackSize == 0) {
                stackSize = secondaryStack.field_77994_a;
            }
            renderItem.func_180450_b(secondaryStack, hudOverlayX - (leftSide ? 0 : 16 + Integer.toString(stackSize).length() * 6), hudOverlayY + 25);
            hudOverlayX += leftSide ? 16 : 0;
        }
        GlStateManager.func_179140_f();
        minecraft.field_71466_p.func_175063_a(Integer.toString(stackSize), (float)(hudOverlayX - (leftSide ? 0 : Integer.toString(stackSize).length() * 6)), (float)(hudOverlayY + 29), color);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private static void renderItemIntoGUI(FontRenderer fontRenderer, ItemStack itemStack, int x, int y, float opacity, float scale) {
        renderItem.func_175042_a(itemStack, x, y);
    }

    static {
        charmsToDraw = new HashMap();
        XP_BAR = new ResourceLocation("xreliquary", "textures/gui/xp_bar.png");
    }

    private static class CharmToDraw {
        byte type;
        int damage;
        long time;

        CharmToDraw(byte type, int damage, long time) {
            this.type = type;
            this.damage = damage;
            this.time = time;
        }
    }
}

