/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.util.LocUtils;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.smeltery.ICast;
import slimeknights.tconstruct.library.tools.IPattern;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;

public class ItemBlockTable
extends ItemBlockMeta {
    public ItemBlockTable(Block block) {
        super(block);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nonnull EntityPlayer playerIn, @Nonnull List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        if (!stack.func_77942_o()) {
            return;
        }
        ItemStack legs = ItemBlockTable.getLegStack(stack);
        if (legs != null) {
            tooltip.add(legs.func_82833_r());
        }
        if (stack.func_77978_p().func_74764_b("inventory")) {
            this.addInventoryInformation(stack, playerIn, tooltip, advanced);
        }
    }

    public static ItemStack getLegStack(ItemStack table) {
        NBTTagCompound tag = TagUtil.getTagSafe(table).func_74775_l("textureBlock");
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        return stack;
    }

    protected void addInventoryInformation(@Nonnull ItemStack stack, @Nonnull EntityPlayer playerIn, @Nonnull List<String> tooltip, boolean advanced) {
        NBTTagCompound inventory = stack.func_77978_p().func_74775_l("inventory");
        if (!inventory.func_74764_b("Items")) {
            return;
        }
        NBTTagList items = inventory.func_150295_c("Items", 10);
        if (items.func_82582_d()) {
            return;
        }
        if (BlockToolTable.TableTypes.fromMeta(stack.func_77952_i()) == BlockToolTable.TableTypes.PatternChest) {
            String desc = null;
            for (int i = 0; i < items.func_74745_c(); ++i) {
                Item item;
                ItemStack inventoryStack = ItemStack.func_77949_a((NBTTagCompound)items.func_150305_b(i));
                if (inventoryStack == null || !((item = inventoryStack.func_77973_b()) instanceof ICast) && !(item instanceof IPattern)) continue;
                desc = item instanceof ICast ? "tooltip.patternchest.holds_casts" : "tooltip.patternchest.holds_patterns";
                break;
            }
            if (desc != null) {
                tooltip.addAll(LocUtils.getTooltips((String)Util.translateFormatted(desc, items.func_74745_c())));
            }
        } else {
            tooltip.addAll(LocUtils.getTooltips((String)Util.translateFormatted("tooltip.chest.has_items", items.func_74745_c())));
        }
    }
}

