/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.tweaks;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.tweaks.Tweak;

public class TweakAutoReplace
extends Tweak {
    public TweakAutoReplace() {
        super("tweaks", "autoReplace", "Automatically replaces broken items in the same column.", true);
    }

    @Override
    public void enable() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void disable() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onPlayerDestroyItem(PlayerDestroyItemEvent event) {
        int slot;
        ItemStack stackAbove;
        int row;
        if (!(event.getEntity() instanceof EntityPlayerMP) || event.getEntity().field_70170_p.field_72995_K || event.getOriginal() == null) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
        InventoryPlayer inv = player.field_71071_by;
        ItemStack currentItem = inv.func_70448_g();
        if (currentItem != null && currentItem != event.getOriginal()) {
            return;
        }
        for (row = 2; row >= 0 && TweakAutoReplace.canReplace(stackAbove = inv.func_70301_a(slot = inv.field_70461_c + row * 9 + 9), event.getOriginal()); --row) {
            int targetSlot = slot < 27 ? slot + 9 : slot - 27;
            inv.func_70299_a(targetSlot, stackAbove.func_77946_l());
            inv.func_70299_a(slot, null);
            player.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(0, slot + 9, stackAbove.func_77946_l()));
        }
        if (row < 2) {
            player.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(0, inv.field_70461_c + row * 9 + 18, null));
        }
    }

    private static boolean canReplace(@Nullable ItemStack replacement, @Nonnull ItemStack destroyed) {
        if (replacement == null) {
            return false;
        }
        Set classesSrc = destroyed.func_77973_b().getToolClasses(destroyed);
        Set classesDst = replacement.func_77973_b().getToolClasses(replacement);
        if (classesSrc.size() > 0 && classesSrc.equals(classesDst)) {
            return true;
        }
        if (destroyed.func_77973_b() instanceof ItemSword && replacement.func_77973_b() instanceof ItemSword) {
            return true;
        }
        return ItemUtils.equals(replacement, destroyed, false, !destroyed.func_77973_b().func_77645_m(), true);
    }
}

