/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage;

import com.google.common.base.Predicate;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.utils.RecipeUtils;
import pl.asie.charset.storage.GuiHandlerStorage;
import pl.asie.charset.storage.ProxyCommon;
import pl.asie.charset.storage.backpack.BlockBackpack;
import pl.asie.charset.storage.backpack.HandlerBackpack;
import pl.asie.charset.storage.backpack.ItemBackpack;
import pl.asie.charset.storage.backpack.PacketBackpackOpen;
import pl.asie.charset.storage.backpack.TileBackpack;
import pl.asie.charset.storage.barrel.BarrelCartRecipe;
import pl.asie.charset.storage.barrel.BarrelEventListener;
import pl.asie.charset.storage.barrel.BarrelRegistry;
import pl.asie.charset.storage.barrel.BarrelUpgradeRecipes;
import pl.asie.charset.storage.barrel.BlockBarrel;
import pl.asie.charset.storage.barrel.EntityMinecartDayBarrel;
import pl.asie.charset.storage.barrel.ItemDayBarrel;
import pl.asie.charset.storage.barrel.ItemMinecartDayBarrel;
import pl.asie.charset.storage.barrel.TileEntityDayBarrel;
import pl.asie.charset.storage.crate.BlockCrate;
import pl.asie.charset.storage.locking.EntityLock;
import pl.asie.charset.storage.locking.ItemKey;
import pl.asie.charset.storage.locking.ItemLock;
import pl.asie.charset.storage.locking.ItemMasterKey;
import pl.asie.charset.storage.locking.LockEventHandler;
import pl.asie.charset.storage.locking.RecipeDyeLock;

@Mod(modid="CharsetStorage", name="#", version="0.3.0-pre15", dependencies="required-after:Forge@[11.15.0.1715,);required-after:CharsetLib@0.3.0-pre15;after:mcmultipart", updateJSON="http://charset.asie.pl/update.json", acceptedMinecraftVersions="[1.10]")
public class ModCharsetStorage {
    public static final String MODID = "CharsetStorage";
    public static final String NAME = "#";
    public static final String VERSION = "0.3.0-pre15";
    public static final int DEFAULT_LOCKING_COLOR = 16505706;
    private static final Random rand = new Random();
    @Mod.Instance(value="CharsetStorage")
    public static ModCharsetStorage instance;
    @SidedProxy(clientSide="pl.asie.charset.storage.ProxyClient", serverSide="pl.asie.charset.storage.ProxyCommon")
    public static ProxyCommon proxy;
    public static PacketRegistry packet;
    public static Logger logger;
    public static BlockBackpack backpackBlock;
    public static ItemMasterKey masterKeyItem;
    public static ItemKey keyItem;
    public static ItemLock lockItem;
    public static boolean enableBackpackOpenKey;
    public static boolean enableKeyKeepInventory;
    public static BlockBarrel barrelBlock;
    public static ItemDayBarrel barrelItem;
    public static ItemMinecartDayBarrel barrelCartItem;
    public static BlockCrate crateBlock;
    public static ItemBlock crateItem;
    public static boolean barrelsEnabled;
    public static boolean renderBarrelText;
    public static boolean renderBarrelItem;
    public static boolean renderBarrelItem3D;
    private Configuration config;

    @Optional.Method(modid="mcmultipart")
    private void initMultiplePants() {
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (!ModCharsetLib.moduleEnabled("storage")) {
            return;
        }
        logger = LogManager.getLogger((String)MODID);
        this.config = new Configuration(ModCharsetLib.instance.getConfigFile("storage.cfg"));
        barrelsEnabled = this.config.getBoolean("barrelsEnabled", "barrels", true, "");
        backpackBlock = new BlockBackpack();
        GameRegistry.register((IForgeRegistryEntry)backpackBlock.setRegistryName("backpack"));
        GameRegistry.register((IForgeRegistryEntry)new ItemBackpack(backpackBlock).setRegistryName("backpack"));
        if (Loader.isModLoaded((String)"mcmultipart")) {
            this.initMultiplePants();
        }
        if (barrelsEnabled) {
            barrelBlock = new BlockBarrel();
            barrelItem = new ItemDayBarrel(barrelBlock);
            barrelCartItem = new ItemMinecartDayBarrel();
            GameRegistry.register((IForgeRegistryEntry)barrelBlock.setRegistryName("barrel"));
            GameRegistry.register((IForgeRegistryEntry)barrelItem.setRegistryName("barrel"));
            GameRegistry.register((IForgeRegistryEntry)barrelCartItem.setRegistryName("barrelCart"));
            MinecraftForge.EVENT_BUS.register((Object)new BarrelEventListener());
        }
        masterKeyItem = new ItemMasterKey();
        GameRegistry.register((IForgeRegistryEntry)masterKeyItem.setRegistryName("masterKey"));
        keyItem = new ItemKey();
        GameRegistry.register((IForgeRegistryEntry)keyItem.setRegistryName("key"));
        lockItem = new ItemLock();
        GameRegistry.register((IForgeRegistryEntry)lockItem.setRegistryName("lock"));
        if (barrelsEnabled) {
            ModCharsetLib.proxy.registerItemModel((Item)barrelItem, 0, "charsetstorage:barrel");
            ModCharsetLib.proxy.registerItemModel((Item)barrelCartItem, 0, "charsetstorage:barrelCart");
        }
        ModCharsetLib.proxy.registerItemModel(backpackBlock, 0, "charsetstorage:backpack");
        ModCharsetLib.proxy.registerItemModel(masterKeyItem, 0, "charsetstorage:masterKey");
        ModCharsetLib.proxy.registerItemModel(keyItem, 0, "charsetstorage:key");
        ModCharsetLib.proxy.registerItemModel(lockItem, 0, "charsetstorage:lock");
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        enableBackpackOpenKey = this.config.getBoolean("enableOpenKeyBinding", "backpack", true, "Should backpacks be openable with a key binding?");
        enableKeyKeepInventory = this.config.getBoolean("keepKeysOnDeath", "locks", true, "Should keys be kept in inventory on death?");
        renderBarrelItem3D = this.config.getBoolean("renderItem3D", "barrels", false, "Should items use fancy 3D rendering?");
        renderBarrelItem = this.config.getBoolean("renderItem", "barrels", true, "Should items be rendered on barrels?");
        renderBarrelText = this.config.getBoolean("renderText", "barrels", true, "Should text be rendered on barrels?");
        this.config.save();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!ModCharsetLib.moduleEnabled("storage")) {
            return;
        }
        if (barrelsEnabled) {
            GameRegistry.registerTileEntity(TileEntityDayBarrel.class, (String)"charset:barrel");
        }
        GameRegistry.registerTileEntity(TileBackpack.class, (String)"charset:backpack");
        EntityRegistry.registerModEntity(EntityLock.class, (String)"charsetstorage:lock", (int)1, (Object)this, (int)64, (int)3, (boolean)true);
        if (barrelsEnabled) {
            EntityRegistry.registerModEntity(EntityMinecartDayBarrel.class, (String)"charsetstorage:barrelCart", (int)2, (Object)this, (int)64, (int)1, (boolean)true);
        }
        proxy.init();
        packet = new PacketRegistry(MODID);
        packet.registerPacket(1, PacketBackpackOpen.class);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandlerStorage());
        MinecraftForge.EVENT_BUS.register((Object)new HandlerBackpack());
        MinecraftForge.EVENT_BUS.register((Object)new LockEventHandler());
        if (enableKeyKeepInventory) {
            ModCharsetLib.deathHandler.addPredicate(new Predicate<ItemStack>(){

                public boolean apply(@Nullable ItemStack input) {
                    return input != null && input.func_77973_b() instanceof ItemKey;
                }
            });
        }
        if (barrelsEnabled) {
            GameRegistry.addRecipe((IRecipe)new BarrelCartRecipe());
            BarrelUpgradeRecipes.addUpgradeRecipes();
            RecipeSorter.register((String)"charsetstorage:barrelCart", BarrelCartRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)backpackBlock), new Object[]{"lgl", "scs", "lwl", Character.valueOf('l'), Items.field_151116_aA, Character.valueOf('c'), "chestWood", Character.valueOf('s'), "stickWood", Character.valueOf('g'), "ingotGold", Character.valueOf('w'), Blocks.field_150325_L}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)keyItem), new Object[]{"ng", "ng", " g", Character.valueOf('n'), "nuggetGold", Character.valueOf('g'), "ingotGold"}){

            public ItemStack func_77572_b(InventoryCrafting inv) {
                ItemStack result = this.output.func_77946_l();
                result.func_77982_d(new NBTTagCompound());
                result.func_77978_p().func_74778_a("key", new UUID(rand.nextLong(), rand.nextLong()).toString());
                return result;
            }
        });
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)keyItem), new Object[]{"ng", "ng", "kg", Character.valueOf('n'), "nuggetGold", Character.valueOf('g'), "ingotGold", Character.valueOf('k'), keyItem}){

            public ItemStack func_77572_b(InventoryCrafting inv) {
                ItemStack key = inv.func_70463_b(0, 2);
                if (key == null) {
                    key = inv.func_70463_b(1, 2);
                }
                if (key != null && key.func_77973_b() instanceof ItemKey) {
                    ItemStack result = this.output.func_77946_l();
                    result.func_77982_d(new NBTTagCompound());
                    result.func_77978_p().func_74778_a("key", ((ItemKey)key.func_77973_b()).getRawKey(key));
                    return result;
                }
                return null;
            }
        });
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)lockItem), new Object[]{" g ", "gkg", "gig", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), "ingotGold", Character.valueOf('k'), keyItem}){

            public ItemStack func_77572_b(InventoryCrafting inv) {
                ItemStack key = inv.func_70463_b(1, 1);
                if (key != null && key.func_77973_b() instanceof ItemKey) {
                    ItemStack result = this.output.func_77946_l();
                    result.func_77982_d(new NBTTagCompound());
                    result.func_77978_p().func_74778_a("key", ((ItemKey)key.func_77973_b()).getRawKey(key));
                    return result;
                }
                return null;
            }
        });
        GameRegistry.addRecipe((IRecipe)new RecipeDyeLock());
        RecipeSorter.register((String)"charsetstorage:lockDye", RecipeDyeLock.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
    }

    private void checkPlankForWoods(ItemStack log) {
        ItemStack plank;
        InventoryCrafting plankCrafting = RecipeUtils.getCraftingInventory(3, 3);
        plankCrafting.func_70299_a(0, log);
        IRecipe plankRecipe = RecipeUtils.getMatchingRecipe(plankCrafting, null);
        if (plankRecipe != null && (plank = plankRecipe.func_77572_b(plankCrafting)) != null) {
            ItemStack potentialStick;
            ItemStack potentialSlab;
            plank.field_77994_a = 1;
            ItemStack slab = plank;
            InventoryCrafting slabCrafting = RecipeUtils.getCraftingInventory(3, 3);
            slabCrafting.func_70299_a(6, plank.func_77946_l());
            slabCrafting.func_70299_a(7, plank.func_77946_l());
            slabCrafting.func_70299_a(8, plank.func_77946_l());
            IRecipe slabRecipe = RecipeUtils.getMatchingRecipe(slabCrafting, null);
            if (slabRecipe != null && (potentialSlab = slabRecipe.func_77572_b(slabCrafting)) != null && potentialSlab.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150376_bx)) {
                slab = potentialSlab;
            }
            BarrelRegistry.INSTANCE.registerCraftable(log, slab);
            ItemStack stick = new ItemStack(Items.field_151055_y);
            InventoryCrafting stickCrafting = RecipeUtils.getCraftingInventory(3, 3);
            slabCrafting.func_70299_a(0, plank.func_77946_l());
            slabCrafting.func_70299_a(3, plank.func_77946_l());
            IRecipe stickRecipe = RecipeUtils.getMatchingRecipe(slabCrafting, null);
            if (stickRecipe != null && (potentialStick = stickRecipe.func_77572_b(stickCrafting)) != null) {
                stick = potentialStick;
            }
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!ModCharsetLib.moduleEnabled("storage")) {
            return;
        }
        if (barrelsEnabled) {
            BarrelRegistry.INSTANCE.register(TileEntityDayBarrel.Type.CREATIVE, new ItemStack(Blocks.field_150357_h), new ItemStack(Blocks.field_150484_ah));
            barrelCartItem.func_77625_d(new ItemStack(Items.field_151108_aI).func_77976_d());
            BarrelRegistry.INSTANCE.registerCraftable(new ItemStack(Blocks.field_150364_r, 1, 0), new ItemStack((Block)Blocks.field_150376_bx, 1, 0));
            BarrelRegistry.INSTANCE.registerCraftable(new ItemStack(Blocks.field_150364_r, 1, 1), new ItemStack((Block)Blocks.field_150376_bx, 1, 1));
            BarrelRegistry.INSTANCE.registerCraftable(new ItemStack(Blocks.field_150364_r, 1, 2), new ItemStack((Block)Blocks.field_150376_bx, 1, 2));
            BarrelRegistry.INSTANCE.registerCraftable(new ItemStack(Blocks.field_150364_r, 1, 3), new ItemStack((Block)Blocks.field_150376_bx, 1, 3));
            BarrelRegistry.INSTANCE.registerCraftable(new ItemStack(Blocks.field_150363_s, 1, 0), new ItemStack((Block)Blocks.field_150376_bx, 1, 4));
            BarrelRegistry.INSTANCE.registerCraftable(new ItemStack(Blocks.field_150363_s, 1, 1), new ItemStack((Block)Blocks.field_150376_bx, 1, 5));
        }
        for (ItemStack log : OreDictionary.getOres((String)"logWood", (boolean)false)) {
            if (log.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150364_r) || log.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150363_s)) continue;
            try {
                if (log.func_77960_j() == Short.MAX_VALUE) {
                    for (int i = 0; i < (log.func_77973_b() instanceof ItemBlock ? 16 : 128); ++i) {
                        ItemStack stack = new ItemStack(log.func_77973_b(), 1, i);
                        this.checkPlankForWoods(stack);
                    }
                    continue;
                }
                this.checkPlankForWoods(log.func_77946_l());
            }
            catch (Exception exception) {}
        }
        proxy.postInit();
    }
}

