/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.pipes.shifter;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.charset.api.pipes.IShifter;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.pipes.PipeUtils;
import pl.asie.charset.pipes.pipe.PartPipe;
import pl.asie.charset.pipes.shifter.TileShifter;

public class BlockShifter
extends BlockContainer {
    public static final PropertyBool EXTRACT = PropertyBool.func_177716_a((String)"extract");
    public static final PropertyInteger STRENGTH = PropertyInteger.func_177719_a((String)"strength", (int)0, (int)2);

    public BlockShifter() {
        super(Material.field_151573_f);
        this.func_149663_c("charset.shifter");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(1.5f);
    }

    public boolean isValidFacing(World world, BlockPos pos, EnumFacing facing) {
        return PipeUtils.getPipe(world, pos.func_177972_a(facing), facing.func_176734_d()) != null;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileShifter) {
            int[] shiftedCoordinates = new int[6];
            TileShifter shifter = (TileShifter)tileEntity;
            EnumFacing[] enumFacingArray = EnumFacing.field_82609_l;
            int n = enumFacingArray.length;
            for (int i = 0; i < n; ++i) {
                EnumFacing side;
                EnumFacing newSide = side = enumFacingArray[i];
                switch (shifter.getDirection(state)) {
                    case DOWN: {
                        newSide = side.func_176732_a(EnumFacing.Axis.X).func_176732_a(EnumFacing.Axis.X);
                        break;
                    }
                    case NORTH: {
                        newSide = side.func_176732_a(EnumFacing.Axis.X);
                        break;
                    }
                    case EAST: {
                        newSide = side.func_176732_a(EnumFacing.Axis.X).func_176732_a(EnumFacing.Axis.Y);
                        break;
                    }
                    case SOUTH: {
                        newSide = side.func_176732_a(EnumFacing.Axis.X).func_176732_a(EnumFacing.Axis.Y).func_176732_a(EnumFacing.Axis.Y);
                        break;
                    }
                    case WEST: {
                        newSide = side.func_176732_a(EnumFacing.Axis.X).func_176732_a(EnumFacing.Axis.Y).func_176732_a(EnumFacing.Axis.Y).func_176732_a(EnumFacing.Axis.Y);
                    }
                }
                shiftedCoordinates[side.ordinal()] = newSide.ordinal();
            }
            return state.func_177226_a((IProperty)EXTRACT, (Comparable)Boolean.valueOf(shifter.getMode() == IShifter.Mode.Extract)).func_177226_a((IProperty)STRENGTH, (Comparable)Integer.valueOf(shifter.getRedstoneLevel() > 0 ? 2 : 0)).func_177226_a((IProperty)Properties.DOWN, (Comparable)Boolean.valueOf(shifter.getFilters()[shiftedCoordinates[0]] != null)).func_177226_a((IProperty)Properties.UP, (Comparable)Boolean.valueOf(shifter.getFilters()[shiftedCoordinates[1]] != null)).func_177226_a((IProperty)Properties.NORTH, (Comparable)Boolean.valueOf(shifter.getFilters()[shiftedCoordinates[2]] != null)).func_177226_a((IProperty)Properties.SOUTH, (Comparable)Boolean.valueOf(shifter.getFilters()[shiftedCoordinates[3]] != null)).func_177226_a((IProperty)Properties.WEST, (Comparable)Boolean.valueOf(shifter.getFilters()[shiftedCoordinates[4]] != null)).func_177226_a((IProperty)Properties.EAST, (Comparable)Boolean.valueOf(shifter.getFilters()[shiftedCoordinates[5]] != null));
        }
        return state;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side == null) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileShifter) {
            TileShifter shifter = (TileShifter)tileEntity;
            if (side == shifter.getDirection()) {
                return false;
            }
            if (shifter.getFilters()[side.ordinal()] != null) {
                if (!world.field_72995_K) {
                    shifter.setFilter(side.ordinal(), null);
                }
                return true;
            }
            if (heldItem != null) {
                if (!world.field_72995_K) {
                    ItemStack filter = heldItem.func_77946_l();
                    filter.field_77994_a = 1;
                    shifter.setFilter(side.ordinal(), filter);
                }
                return true;
            }
        }
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        PartPipe partForward = PipeUtils.getPipe(world, pos.func_177972_a(facing), facing.func_176734_d());
        PartPipe partBackward = PipeUtils.getPipe(world, pos.func_177972_a(facing.func_176734_d()), facing);
        if (partBackward instanceof PartPipe) {
            return this.func_176203_a(facing.func_176734_d().ordinal());
        }
        if (partForward instanceof PartPipe) {
            return this.func_176203_a(facing.ordinal());
        }
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            if (!this.isValidFacing(world, pos, direction)) continue;
            return this.func_176203_a(direction.ordinal());
        }
        return this.func_176203_a(facing.ordinal());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STRENGTH, EXTRACT, Properties.FACING, Properties.DOWN, Properties.UP, Properties.NORTH, Properties.SOUTH, Properties.WEST, Properties.EAST});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING)).ordinal();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileShifter();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileShifter) {
            ((TileShifter)tile).updateRedstoneLevel();
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        int m = ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING)).ordinal();
        for (int i = 1; i < 6; ++i) {
            EnumFacing f = EnumFacing.func_82600_a((int)((m + i) % 6));
            if (!this.isValidFacing(world, pos, f)) continue;
            world.func_180501_a(pos, state.func_177226_a((IProperty)Properties.FACING, (Comparable)f), 3);
            return true;
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

