/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.pipes.pipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.annotation.Nullable;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.PartSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;
import pl.asie.charset.api.lib.IItemInjectable;
import pl.asie.charset.api.pipes.IShifter;
import pl.asie.charset.lib.inventory.InventoryUtils;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.utils.DirectionUtils;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.pipes.ModCharsetPipes;
import pl.asie.charset.pipes.PipeUtils;
import pl.asie.charset.pipes.pipe.PacketItemUpdate;
import pl.asie.charset.pipes.pipe.PartPipe;

public class PipeItem {
    public static final int MAX_PROGRESS = 128;
    public static final int CENTER_PROGRESS = 64;
    public static final int SPEED = 8;
    private static short nextId;
    public final short id;
    byte blocksSinceSync;
    protected EnumFacing input;
    protected EnumFacing output;
    protected boolean reachedCenter;
    protected ItemStack stack;
    protected int progress;
    private int activeShifterDistance;
    private PartPipe owner;
    private boolean stuck;

    public PipeItem(PartPipe owner, ItemStack stack, EnumFacing side) {
        short s = nextId;
        nextId = (short)(s + 1);
        this.id = s;
        this.owner = owner;
        this.stack = stack;
        this.initializeFromEntrySide(side);
    }

    public PipeItem(PartPipe owner, NBTTagCompound nbt) {
        short s = nextId;
        nextId = (short)(s + 1);
        this.id = s;
        this.owner = owner;
        this.readFromNBT(nbt);
    }

    protected PipeItem(PartPipe tile, short id) {
        this.owner = tile;
        this.id = id;
    }

    public boolean isStuck() {
        return this.stuck;
    }

    public boolean isValid() {
        return this.stack != null && this.stack.func_77973_b() != null && this.input != null;
    }

    private float getTranslatedCoord(int offset) {
        if (this.progress >= 64) {
            return 0.5f + (float)offset * (float)(this.progress - 64) / 128.0f;
        }
        switch (offset) {
            case -1: {
                return 1.0f + (float)offset * (float)this.progress / 128.0f;
            }
            default: {
                return 0.5f;
            }
            case 1: 
        }
        return (float)offset * (float)this.progress / 128.0f;
    }

    public float getX() {
        return this.getDirection() != null ? this.getTranslatedCoord(this.getDirection().func_82601_c()) : 0.5f;
    }

    public float getY() {
        return this.getDirection() != null ? this.getTranslatedCoord(this.getDirection().func_96559_d()) : 0.5f;
    }

    public float getZ() {
        return this.getDirection() != null ? this.getTranslatedCoord(this.getDirection().func_82599_e()) : 0.5f;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Nullable
    public EnumFacing getDirection() {
        return this.reachedCenter ? this.output : (this.input != null ? this.input.func_176734_d() : null);
    }

    private boolean isCentered() {
        return this.progress == 64;
    }

    private int getInternalShifterStrength(IShifter shifter, EnumFacing dir) {
        if (shifter == null) {
            return 0;
        }
        return this.owner.getShifterStrength(dir) * 2 + (shifter.hasFilter() ? 0 : 1);
    }

    private void updateStuckFlag() {
        if (this.progress <= 64) {
            boolean needsRecalculation = false;
            if (!this.isValidDirection(this.output)) {
                needsRecalculation = true;
            } else if (this.stuck && this.isCentered()) {
                TileEntity shifterTile;
                boolean foundShifter = false;
                int minimumShifterDistance = Integer.MAX_VALUE;
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    IShifter p = this.owner.getNearestShifter(dir);
                    int ps = this.getInternalShifterStrength(p, dir);
                    if (ps <= 0 || ps >= minimumShifterDistance || !this.isShifterPushing(p, this.output)) continue;
                    minimumShifterDistance = ps;
                    foundShifter = true;
                }
                if ((!foundShifter && this.activeShifterDistance > 0 || foundShifter && this.activeShifterDistance != minimumShifterDistance || foundShifter && this.activeShifterDistance != this.getInternalShifterStrength(this.owner.getNearestShifter(this.output), this.output)) && ((shifterTile = this.owner.getWorld().func_175625_s(this.owner.getPos().func_177967_a(this.output.func_176734_d(), this.activeShifterDistance))) == null || !shifterTile.hasCapability(ModCharsetPipes.CAP_SHIFTER, this.output) || !this.isShifterPushing((IShifter)shifterTile.getCapability(ModCharsetPipes.CAP_SHIFTER, this.output), this.output))) {
                    needsRecalculation = true;
                }
            }
            if (needsRecalculation) {
                this.calculateOutputDirection();
            }
        } else if (!this.isValidDirection(this.output)) {
            this.output = null;
        }
        this.stuck = this.output == null ? false : (this.isCentered() && this.activeShifterDistance > 0 && this.owner.getShifterStrength(this.output.func_176734_d()) == this.owner.getShifterStrength(this.output) && this.isShifterPushing(this.owner.getNearestShifter(this.output.func_176734_d()), this.output.func_176734_d()) ? true : !this.canMoveDirection(this.output, false));
    }

    PacketItemUpdate getSyncPacket(boolean syncStack) {
        return new PacketItemUpdate((IMultipart)this.owner, this, syncStack);
    }

    protected void sendPacket(boolean syncStack) {
        if (this.owner.getWorld() != null && !this.owner.getWorld().field_72995_K) {
            ModCharsetPipes.packet.sendToAllAround((Packet)this.getSyncPacket(syncStack), (IMultipart)this.owner, 64.0);
        }
    }

    public boolean move() {
        if (!this.reachedCenter) {
            boolean atCenter;
            boolean bl = atCenter = this.progress + 8 >= 64;
            if (atCenter) {
                this.onReachedCenter();
            } else if (!this.stuck) {
                this.progress += 8;
            }
        } else if (this.owner.getWorld().field_72995_K) {
            if (!this.stuck) {
                this.progress += 8;
            }
            if (this.progress >= 128) {
                this.onItemEnd();
                return false;
            }
        } else {
            EnumFacing oldOutput = this.output;
            boolean oldStuck = this.stuck;
            this.updateStuckFlag();
            if (!this.stuck) {
                this.progress += 8;
            }
            if (this.progress >= 128) {
                this.onItemEnd();
                return false;
            }
            if (oldStuck != this.stuck || oldOutput != this.output) {
                this.sendPacket(false);
            }
        }
        return true;
    }

    private void onItemEnd() {
        PartPipe pipe;
        PartPipe partPipe = pipe = this.output != null ? PipeUtils.getPipe(this.owner.getWorld(), this.owner.getPos().func_177972_a(this.output), this.output.func_176734_d()) : null;
        if (this.owner.getWorld().field_72995_K) {
            if (this.blocksSinceSync < 2) {
                if (this.passToPipe(pipe, this.output, false)) {
                    this.blocksSinceSync = (byte)(this.blocksSinceSync + 1);
                } else {
                    this.stack = null;
                }
            } else {
                this.stack = null;
            }
        } else {
            if (this.output != null) {
                if (this.passToPipe(pipe, this.output, false)) {
                    return;
                }
                TileEntity tile = this.owner.getNeighbourTile(this.output);
                if (!this.passToInjectable(tile, this.output, false)) {
                    this.addToItemHandler(tile, this.output, false);
                }
            }
            if (this.stack != null && this.stack.field_77994_a > 0) {
                this.dropItem(true);
            }
        }
    }

    private boolean isValidDirection(EnumFacing dir) {
        if (dir == null || !this.owner.connects(dir)) {
            return false;
        }
        PartPipe pipe = PipeUtils.getPipe(this.owner.getWorld(), this.owner.getPos().func_177972_a(dir), dir.func_176734_d());
        if (pipe != null) {
            return pipe.canInjectItems(dir.func_176734_d());
        }
        TileEntity tile = this.owner.getNeighbourTile(dir);
        if (tile != null) {
            if (tile instanceof IItemInjectable) {
                return ((IItemInjectable)tile).canInjectItems(dir.func_176734_d());
            }
            IItemHandler handler = InventoryUtils.getItemHandler(tile, dir.func_176734_d());
            if (handler != null && handler.getSlots() > 0) {
                return true;
            }
        }
        return false;
    }

    private boolean canMoveDirection(EnumFacing dir, boolean isPickingDirection) {
        if (dir == null) {
            return this.activeShifterDistance == 0;
        }
        PartPipe pipe = PipeUtils.getPipe(this.owner.getWorld(), this.owner.getPos().func_177972_a(dir), dir.func_176734_d());
        if (this.passToPipe(pipe, dir, true)) {
            return true;
        }
        TileEntity tile = this.owner.getNeighbourTile(dir);
        if (this.passToInjectable(tile, dir, true)) {
            return true;
        }
        return this.addToItemHandler(tile, dir, true);
    }

    private boolean isShifterPushing(IShifter p, EnumFacing direction) {
        return p != null && p.getDirection() == direction && p.isShifting() && p.matches(this.stack);
    }

    private void calculateOutputDirection() {
        if (this.owner.getWorld() == null || this.owner.getWorld().field_72995_K) {
            return;
        }
        ArrayList<EnumFacing> directionList = new ArrayList<EnumFacing>();
        ArrayList<EnumFacing> pressureList = new ArrayList<EnumFacing>();
        this.activeShifterDistance = 0;
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            IShifter p;
            if (this.isValidDirection(direction)) {
                directionList.add(direction);
            }
            if ((p = this.owner.getNearestShifter(direction)) == null || !this.isShifterPushing(p, direction)) continue;
            pressureList.add(direction);
        }
        Collections.sort(pressureList, new Comparator<EnumFacing>(){

            @Override
            public int compare(EnumFacing o1, EnumFacing o2) {
                return PipeItem.this.getInternalShifterStrength(PipeItem.this.owner.getNearestShifter(o1), o1) - PipeItem.this.getInternalShifterStrength(PipeItem.this.owner.getNearestShifter(o2), o2);
            }
        });
        EnumFacing firstOutput = null;
        for (EnumFacing dir : pressureList) {
            if (this.canMoveDirection(dir, true)) {
                this.output = dir;
                this.activeShifterDistance = this.getInternalShifterStrength(this.owner.getNearestShifter(dir), dir);
                return;
            }
            if (pressureList.contains(dir.func_176734_d()) && this.owner.getShifterStrength(dir) == this.owner.getShifterStrength(dir.func_176734_d())) {
                this.output = dir;
                this.activeShifterDistance = this.getInternalShifterStrength(this.owner.getNearestShifter(dir), dir);
                return;
            }
            if (!directionList.contains(dir) || firstOutput != null) continue;
            firstOutput = dir;
        }
        directionList.removeAll(pressureList);
        directionList.remove(this.input);
        if (directionList.size() > 0) {
            EnumFacing dir;
            int i = 0;
            if (directionList.contains(this.input.func_176734_d())) {
                dir = this.input.func_176734_d();
                directionList.remove(this.input.func_176734_d());
            } else if (directionList.size() > 1) {
                Collections.shuffle(directionList);
                dir = (EnumFacing)directionList.get(0);
                i = 1;
            } else {
                if (directionList.size() == 1) {
                    this.output = (EnumFacing)directionList.get(0);
                    return;
                }
                this.output = null;
                return;
            }
            if (firstOutput == null) {
                firstOutput = dir;
            }
            while (!this.canMoveDirection(dir, true) && i < directionList.size()) {
                dir = (EnumFacing)directionList.get(i);
                ++i;
            }
            this.output = this.canMoveDirection(dir, true) ? dir : firstOutput;
        } else {
            this.output = firstOutput;
        }
    }

    private void onReachedCenter() {
        this.progress = 64;
        this.reachedCenter = true;
        if (this.owner.getWorld().field_72995_K) {
            return;
        }
        this.calculateOutputDirection();
        this.updateStuckFlag();
        this.sendPacket(false);
    }

    protected void reset(PartPipe owner, EnumFacing input) {
        this.owner = owner;
        this.initializeFromEntrySide(input);
        this.calculateOutputDirection();
    }

    private boolean passToInjectable(TileEntity tile, EnumFacing dir, boolean simulate) {
        int added;
        ISlottedPart part;
        if (tile instanceof IMultipartContainer && (part = ((IMultipartContainer)tile).getPartInSlot(PartSlot.CENTER)) instanceof PartPipe) {
            return false;
        }
        if (tile instanceof IItemInjectable && (added = ((IItemInjectable)tile).injectItem(this.stack, dir.func_176734_d(), simulate)) > 0) {
            if (!simulate) {
                this.stack.field_77994_a -= added;
            }
            return true;
        }
        return false;
    }

    private boolean passToPipe(PartPipe pipe, EnumFacing dir, boolean simulate) {
        return pipe != null && pipe.injectItemInternal(this, dir.func_176734_d(), simulate);
    }

    private boolean addToItemHandler(TileEntity tile, EnumFacing dir, boolean simulate) {
        if (tile != null) {
            int stackSize = this.stack.field_77994_a;
            IItemHandler handler = InventoryUtils.getItemHandler(tile, dir.func_176734_d());
            if (handler != null) {
                if (this.owner.getWorld().field_72995_K) {
                    return true;
                }
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack remain = handler.insertItem(i, this.stack, simulate);
                    int added = this.stack.field_77994_a;
                    if (remain != null) {
                        added -= remain.field_77994_a;
                    }
                    if ((stackSize -= added) == 0) {
                        if (!simulate) {
                            this.stack = null;
                        }
                        return true;
                    }
                    if (simulate) continue;
                    this.stack = this.stack.func_77946_l();
                    this.stack.field_77994_a = stackSize;
                }
                if (stackSize > 0 && !simulate) {
                    this.stack = this.stack.func_77946_l();
                    this.stack.field_77994_a = stackSize;
                    return true;
                }
            }
        }
        return false;
    }

    protected void dropItem(boolean useOutputDirection) {
        EnumFacing dir = null;
        if (useOutputDirection) {
            int directions = 0;
            for (EnumFacing d : EnumFacing.field_82609_l) {
                if (!this.owner.connects(d)) continue;
                dir = d.func_176734_d();
                if (++directions >= 2) break;
            }
            if (directions >= 2) {
                dir = null;
            }
        }
        ItemUtils.spawnItemEntity(this.owner.getWorld(), new Vec3d((double)this.owner.getPos().func_177958_n() + 0.5 + (double)(dir != null ? dir.func_82601_c() : 0) * 0.75, (double)this.owner.getPos().func_177956_o() + 0.5 + (double)(dir != null ? dir.func_96559_d() : 0) * 0.75, (double)this.owner.getPos().func_177952_p() + 0.5 + (double)(dir != null ? dir.func_82599_e() : 0) * 0.75), this.stack, 0.0f, 0.0f, 0.0f, 0.0f);
        this.stack = null;
    }

    private void initializeFromEntrySide(EnumFacing side) {
        this.input = side;
        this.output = null;
        this.reachedCenter = false;
        this.stuck = false;
        this.progress = 0;
        if (this.owner.getWorld().field_72995_K) {
            // empty if block
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.stack = ItemStack.func_77949_a((NBTTagCompound)nbt);
        this.progress = nbt.func_74765_d("p");
        this.input = DirectionUtils.get(nbt.func_74771_c("in"));
        this.output = DirectionUtils.get(nbt.func_74771_c("out"));
        this.reachedCenter = nbt.func_74767_n("reachedCenter");
        if (nbt.func_74764_b("stuck")) {
            this.stuck = nbt.func_74767_n("stuck");
        }
        if (nbt.func_74764_b("activePD")) {
            this.activeShifterDistance = nbt.func_74762_e("activePD");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.stack.func_77955_b(nbt);
        nbt.func_74777_a("p", (short)this.progress);
        nbt.func_74774_a("in", (byte)DirectionUtils.ordinal(this.input));
        nbt.func_74774_a("out", (byte)DirectionUtils.ordinal(this.output));
        nbt.func_74757_a("reachedCenter", this.reachedCenter);
        if (this.stuck) {
            nbt.func_74757_a("stuck", this.stuck);
        }
        if (this.activeShifterDistance > 0) {
            nbt.func_74768_a("activePD", this.activeShifterDistance);
        }
    }

    public boolean hasReachedCenter() {
        return this.reachedCenter;
    }

    public void setStuckFlagClient(boolean stuck) {
        if (this.owner.getWorld().field_72995_K) {
            this.stuck = stuck;
        }
    }

    public PartPipe getOwner() {
        return this.owner;
    }

    public float getProgress() {
        return (float)this.progress / 128.0f;
    }
}

