/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.pipes.pipe;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import mcmultipart.multipart.IMultipart;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import pl.asie.charset.lib.network.PacketPart;
import pl.asie.charset.lib.utils.DirectionUtils;
import pl.asie.charset.pipes.pipe.PartPipe;
import pl.asie.charset.pipes.pipe.PipeItem;

public class PacketItemUpdate
extends PacketPart {
    protected PipeItem item;
    private static final TIntObjectMap<WeakReference<PipeItem>> itemIdCache = new TIntObjectHashMap();
    private boolean syncStack;

    public PacketItemUpdate() {
    }

    public PacketItemUpdate(IMultipart part, PipeItem item, boolean syncStack) {
        super(part);
        this.item = item;
        this.syncStack = syncStack;
    }

    public void readItemData(ByteBuf buf) {
        if (this.part == null || !(this.part instanceof PartPipe)) {
            return;
        }
        short id = buf.readShort();
        short dirs = buf.readUnsignedByte();
        short flags = buf.readUnsignedByte();
        short progress = buf.readUnsignedByte();
        boolean addWhenDone = false;
        WeakReference ref = (WeakReference)itemIdCache.get((int)id);
        this.item = ref != null ? (PipeItem)ref.get() : null;
        boolean bl = this.syncStack = (flags & 4) != 0;
        if (!(this.item == null || this.item.getOwner() == this.part && this.item.getOwner().getPipeItems().contains(this.item))) {
            this.item.getOwner().removeItemClientSide(this.item);
            itemIdCache.remove((int)id);
            this.item = null;
        }
        if (this.item == null) {
            PartPipe pipe = (PartPipe)this.part;
            this.item = pipe.getItemByID(id);
        }
        if (this.item == null) {
            if (this.syncStack) {
                this.item = new PipeItem((PartPipe)this.part, id);
                addWhenDone = true;
            } else {
                return;
            }
        }
        this.item.input = DirectionUtils.get(dirs & 7);
        this.item.output = DirectionUtils.get(dirs >> 3 & 7);
        this.item.reachedCenter = (flags & 1) != 0;
        this.item.blocksSinceSync = 0;
        if (addWhenDone) {
            this.item.progress = progress;
        }
        boolean stuck = (flags & 2) != 0;
        this.item.setStuckFlagClient(stuck);
        if (this.syncStack) {
            this.item.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        itemIdCache.put((int)id, new WeakReference<PipeItem>(this.item));
        if (addWhenDone) {
            ((PartPipe)this.part).addItemClientSide(this.item);
        }
    }

    public void writeItemData(ByteBuf buf) {
        buf.writeShort((int)this.item.id);
        buf.writeByte(DirectionUtils.ordinal(this.item.input) | DirectionUtils.ordinal(this.item.output) << 3);
        buf.writeByte((this.item.reachedCenter ? 1 : 0) | (this.item.isStuck() ? 2 : 0) | (this.syncStack ? 4 : 0));
        buf.writeByte(this.item.progress);
        if (this.syncStack) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.item.getStack());
        }
    }

    @Override
    public void readData(INetHandler handler, ByteBuf buf) {
        super.readData(handler, buf);
        this.readItemData(buf);
    }

    @Override
    public void writeData(ByteBuf buf) {
        super.writeData(buf);
        this.writeItemData(buf);
    }
}

