/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import java.util.List;
import mcmultipart.item.ItemMultiPart;
import mcmultipart.multipart.IMultipart;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.wires.PartWire;
import pl.asie.charset.lib.wires.WireFactory;
import pl.asie.charset.lib.wires.WireManager;

public class ItemWire
extends ItemMultiPart {
    public ItemWire() {
        this.func_77627_a(true);
        this.func_77637_a(ModCharsetLib.CREATIVE_TAB);
    }

    public WireFactory getFactory(ItemStack stack) {
        return (WireFactory)WireManager.REGISTRY.getObjectById(stack.func_77960_j() >> 1);
    }

    public PartWire fromStack(ItemStack stack, EnumFacing facing) {
        WireFactory factory = this.getFactory(stack);
        if (factory != null) {
            PartWire wire = factory.createPart(stack);
            wire.location = ItemWire.isFreestanding(stack) ? WireFace.CENTER : WireFace.get(facing);
            return wire;
        }
        return null;
    }

    public boolean place(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        WireFactory factory = this.getFactory(stack);
        if (factory == null || !ItemWire.isFreestanding(stack) && !factory.canPlace((IBlockAccess)world, pos, WireFace.get(side))) {
            return false;
        }
        return super.place(world, pos, side, hit, stack, player);
    }

    public IMultipart createPart(World world, BlockPos blockPos, EnumFacing facing, Vec3d vec3, ItemStack stack, EntityPlayer player) {
        return this.fromStack(stack, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (ResourceLocation location : WireManager.REGISTRY.func_148742_b()) {
            int id = WireManager.REGISTRY.getId(location);
            subItems.add(new ItemStack(itemIn, 1, id * 2));
            subItems.add(new ItemStack(itemIn, 1, id * 2 + 1));
        }
    }

    public String func_77653_i(ItemStack stack) {
        PartWire wire = this.fromStack(stack, EnumFacing.DOWN);
        if (wire != null) {
            return wire.getDisplayName();
        }
        return "wire.null";
    }

    public static boolean isFreestanding(ItemStack stack) {
        return (stack.func_77952_i() & 1) == 1;
    }

    public ItemStack getStack(WireFactory factory, boolean freestanding) {
        return new ItemStack((Item)this, 1, WireManager.REGISTRY.getId((IForgeRegistryEntry)factory) << 1 | (freestanding ? 1 : 0));
    }
}

