/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.gates.render;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import pl.asie.charset.lib.utils.RenderUtils;

public class GateRenderDefinitions {
    public static final GateRenderDefinitions INSTANCE = new GateRenderDefinitions();
    private static final Gson GSON = new GsonBuilder().create();
    public BaseDefinition base;
    private final Map<String, Definition> definitionMap = new HashMap<String, Definition>();

    public Definition getGateDefinition(ResourceLocation type) {
        return this.definitionMap.get(type.toString());
    }

    public void load(String baseLoc, Map<String, ResourceLocation> definitions) {
        try {
            this.base = (BaseDefinition)GSON.fromJson((Reader)new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(baseLoc)).func_110527_b()), BaseDefinition.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.definitionMap.clear();
        if (this.base != null) {
            this.base.init();
            for (String s : definitions.keySet()) {
                try {
                    Definition def = (Definition)GSON.fromJson((Reader)new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(definitions.get(s)).func_110527_b()), Definition.class);
                    def.init();
                    def.merge(this.base);
                    this.definitionMap.put(s, def);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class Torch {
        public final float[] pos = new float[2];
        public String inverter;
    }

    public class Layer {
        public String type;
        public String texture;
        public Map<String, String> textures;
        public int height = 0;
    }

    public class Definition {
        public List<Layer> layers = new ArrayList<Layer>();
        public List<Torch> torches = new ArrayList<Torch>();
        private Map<String, String> models;
        private Map<String, IModel> modelObjs;
        private Map<String, String> textures;

        public void init() {
            this.modelObjs = new HashMap<String, IModel>();
            if (this.models == null) {
                this.models = new HashMap<String, String>();
            }
            if (this.textures == null) {
                this.textures = new HashMap<String, String>();
            }
        }

        public IModel getModel(String name) {
            if (this.modelObjs.containsKey(name)) {
                return this.modelObjs.get(name);
            }
            IModel model = RenderUtils.getModel(new ResourceLocation(this.models.get(name)));
            if (model != null) {
                if (model instanceof IRetexturableModel) {
                    model = ((IRetexturableModel)model).retexture(ImmutableMap.copyOf(this.textures));
                }
                this.modelObjs.put(name, model);
            }
            return model;
        }

        public List<IModel> getAllModels() {
            ArrayList<IModel> modelList = new ArrayList<IModel>();
            for (String s : this.models.keySet()) {
                IModel model = this.getModel(s);
                if (model == null) continue;
                modelList.add(model);
            }
            return modelList;
        }

        public void merge(BaseDefinition baseDef) {
            for (String s : baseDef.models.keySet()) {
                if (this.models.containsKey(s)) continue;
                this.models.put(s, (String)baseDef.models.get(s));
            }
            for (String s : baseDef.textures.keySet()) {
                if (this.textures.containsKey(s)) continue;
                this.textures.put(s, (String)baseDef.textures.get(s));
            }
        }
    }

    public class BaseDefinition {
        public Map<String, Integer> colorMul;
        private Map<String, String> colors = new HashMap<String, String>();
        private Map<String, String> models;
        private Map<String, String> textures;

        public void init() {
            if (this.models == null) {
                this.models = new HashMap<String, String>();
            }
            if (this.textures == null) {
                this.textures = new HashMap<String, String>();
            }
            this.colorMul = new HashMap<String, Integer>();
            for (String s : this.colors.keySet()) {
                int c = Integer.parseInt(this.colors.get(s), 16);
                this.colorMul.put(s, 0xFF000000 | c & 0xFF00 | (c & 0xFF0000) >> 16 | (c & 0xFF) << 16);
            }
        }
    }
}

