/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.audio.libresample4j;

public class FilterKit {
    private static final double IzeroEPSILON = 1.0E-21;

    private static double Izero(double x) {
        double temp;
        double u;
        int n = 1;
        double sum = u = (double)1;
        double halfx = x / 2.0;
        do {
            temp = halfx / (double)n;
            ++n;
        } while ((u *= (temp *= temp)) >= 1.0E-21 * (sum += u));
        return sum;
    }

    public static void lrsLpFilter(double[] c, int N, double frq, double Beta, int Num) {
        double temp;
        int i;
        c[0] = 2.0 * frq;
        for (i = 1; i < N; ++i) {
            temp = Math.PI * (double)i / (double)Num;
            c[i] = Math.sin(2.0 * temp * frq) / temp;
        }
        double IBeta = 1.0 / FilterKit.Izero(Beta);
        double inm1 = 1.0 / (double)(N - 1);
        i = 1;
        while (i < N) {
            temp = (double)i * inm1;
            double temp1 = 1.0 - temp * temp;
            temp1 = temp1 < 0.0 ? 0.0 : temp1;
            int n = i++;
            c[n] = c[n] * (FilterKit.Izero(Beta * Math.sqrt(temp1)) * IBeta);
        }
    }

    public static float lrsFilterUp(float[] Imp, float[] ImpD, int Nwing, boolean Interp, float[] Xp_array, int Xp_index, double Ph, int Inc) {
        double a = 0.0;
        float v = 0.0f;
        float[] Hp_array = Imp;
        int Hp_index = (int)(Ph *= 4096.0);
        float[] End_array = Imp;
        int End_index = Nwing;
        float[] Hdp_array = ImpD;
        int Hdp_index = (int)Ph;
        if (Interp) {
            a = Ph - Math.floor(Ph);
        }
        if (Inc == 1) {
            --End_index;
            if (Ph == 0.0) {
                Hp_index += 4096;
                Hdp_index += 4096;
            }
        }
        if (Interp) {
            while (Hp_index < End_index) {
                float t = Hp_array[Hp_index];
                t = (float)((double)t + (double)Hdp_array[Hdp_index] * a);
                Hdp_index += 4096;
                v += (t *= Xp_array[Xp_index]);
                Hp_index += 4096;
                Xp_index += Inc;
            }
        } else {
            while (Hp_index < End_index) {
                float t = Hp_array[Hp_index];
                v += (t *= Xp_array[Xp_index]);
                Hp_index += 4096;
                Xp_index += Inc;
            }
        }
        return v;
    }

    public static float lrsFilterUD(float[] Imp, float[] ImpD, int Nwing, boolean Interp, float[] Xp_array, int Xp_index, double Ph, int Inc, double dhb) {
        float v = 0.0f;
        double Ho = Ph * dhb;
        float[] End_array = Imp;
        int End_index = Nwing;
        if (Inc == 1) {
            --End_index;
            if (Ph == 0.0) {
                Ho += dhb;
            }
        }
        float[] Hp_array = Imp;
        if (Interp) {
            int Hp_index;
            float[] Hdp_array = ImpD;
            while ((Hp_index = (int)Ho) < End_index) {
                float t = Hp_array[Hp_index];
                int Hdp_index = (int)Ho;
                float a = (float)(Ho - Math.floor(Ho));
                t += Hdp_array[Hdp_index] * a;
                v += (t *= Xp_array[Xp_index]);
                Ho += dhb;
                Xp_index += Inc;
            }
        } else {
            int Hp_index;
            while ((Hp_index = (int)Ho) < End_index) {
                float t = Hp_array[Hp_index];
                v += (t *= Xp_array[Xp_index]);
                Ho += dhb;
                Xp_index += Inc;
            }
        }
        return v;
    }
}

