/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mixin.implementations.forge;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.mixin.api.Remap;
import reborncore.mixin.api.Rewrite;
import reborncore.mixin.implementations.forge.MixinForgeLoadingCore;
import reborncore.mixin.transformer.IMixinRemap;
import reborncore.mixin.transformer.util.ClassRenamer;
import reborncore.mixin.transformer.util.ConstPoolEditor;

public class ForgeRemapper
implements IMixinRemap {
    @Override
    public void remap(CtClass mixinClass, ClassPool classPool) {
        if (!MixinForgeLoadingCore.runtimeDeobfuscationEnabled) {
            return;
        }
        ArrayList<FieldData> fieldDataList = new ArrayList<FieldData>();
        for (CtField field : mixinClass.getFields()) {
            if (!field.hasAnnotation(Remap.class)) continue;
            Remap remap = null;
            try {
                remap = (Remap)field.getAnnotation(Remap.class);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            fieldDataList.add(new FieldData(field, field.getName(), remap.SRG()));
        }
        if (MixinForgeLoadingCore.runtimeDeobfuscationEnabled && !fieldDataList.isEmpty()) {
            ConstPool constPool = mixinClass.getClassFile().getConstPool();
            ConstPoolEditor editor = new ConstPoolEditor(constPool);
            block8: for (int i = 1; i < constPool.getSize(); ++i) {
                switch (constPool.getTag(i)) {
                    case 9: {
                        for (FieldData fieldData : fieldDataList) {
                            if (!constPool.getFieldrefName(i).equals(fieldData.name)) continue;
                            editor.changeMemberrefNameAndType(i, fieldData.srg, fieldData.field.getSignature());
                        }
                        continue block8;
                    }
                }
            }
        }
        ClassRenamer.renameClasses(mixinClass, className -> {
            if (!MixinForgeLoadingCore.runtimeDeobfuscationEnabled || !className.startsWith("net/minecraft")) {
                return null;
            }
            return FMLDeobfuscatingRemapper.INSTANCE.unmap(className);
        });
        if (mixinClass.getClassFile().getSuperclass().startsWith("net.minecraft") && MixinForgeLoadingCore.runtimeDeobfuscationEnabled) {
            try {
                mixinClass.setSuperclass(classPool.get(FMLDeobfuscatingRemapper.INSTANCE.unmap(mixinClass.getClassFile().getSuperclass().replace(".", "/"))));
            }
            catch (CannotCompileException | NotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Optional<Pair<String, String>> getFullTargetName(Rewrite annotation, String name) {
        if (MixinForgeLoadingCore.runtimeDeobfuscationEnabled) {
            String targetName = !annotation.targetSRG().isEmpty() ? annotation.targetSRG() : annotation.target();
            Map<String, String> methodMap = this.getMethodMap(name);
            for (Map.Entry<String, String> entry : methodMap.entrySet()) {
                if (!entry.getValue().equals(targetName)) continue;
                targetName = entry.getKey().split("\\(")[0];
                return Optional.of(new ImmutablePair((Object)targetName, (Object)entry.getKey()));
            }
        }
        return Optional.empty();
    }

    public Map<String, String> getMethodMap(String className) {
        try {
            Method method = FMLDeobfuscatingRemapper.class.getDeclaredMethod("getMethodMap", String.class);
            method.setAccessible(true);
            Map map = (Map)method.invoke((Object)FMLDeobfuscatingRemapper.INSTANCE, className);
            return map;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private class FieldData {
        public CtField field;
        public String name;
        public String srg;

        public FieldData(CtField field, String name, String srg) {
            this.field = field;
            this.name = name;
            this.srg = srg;
        }
    }
}

