/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mcmultipart.multipart;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.mcmultipart.client.multipart.AdvancedParticleManager;
import reborncore.mcmultipart.multipart.IMultipartContainer;
import reborncore.mcmultipart.raytrace.PartMOP;
import reborncore.mcmultipart.raytrace.RayTraceUtils;

public interface IMultipart {
    public World getWorld();

    public BlockPos getPos();

    public IMultipartContainer getContainer();

    public void setContainer(IMultipartContainer var1);

    public ResourceLocation getType();

    public ResourceLocation getModelPath();

    public RayTraceUtils.AdvancedRayTraceResultPart collisionRayTrace(Vec3d var1, Vec3d var2);

    public void addCollisionBoxes(AxisAlignedBB var1, List<AxisAlignedBB> var2, Entity var3);

    public boolean occlusionTest(IMultipart var1);

    public int getLightValue();

    public ItemStack getPickBlock(EntityPlayer var1, PartMOP var2);

    public List<ItemStack> getDrops();

    public void harvest(EntityPlayer var1, PartMOP var2);

    public float getStrength(EntityPlayer var1, PartMOP var2);

    public void onPartChanged(IMultipart var1);

    public void onNeighborBlockChange(Block var1);

    public void onNeighborTileChange(EnumFacing var1);

    public void onAdded();

    public void onRemoved();

    public void onLoaded();

    public void onUnloaded();

    public void onConverted(TileEntity var1);

    public boolean rotatePart(EnumFacing var1);

    public EnumFacing[] getValidRotations();

    public boolean onActivated(EntityPlayer var1, EnumHand var2, ItemStack var3, PartMOP var4);

    public void onClicked(EntityPlayer var1, PartMOP var2);

    public NBTTagCompound writeToNBT(NBTTagCompound var1);

    public void readFromNBT(NBTTagCompound var1);

    public void writeUpdatePacket(PacketBuffer var1);

    public void readUpdatePacket(PacketBuffer var1);

    public void sendUpdatePacket();

    public boolean canRenderInLayer(BlockRenderLayer var1);

    public BlockStateContainer createBlockState();

    public IBlockState getActualState(IBlockState var1);

    public IBlockState getExtendedState(IBlockState var1);

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox();

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random var1);

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(AdvancedParticleManager var1);

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(PartMOP var1, AdvancedParticleManager var2);

    public void onEntityStanding(Entity var1);

    public void onEntityCollided(Entity var1);

    public Boolean isAABBInsideMaterial(AxisAlignedBB var1, Material var2);

    public Boolean isEntityInsideMaterial(Entity var1, double var2, Material var4, boolean var5);
}

