/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import team.chisel.Chisel;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.client.ClientUtil;
import team.chisel.common.util.NBTUtil;

public class ChiselController {
    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack held = event.getItemStack();
        if (held != null && held.func_77973_b() instanceof IChiselItem) {
            ItemStack target = NBTUtil.getChiselTarget(held);
            IChiselItem chisel = (IChiselItem)held.func_77973_b();
            ICarvingRegistry registry = CarvingUtils.getChiselRegistry();
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (!chisel.canChiselBlock(event.getWorld(), player, event.getHand(), event.getPos(), state)) {
                return;
            }
            ICarvingGroup blockGroup = registry.getGroup(state);
            if (blockGroup == null) {
                return;
            }
            if (target != null) {
                ICarvingGroup sourceGroup = registry.getGroup(target);
                if (blockGroup == sourceGroup) {
                    ICarvingVariation variation = CarvingUtils.getChiselRegistry().getVariation(target);
                    if (variation != null) {
                        ChiselController.updateState(event.getWorld(), event.getPos(), variation.getBlockState());
                        ChiselController.damageItem(held, player);
                    } else {
                        Chisel.logger.warn("Found itemstack {} in group {}, but it has no variation!", new Object[]{target, sourceGroup.getName()});
                    }
                }
            } else {
                ICarvingVariation current = registry.getVariation(state);
                List<ICarvingVariation> variations = blockGroup.getVariations();
                int index = variations.indexOf(current);
                index = player.func_70093_af() ? index - 1 : index + 1;
                index = (index + variations.size()) % variations.size();
                ICarvingVariation next = variations.get(index);
                ChiselController.updateState(event.getWorld(), event.getPos(), next.getBlockState());
                ChiselController.damageItem(held, player);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        IChiselItem chisel;
        ItemStack stack;
        if (!event.getWorld().field_72995_K && (stack = event.getItemStack()) != null && stack.func_77973_b() instanceof IChiselItem && (chisel = (IChiselItem)stack.func_77973_b()).canOpenGui(event.getWorld(), event.getEntityPlayer(), event.getHand())) {
            event.getEntityPlayer().openGui((Object)Chisel.instance, 0, event.getWorld(), event.getHand().ordinal(), 0, 0);
        }
    }

    private static void damageItem(ItemStack stack, EntityPlayer player) {
        stack.func_77972_a(1, (EntityLivingBase)player);
        if (stack.field_77994_a <= 0) {
            player.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)null);
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)EnumHand.MAIN_HAND);
        }
    }

    private static void updateState(World world, BlockPos pos, IBlockState state) {
        IBlockState current = world.func_180495_p(pos);
        if (current != state) {
            world.func_175656_a(pos, state);
            if (world.field_72995_K) {
                ClientUtil.playSound(world, pos, CarvingUtils.getChiselRegistry().getVariationSound(current), SoundCategory.BLOCKS);
                ClientUtil.addDestroyEffects(world, pos, state);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (event.getPlayer().field_71075_bZ.field_75098_d && stack != null && stack.func_77973_b() instanceof IChiselItem) {
            event.setCanceled(true);
        }
    }
}

