/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.inventory;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import team.chisel.Chisel;
import team.chisel.api.carving.ICarvingRegistry;
import team.chisel.common.carving.Carving;
import team.chisel.common.inventory.InventoryChiselSelection;
import team.chisel.common.inventory.SlotChiselInput;
import team.chisel.common.inventory.SlotChiselSelection;
import team.chisel.common.util.NBTUtil;

@ParametersAreNonnullByDefault
public class ContainerChisel
extends Container {
    protected final InventoryChiselSelection inventoryChisel;
    protected final InventoryPlayer inventoryPlayer;
    protected final int chiselSlot;
    protected final ItemStack chisel;
    protected final ICarvingRegistry carving;

    public ContainerChisel(InventoryPlayer inventoryplayer, InventoryChiselSelection inv, EnumHand hand) {
        this.inventoryChisel = inv;
        this.inventoryPlayer = inventoryplayer;
        this.chiselSlot = hand == EnumHand.MAIN_HAND ? inventoryplayer.field_70461_c : inventoryplayer.func_70302_i_() - 1;
        this.chisel = Optional.ofNullable(inventoryplayer.func_70301_a(this.chiselSlot)).orElse(new ItemStack((Item)Chisel.itemChiselIron));
        this.carving = Carving.chisel;
        inv.container = this;
        this.addSlots();
        if (this.chisel != null && this.chisel.func_77978_p() != null) {
            ItemStack stack = NBTUtil.getChiselTarget(this.chisel);
            this.inventoryChisel.func_70299_a(this.getInventoryChisel().size, stack);
        }
        this.inventoryChisel.updateItems();
    }

    protected void addSlots() {
        int i;
        int top = 8;
        int left = 62;
        for (i = 0; i < this.getInventoryChisel().size; ++i) {
            this.func_75146_a(new SlotChiselSelection(this, this.inventoryChisel, this.inventoryChisel, i, left + i % 10 * 18, top + i / 10 * 18));
        }
        this.func_75146_a(new SlotChiselInput(this, this.inventoryChisel, this.getInventoryChisel().size, 24, 24));
        top += 112;
        left += 9;
        for (i = 0; i < 27; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, i + 9, left + i % 9 * 18, top + i / 9 * 18));
        }
        top += 58;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, i, left + i % 9 * 18, top + i / 9 * 18));
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (clickTypeIn != ClickType.QUICK_CRAFT && slotId >= 0) {
            int clickedSlot = slotId - this.inventoryChisel.func_70302_i_() - 27;
            Chisel.debug("Slot clicked is " + slotId + " and slot length is " + this.field_75151_b.size());
            try {
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                Chisel.debug("Slot is " + slot);
            }
            catch (Exception exception) {
                Chisel.debug("Exception getting slot");
                exception.printStackTrace();
            }
            if (clickedSlot == this.chiselSlot || clickTypeIn == ClickType.SWAP && dragType == this.chiselSlot) {
                return null;
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void func_75134_a(EntityPlayer entityplayer) {
        this.inventoryChisel.clearItems();
        super.func_75134_a(entityplayer);
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.inventoryChisel.func_70300_a(entityplayer);
    }

    public ItemStack func_82846_b(EntityPlayer entity, int slotIdx) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIdx);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slotIdx > this.getInventoryChisel().size) {
                if (!this.func_75135_a(itemstack1, this.getInventoryChisel().size, this.getInventoryChisel().size + 1, false)) {
                    return null;
                }
            } else {
                if (slotIdx < this.getInventoryChisel().size + 1) {
                    ItemStack tempStack = entity.field_71071_by.func_70445_o();
                    entity.field_71071_by.func_70437_b(itemstack1.func_77946_l());
                    slot.func_82870_a(entity, itemstack1);
                    itemstack1 = entity.field_71071_by.func_70445_o();
                    entity.field_71071_by.func_70437_b(tempStack);
                }
                if (!this.func_75135_a(itemstack1, this.getInventoryChisel().size + 1, this.getInventoryChisel().size + 1 + 36, true)) {
                    return null;
                }
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            if (slotIdx >= this.getInventoryChisel().size) {
                slot.func_82870_a(entity, itemstack1);
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
                return null;
            }
            slot.func_75215_d(itemstack1);
            return itemstack1;
        }
        return itemstack;
    }

    public void onChiselSlotChanged() {
        NBTUtil.setChiselTarget(this.chisel, this.inventoryChisel.getStackInSpecialSlot());
    }

    public void onChiselBroken() {
        if (!this.getInventoryPlayer().field_70458_d.field_70170_p.field_72995_K) {
            this.getInventoryPlayer().field_70458_d.func_71019_a(this.inventoryChisel.getStackInSpecialSlot(), false);
        }
    }

    public InventoryChiselSelection getInventoryChisel() {
        return this.inventoryChisel;
    }

    public InventoryPlayer getInventoryPlayer() {
        return this.inventoryPlayer;
    }

    public int getChiselSlot() {
        return this.chiselSlot;
    }

    public ItemStack getChisel() {
        return this.chisel;
    }

    public ICarvingRegistry getCarving() {
        return this.carving;
    }
}

