/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.block;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import team.chisel.api.block.BlockProvider;
import team.chisel.api.block.ChiselRecipe;
import team.chisel.api.block.VariationData;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.client.render.ChiselModelRegistry;
import team.chisel.common.init.BlockRegistry;

@ParametersAreNonnullByDefault
public class ChiselBlockBuilder<T extends Block> {
    private final Material material;
    private final String domain;
    private final String blockName;
    @Nullable
    private SoundType sound;
    private int curIndex;
    private List<VariationBuilder<T>> variations;
    private BlockProvider<T> provider;
    private String parentFolder;
    private List<String> oreStrings = new ArrayList<String>();
    @Nullable
    private String group;
    private boolean opaque = true;
    private static final Consumer<?> NO_ACTION = o -> {};

    protected ChiselBlockBuilder(Material material, String domain, String blockName, BlockProvider<T> provider) {
        this.material = material;
        this.domain = domain;
        this.blockName = blockName;
        this.provider = provider;
        this.parentFolder = blockName;
        this.variations = new ArrayList<VariationBuilder<T>>();
    }

    public void addOreDict(String oreDict) {
        this.oreStrings.add(oreDict);
    }

    public VariationBuilder<T> newVariation(String name) {
        return this.newVariation(name, Optional.ofNullable(this.group).orElse(this.blockName));
    }

    public VariationBuilder<T> newVariation(String name, String group) {
        VariationBuilder builder = new VariationBuilder(this, name, group, this.curIndex);
        builder.opaque(this.opaque);
        ++this.curIndex;
        return builder;
    }

    public T[] build() {
        return this.build(NO_ACTION);
    }

    public T[] build(Consumer<? super T> after) {
        if (this.variations.size() == 0) {
            throw new IllegalArgumentException("Must have at least one variation!");
        }
        VariationData[] vars = new VariationData[this.variations.size()];
        for (int i = 0; i < this.variations.size(); ++i) {
            vars[i] = ((VariationBuilder)this.variations.get(i)).doBuild();
        }
        VariationData[][] data = BlockRegistry.splitVariationArray(vars);
        Block[] ret = (Block[])Array.newInstance(this.provider.getBlockClass(), data.length);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.provider.createBlock(this.material, i, vars.length, data[i]);
            ret[i].setRegistryName(this.blockName + (i == 0 ? "" : Integer.valueOf(i)));
            ret[i].func_149663_c(this.domain + '.' + this.blockName);
            ret[i].func_149711_c(1.0f);
            if (this.sound != null) {
                ret[i].func_149672_a(this.sound);
            }
            GameRegistry.register((IForgeRegistryEntry)ret[i]);
            GameRegistry.register((IForgeRegistryEntry)this.provider.createItemBlock(ret[i]));
            after.accept(ret[i]);
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                ChiselModelRegistry.INSTANCE.register(ret[i]);
            }
            for (int j = 0; j < data[i].length; ++j) {
                if (data[i][j].group == null) continue;
                VariationBuilder<T> v = this.variations.get(data[i][j].index);
                CarvingUtils.getChiselRegistry().addVariation(data[i][j].group, ret[i].func_176203_a(j), ((VariationBuilder)v).order);
                if (this.oreStrings.isEmpty()) continue;
                for (String oreEntry : this.oreStrings) {
                    OreDictionary.registerOre((String)oreEntry, (ItemStack)new ItemStack(ret[i], 1, j));
                }
            }
        }
        return ret;
    }

    public ChiselBlockBuilder<T> setSound(@Nullable SoundType sound) {
        this.sound = sound;
        return this;
    }

    public ChiselBlockBuilder<T> setCurIndex(int curIndex) {
        this.curIndex = curIndex;
        return this;
    }

    public ChiselBlockBuilder<T> setVariations(List<VariationBuilder<T>> variations) {
        this.variations = variations;
        return this;
    }

    public ChiselBlockBuilder<T> setProvider(BlockProvider<T> provider) {
        this.provider = provider;
        return this;
    }

    public ChiselBlockBuilder<T> setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
        return this;
    }

    public ChiselBlockBuilder<T> setOreStrings(List<String> oreStrings) {
        this.oreStrings = oreStrings;
        return this;
    }

    public ChiselBlockBuilder<T> setGroup(@Nullable String group) {
        this.group = group;
        return this;
    }

    public ChiselBlockBuilder<T> opaque(boolean opaque) {
        this.opaque = opaque;
        return this;
    }

    public static class VariationBuilder<T extends Block> {
        private ChiselBlockBuilder<T> parent;
        private String name;
        private String group;
        private int index;
        @Nullable
        private ChiselRecipe recipe;
        @Nullable
        private ItemStack smeltedFrom;
        private int amountSmelted;
        private int order;
        private boolean opaque;

        private VariationBuilder(ChiselBlockBuilder<T> parent, String name, String group, int index) {
            this.parent = parent;
            this.name = name;
            this.group = group;
            this.index = index;
        }

        public VariationBuilder<T> setSmeltRecipe(ItemStack smeltedFrom, int amountSmelted) {
            this.smeltedFrom = smeltedFrom;
            this.amountSmelted = amountSmelted;
            return this;
        }

        public ChiselBlockBuilder<T> buildVariation() {
            ((ChiselBlockBuilder)this.parent).variations.add(this);
            return this.parent;
        }

        public VariationBuilder<T> next(String name) {
            return this.buildVariation().newVariation(name);
        }

        public VariationBuilder<T> next(String name, String group) {
            return this.buildVariation().newVariation(name, group);
        }

        public T[] build() {
            return this.buildVariation().build();
        }

        public T[] build(Consumer<? super T> after) {
            return this.buildVariation().build(after);
        }

        private VariationData doBuild() {
            return new VariationData(this.name, ((ChiselBlockBuilder)this.parent).parentFolder + "/" + this.name, this.group, this.recipe, this.smeltedFrom, this.amountSmelted, this.index, this.opaque);
        }

        public VariationBuilder<T> addOreDict(String oreDict) {
            this.parent.addOreDict(oreDict);
            return this;
        }

        public VariationBuilder<T> setRecipe(@Nullable ChiselRecipe recipe) {
            this.recipe = recipe;
            return this;
        }

        public VariationBuilder<T> setOrder(int order) {
            this.order = order;
            return this;
        }

        public VariationBuilder<T> opaque(boolean opaque) {
            this.opaque = opaque;
            return this;
        }
    }
}

