/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLNetworkException;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.helpers.Integers;

public class FMLProxyPacket
implements fj<et> {
    final String channel;
    private Side target;
    private final eq payload;
    private et netHandler;
    private NetworkDispatcher dispatcher;
    private static Multiset<String> badPackets = ConcurrentHashMultiset.create();
    private static int packetCountWarning = Integers.parseInt((String)System.getProperty("fml.badPacketCounter", "100"), (int)100);
    static final int PART_SIZE = 0xFFFFB0;
    public static final int MAX_LENGTH = -16797616;

    public FMLProxyPacket(gl original) {
        this(original.b(), original.a());
        this.target = Side.CLIENT;
    }

    public FMLProxyPacket(it original) {
        this(original.b(), original.a());
        this.target = Side.SERVER;
    }

    public FMLProxyPacket(eq payload, String channel) {
        this.channel = channel;
        this.payload = payload;
    }

    public void a(eq packetbuffer) throws IOException {
    }

    public void b(eq packetbuffer) throws IOException {
    }

    public void a(et inethandler) {
        this.netHandler = inethandler;
        FMLEmbeddedChannel internalChannel = NetworkRegistry.INSTANCE.getChannel(this.channel, this.target);
        if (internalChannel != null) {
            internalChannel.attr(NetworkRegistry.NET_HANDLER).set((Object)this.netHandler);
            try {
                if (internalChannel.writeInbound(new Object[]{this})) {
                    badPackets.add((Object)this.channel);
                    if (badPackets.size() % packetCountWarning == 0) {
                        FMLLog.severe("Detected ongoing potential memory leak. %d packets have leaked. Top offenders", badPackets.size());
                        int i = 0;
                        for (Multiset.Entry s : Multisets.copyHighestCountFirst(badPackets).entrySet()) {
                            if (i++ > 10) break;
                            FMLLog.severe("\t %s : %d", s.getElement(), s.getCount());
                        }
                    }
                }
                internalChannel.inboundMessages().clear();
            }
            catch (FMLNetworkException ne) {
                FMLLog.log(Level.ERROR, ne, "There was a network exception handling a packet on channel %s", this.channel);
                this.dispatcher.rejectHandshake(ne.getMessage());
            }
            catch (Throwable t) {
                FMLLog.log(Level.ERROR, t, "There was a critical exception handling a packet on channel %s", this.channel);
                this.dispatcher.rejectHandshake("A fatal error has occurred, this connection is terminated");
            }
        }
    }

    public String channel() {
        return this.channel;
    }

    public ByteBuf payload() {
        return this.payload;
    }

    public et handler() {
        return this.netHandler;
    }

    public fj<ij> toC17Packet() {
        return new it(this.channel, this.payload);
    }

    public List<fj<fm>> toS3FPackets() throws IOException {
        ArrayList ret = Lists.newArrayList();
        byte[] data = this.payload.array();
        if (data.length < 0xFFFFB0) {
            ret.add(new gl(this.channel, new eq(this.payload.duplicate())));
        } else {
            int parts = (int)Math.ceil((double)data.length / 1.6777135E7);
            if (parts > 255) {
                throw new IllegalArgumentException("Payload may not be larger than -16797616 bytes");
            }
            eq preamble = new eq(Unpooled.buffer());
            preamble.a(this.channel);
            preamble.writeByte(parts);
            preamble.writeInt(data.length);
            ret.add(new gl("FML|MP", preamble));
            int offset = 0;
            for (int x = 0; x < parts; ++x) {
                int length = Math.min(0xFFFFB0, data.length - offset + 1);
                byte[] tmp = new byte[length];
                tmp[0] = (byte)(x & 0xFF);
                System.arraycopy(data, offset, tmp, 1, tmp.length - 1);
                offset += tmp.length - 1;
                ret.add(new gl("FML|MP", new eq(Unpooled.wrappedBuffer((byte[])tmp))));
            }
        }
        return ret;
    }

    public void setTarget(Side target) {
        this.target = target;
    }

    public void setDispatcher(NetworkDispatcher networkDispatcher) {
        this.dispatcher = networkDispatcher;
    }

    public eo getOrigin() {
        return this.dispatcher != null ? this.dispatcher.manager : null;
    }

    public NetworkDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Side getTarget() {
        return this.target;
    }

    public FMLProxyPacket copy() {
        FMLProxyPacket pkt = new FMLProxyPacket(new eq(this.payload.duplicate()), this.channel);
        pkt.dispatcher = this.dispatcher;
        pkt.netHandler = this.netHandler;
        pkt.target = this.target;
        return pkt;
    }
}

