/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.util.ListUtils;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRateBar;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiIndustrialTurbine
extends GuiMekanism {
    public TileEntityTurbineCasing tileEntity;

    public GuiIndustrialTurbine(InventoryPlayer inventory, TileEntityTurbineCasing tentity) {
        super((TileEntityContainerBlock)tentity, (Container)new ContainerFilter(inventory, (TileEntityContainerBlock)tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiTurbineTab((IGuiWrapper)this, (TileEntity)this.tileEntity, GuiTurbineTab.TurbineTab.STAT, 6, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiIndustrialTurbine.png")));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)this.tileEntity, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiIndustrialTurbine.png"), 164, 16));
        this.guiElements.add(new GuiRateBar((IGuiWrapper)this, new GuiRateBar.IRateInfoHandler(){

            public String getTooltip() {
                return LangUtils.localize((String)"gui.steamInput") + ": " + ((SynchronizedTurbineData)GuiIndustrialTurbine.this.tileEntity.structure).lastSteamInput + " mB/t";
            }

            public double getLevel() {
                double rate = (double)((SynchronizedTurbineData)GuiIndustrialTurbine.this.tileEntity.structure).lowerVolume * ((double)((SynchronizedTurbineData)GuiIndustrialTurbine.this.tileEntity.structure).clientDispersers * MekanismConfig.generators.turbineDisperserGasFlow);
                if ((rate = Math.min(rate, (double)((SynchronizedTurbineData)GuiIndustrialTurbine.this.tileEntity.structure).vents * MekanismConfig.generators.turbineVentGasFlow)) == 0.0) {
                    return 0.0;
                }
                return (double)((SynchronizedTurbineData)GuiIndustrialTurbine.this.tileEntity.structure).lastSteamInput / rate;
            }
        }, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiIndustrialTurbine.png"), 40, 13));
        this.guiElements.add(new GuiEnergyInfo(new GuiElement.IInfoHandler(){

            public List<String> getInfo() {
                double energyMultiplier = MekanismConfig.general.maxEnergyPerSteam / 28.0 * (double)Math.min(((SynchronizedTurbineData)GuiIndustrialTurbine.this.tileEntity.structure).blades, ((SynchronizedTurbineData)GuiIndustrialTurbine.this.tileEntity.structure).coils * MekanismConfig.generators.turbineBladesPerCoil);
                return ListUtils.asList((Object[])new String[]{LangUtils.localize((String)"gui.storing") + ": " + MekanismUtils.getEnergyDisplay((double)GuiIndustrialTurbine.this.tileEntity.getEnergy()), LangUtils.localize((String)"gui.producing") + ": " + MekanismUtils.getEnergyDisplay((double)((double)((SynchronizedTurbineData)GuiIndustrialTurbine.this.tileEntity.structure).clientFlow * energyMultiplier)) + "/t"});
            }
        }, (IGuiWrapper)this, MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiIndustrialTurbine.png")));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"container.inventory"), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.tileEntity.func_70005_c_()) / 2, 5, 0x404040);
        double energyMultiplier = MekanismConfig.general.maxEnergyPerSteam / 28.0 * (double)Math.min(((SynchronizedTurbineData)this.tileEntity.structure).blades, ((SynchronizedTurbineData)this.tileEntity.structure).coils * MekanismConfig.generators.turbineBladesPerCoil);
        double rate = (double)((SynchronizedTurbineData)this.tileEntity.structure).lowerVolume * ((double)((SynchronizedTurbineData)this.tileEntity.structure).clientDispersers * MekanismConfig.generators.turbineDisperserGasFlow);
        rate = Math.min(rate, (double)((SynchronizedTurbineData)this.tileEntity.structure).vents * MekanismConfig.generators.turbineVentGasFlow);
        this.renderScaledText(LangUtils.localize((String)"gui.production") + ": " + MekanismUtils.getEnergyDisplay((double)((double)((SynchronizedTurbineData)this.tileEntity.structure).clientFlow * energyMultiplier)), 53, 26, 52480, 106);
        this.renderScaledText(LangUtils.localize((String)"gui.flowRate") + ": " + ((SynchronizedTurbineData)this.tileEntity.structure).clientFlow + " mB/t", 53, 35, 52480, 106);
        this.renderScaledText(LangUtils.localize((String)"gui.capacity") + ": " + ((SynchronizedTurbineData)this.tileEntity.structure).getFluidCapacity() + " mB", 53, 44, 52480, 106);
        this.renderScaledText(LangUtils.localize((String)"gui.maxFlow") + ": " + rate + " mB/t", 53, 53, 52480, 106);
        String name = this.chooseByMode(((SynchronizedTurbineData)this.tileEntity.structure).dumpMode, LangUtils.localize((String)"gui.idle"), LangUtils.localize((String)"gui.dumping"), LangUtils.localize((String)"gui.dumping_excess"));
        this.renderScaledText(name, 156 - (int)((float)this.field_146289_q.func_78256_a(name) * this.getNeededScale(name, 66)), 73, 0x404040, 66);
        if (xAxis >= 7 && xAxis <= 39 && yAxis >= 14 && yAxis <= 72) {
            this.func_146279_a(((SynchronizedTurbineData)this.tileEntity.structure).fluidStored != null ? LangUtils.localizeFluidStack((FluidStack)((SynchronizedTurbineData)this.tileEntity.structure).fluidStored) + ": " + ((SynchronizedTurbineData)this.tileEntity.structure).fluidStored.amount + "mB" : LangUtils.localize((String)"gui.empty"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiIndustrialTurbine.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int displayInt = this.chooseByMode(((SynchronizedTurbineData)this.tileEntity.structure).dumpMode, 142, 150, 158);
        this.func_73729_b(guiWidth + 160, guiHeight + 73, 176, displayInt, 8, 8);
        if (this.tileEntity.getScaledFluidLevel(58) > 0) {
            this.displayGauge(7, 14, this.tileEntity.getScaledFluidLevel(58), ((SynchronizedTurbineData)this.tileEntity.structure).fluidStored, 0);
            this.displayGauge(23, 14, this.tileEntity.getScaledFluidLevel(58), ((SynchronizedTurbineData)this.tileEntity.structure).fluidStored, 1);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    public void displayGauge(int xPos, int yPos, int scale, FluidStack fluid, int side) {
        int renderRemaining;
        if (fluid == null) {
            return;
        }
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        int start = 0;
        do {
            renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            this.field_146297_k.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
            this.func_175175_a(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, MekanismRenderer.getFluidTexture((Fluid)fluid.getFluid(), (MekanismRenderer.FluidType)MekanismRenderer.FluidType.STILL), 16, 16 - (16 - renderRemaining));
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiIndustrialTurbine.png"));
        this.func_73729_b(guiWidth + xPos, guiHeight + yPos, 176, side == 0 ? 0 : 54, 16, 54);
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        int xAxis = x - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = y - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis > 160 && xAxis < 169 && yAxis > 73 && yAxis < 82) {
            ArrayList<Byte> data = new ArrayList<Byte>();
            data.add((byte)0);
            Mekanism.packetHandler.sendToServer((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this.tileEntity), data));
            SoundHandler.playSound((SoundEvent)SoundEvents.field_187909_gi);
        }
    }

    private <T> T chooseByMode(TileEntityGasTank.GasMode dumping, T idleOption, T dumpingOption, T dumpingExcessOption) {
        if (dumping.equals((Object)TileEntityGasTank.GasMode.IDLE)) {
            return idleOption;
        }
        if (dumping.equals((Object)TileEntityGasTank.GasMode.DUMPING)) {
            return dumpingOption;
        }
        if (dumping.equals((Object)TileEntityGasTank.GasMode.DUMPING_EXCESS)) {
            return dumpingExcessOption;
        }
        return idleOption;
    }
}

