/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile.routing;

import WayofTime.bloodmagic.item.inventory.ItemInventory;
import WayofTime.bloodmagic.tile.routing.TileRoutingNode;
import WayofTime.bloodmagic.util.GhostItemHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;

public class TileFilteredRoutingNode
extends TileRoutingNode
implements ISidedInventory {
    public int currentActiveSlot = 0;
    public int[] priorities = new int[6];
    public ItemInventory itemInventory = new ItemInventory(null, 9, "");

    public TileFilteredRoutingNode(int size, String name) {
        super(size, name);
    }

    public ItemStack getFilterStack(EnumFacing side) {
        int index = side.func_176745_a();
        return this.func_70301_a(index);
    }

    public void setGhostItemAmount(int ghostItemSlot, int amount) {
        ItemStack stack = this.itemInventory.func_70301_a(ghostItemSlot);
        if (stack != null) {
            GhostItemHelper.setItemGhostAmount(stack, amount);
        }
        this.func_70296_d();
    }

    @Override
    public boolean isInventoryConnectedToSide(EnumFacing side) {
        return true;
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.currentActiveSlot = tag.func_74762_e("currentSlot");
        this.priorities = tag.func_74759_k("prioritiesPeople");
        if (this.priorities.length != 6) {
            this.priorities = new int[6];
        }
        if (!tag.func_74767_n("updated")) {
            NBTTagList tags = tag.func_150295_c("Items", 10);
            this.inventory = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                if (this.isSyncedSlot(i)) continue;
                NBTTagCompound data = tags.func_150305_b(i);
                byte j = data.func_74771_c("Slot");
                if (j == 0) {
                    this.inventory[this.currentActiveSlot] = ItemStack.func_77949_a((NBTTagCompound)data);
                    continue;
                }
                if (j < 1 || j >= this.inventory.length + 1) continue;
                this.inventory[j - 1] = ItemStack.func_77949_a((NBTTagCompound)data);
            }
        }
        this.itemInventory = new ItemInventory(this.func_70301_a(this.currentActiveSlot), 9, "");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        tag.func_74768_a("currentSlot", this.currentActiveSlot);
        tag.func_74783_a("prioritiesPeople", this.priorities);
        tag.func_74757_a("updated", true);
        return tag;
    }

    public void swapFilters(int requestedSlot) {
        this.currentActiveSlot = requestedSlot;
        this.itemInventory.initializeInventory(this.func_70301_a(this.currentActiveSlot));
        this.func_70296_d();
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public int getPriority(EnumFacing side) {
        return this.priorities[side.func_176745_a()];
    }

    public void incrementCurrentPriotiryToMaximum(int max) {
        this.priorities[this.currentActiveSlot] = Math.min(this.priorities[this.currentActiveSlot] + 1, max);
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void decrementCurrentPriority() {
        this.priorities[this.currentActiveSlot] = Math.max(this.priorities[this.currentActiveSlot] - 1, 0);
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }
}

