/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.util;

import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import com.whammich.sstow.SoulShardsTOW;
import com.whammich.sstow.api.ISoulShard;
import com.whammich.sstow.api.ShardHelper;
import com.whammich.sstow.api.event.ShardTierChangeEvent;
import com.whammich.sstow.shade.lib.util.helper.TextHelper;
import com.whammich.sstow.util.TierHandler;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class Utils {
    @Nullable
    public static ItemStack getShardFromInv(EntityPlayer player, String entity) {
        ItemStack ret = null;
        ItemStack offhand = player.func_184592_cb();
        if (offhand != null && offhand.func_77973_b() instanceof ISoulShard) {
            if (!ShardHelper.isBound(offhand)) {
                ret = offhand;
            } else if (ShardHelper.getBoundEntity(offhand).equals(entity)) {
                return offhand;
            }
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ISoulShard) || Utils.hasMaxedKills(stack)) continue;
            if (!ShardHelper.isBound(stack) && ret == null) {
                ret = stack;
                continue;
            }
            if (!ShardHelper.getBoundEntity(stack).equals(entity)) continue;
            return stack;
        }
        return ret;
    }

    public static void increaseShardKillCount(ItemStack shard, int amount) {
        if (!shard.func_77942_o() || Utils.hasMaxedKills(shard)) {
            return;
        }
        ShardHelper.setKillsForShard(shard, Utils.getClampedKillCount(ShardHelper.getKillsFromShard(shard) + amount));
        Utils.checkAndFixShard(shard);
    }

    public static void checkAndFixShard(ItemStack shard) {
        if (!Utils.isShardValid(shard) && !MinecraftForge.EVENT_BUS.post((Event)new ShardTierChangeEvent(shard, Utils.getCorrectTier(shard)))) {
            ShardHelper.setTierForShard(shard, Utils.getCorrectTier(shard));
        }
    }

    public static boolean isShardValid(ItemStack shard) {
        int tier;
        int kills = ShardHelper.getKillsFromShard(shard);
        return kills >= TierHandler.getMinKills(tier = ShardHelper.getTierFromShard(shard)) && kills <= TierHandler.getMaxKills(tier);
    }

    public static int getCorrectTier(ItemStack shard) {
        int kills = ShardHelper.getKillsFromShard(shard);
        for (int i = 0; i <= TierHandler.tiers.size(); ++i) {
            if (kills < TierHandler.getMinKills(i) || kills > TierHandler.getMaxKills(i)) continue;
            return i;
        }
        SoulShardsTOW.instance.getLogHelper().error("Soul shard has an incorrect kill counter of: {}", kills);
        return 0;
    }

    public static boolean hasMaxedKills(ItemStack shard) {
        return ShardHelper.isBound(shard) && ShardHelper.getKillsFromShard(shard) >= TierHandler.getMaxKills(TierHandler.tiers.size() - 1);
    }

    public static ItemStack setMaxedKills(ItemStack shard) {
        ShardHelper.setKillsForShard(shard, TierHandler.getMaxKills(TierHandler.tiers.size() - 1));
        return shard;
    }

    public static String getEntityNameTranslated(String unlocName) {
        if (unlocName.equals("Wither Skeleton")) {
            return unlocName;
        }
        return TextHelper.localize("entity." + unlocName + ".name", new Object[0]);
    }

    private static int getClampedKillCount(int amount) {
        return MathHelper.func_76125_a((int)amount, (int)0, (int)TierHandler.getMaxKills(TierHandler.tiers.size() - 1));
    }

    public static boolean isCageBorn(EntityLivingBase living) {
        return living.getEntityData().func_74764_b("SSTOW") && living.getEntityData().func_74767_n("SSTOW");
    }

    public static int getBlockLightLevel(World world, BlockPos pos, boolean day) {
        return world.func_72964_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_177443_a(pos, day ? 0 : 16);
    }

    public static boolean isOwnerOnline(String owner) {
        if (Strings.isNullOrEmpty((String)owner) || FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return false;
        }
        String username = UsernameCache.getLastKnownUsername((UUID)UUID.fromString(owner));
        for (GameProfile profile : FMLCommonHandler.instance().getMinecraftServerInstance().func_152357_F()) {
            if (!profile.getName().equals(username)) continue;
            return true;
        }
        return false;
    }

    public static void notifyUpdateBasic(World world, BlockPos pos) {
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
    }
}

