/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.util;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;

public class TierHandler {
    public static final Tier BLANK_TIER = new Tier(0, 0, true, false, false, 0, 0);
    public static Map<Integer, Tier> tiers = new HashMap<Integer, Tier>();
    public static int maxTier = 0;

    public static Tier getTier(int tier) {
        return tiers.get(tier) == null ? BLANK_TIER : tiers.get(tier);
    }

    public static int getMinKills(int tier) {
        return TierHandler.getTier(tier).getMinKills();
    }

    public static int getMaxKills(int tier) {
        return TierHandler.getTier(tier).getMaxKills();
    }

    public static int getSpawnAmount(int tier) {
        return TierHandler.getTier(tier).getSpawnAmount();
    }

    public static int getCooldown(int tier) {
        return TierHandler.getTier(tier).getCooldown();
    }

    public static boolean checksPlayer(int tier) {
        return TierHandler.getTier(tier).isCheckPlayer();
    }

    public static boolean checksLight(int tier) {
        return TierHandler.getTier(tier).isCheckLight();
    }

    public static boolean checksRedstone(int tier) {
        return TierHandler.getTier(tier).isCheckRedstone();
    }

    public static class Tier {
        private final int minKills;
        private final int maxKills;
        private final boolean checkPlayer;
        private final boolean checkLight;
        private final boolean checkRedstone;
        private final int spawnAmount;
        private final int cooldown;

        @ConstructorProperties(value={"minKills", "maxKills", "checkPlayer", "checkLight", "checkRedstone", "spawnAmount", "cooldown"})
        public Tier(int minKills, int maxKills, boolean checkPlayer, boolean checkLight, boolean checkRedstone, int spawnAmount, int cooldown) {
            this.minKills = minKills;
            this.maxKills = maxKills;
            this.checkPlayer = checkPlayer;
            this.checkLight = checkLight;
            this.checkRedstone = checkRedstone;
            this.spawnAmount = spawnAmount;
            this.cooldown = cooldown;
        }

        public int getMinKills() {
            return this.minKills;
        }

        public int getMaxKills() {
            return this.maxKills;
        }

        public boolean isCheckPlayer() {
            return this.checkPlayer;
        }

        public boolean isCheckLight() {
            return this.checkLight;
        }

        public boolean isCheckRedstone() {
            return this.checkRedstone;
        }

        public int getSpawnAmount() {
            return this.spawnAmount;
        }

        public int getCooldown() {
            return this.cooldown;
        }

        public String toString() {
            return "TierHandler.Tier(minKills=" + this.getMinKills() + ", maxKills=" + this.getMaxKills() + ", checkPlayer=" + this.isCheckPlayer() + ", checkLight=" + this.isCheckLight() + ", checkRedstone=" + this.isCheckRedstone() + ", spawnAmount=" + this.getSpawnAmount() + ", cooldown=" + this.getCooldown() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tier)) {
                return false;
            }
            Tier other = (Tier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMinKills() != other.getMinKills()) {
                return false;
            }
            if (this.getMaxKills() != other.getMaxKills()) {
                return false;
            }
            if (this.isCheckPlayer() != other.isCheckPlayer()) {
                return false;
            }
            if (this.isCheckLight() != other.isCheckLight()) {
                return false;
            }
            if (this.isCheckRedstone() != other.isCheckRedstone()) {
                return false;
            }
            if (this.getSpawnAmount() != other.getSpawnAmount()) {
                return false;
            }
            return this.getCooldown() == other.getCooldown();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tier;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinKills();
            result = result * 59 + this.getMaxKills();
            result = result * 59 + (this.isCheckPlayer() ? 79 : 97);
            result = result * 59 + (this.isCheckLight() ? 79 : 97);
            result = result * 59 + (this.isCheckRedstone() ? 79 : 97);
            result = result * 59 + this.getSpawnAmount();
            result = result * 59 + this.getCooldown();
            return result;
        }
    }
}

