/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.tile;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.whammich.sstow.ConfigHandler;
import com.whammich.sstow.SoulShardsTOW;
import com.whammich.sstow.api.ISoulCage;
import com.whammich.sstow.api.ShardHelper;
import com.whammich.sstow.api.SoulShardsAPI;
import com.whammich.sstow.api.event.CageSpawnEvent;
import com.whammich.sstow.item.ItemSoulShard;
import com.whammich.sstow.shade.lib.annot.Handler;
import com.whammich.sstow.shade.lib.util.helper.ItemHelper;
import com.whammich.sstow.tile.TileInventory;
import com.whammich.sstow.util.EntityMapper;
import com.whammich.sstow.util.TierHandler;
import com.whammich.sstow.util.Utils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Handler
public class TileEntityCage
extends TileInventory
implements ITickable,
ISoulCage {
    public static final String TIER = "tier";
    public static final String ACTIVE_TIME = "activeTime";
    public static final String ENT_NAME = "entName";
    public static final String OWNER = "owner";
    public static final String SSTOW = "SSTOW";
    private int activeTime;
    private int tier;
    private String entName = "";
    private String owner = "";

    public TileEntityCage() {
        super(1, "cage");
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.func_70301_a(0) != null) {
            ItemStack shard = this.func_70301_a(0);
            this.setEntName(ShardHelper.getBoundEntity(shard));
            this.setTier(ShardHelper.getTierFromShard(shard));
        } else {
            this.reset();
        }
        if (!this.canSpawn()) {
            this.setActiveState(false);
            return;
        }
        ++this.activeTime;
        this.setActiveState(true);
        if (this.activeTime % this.getCooldown() == 0) {
            this.spawnEntities(this.getSpawnAmount(), this.getEntName());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tier = tagCompound.func_74762_e(TIER);
        this.entName = tagCompound.func_74779_i(ENT_NAME);
        this.activeTime = tagCompound.func_74762_e(ACTIVE_TIME);
        this.owner = tagCompound.func_74779_i(OWNER);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a(TIER, this.tier);
        tagCompound.func_74778_a(ENT_NAME, this.entName);
        tagCompound.func_74768_a(ACTIVE_TIME, this.activeTime);
        tagCompound.func_74778_a(OWNER, this.owner);
        return tagCompound;
    }

    @Override
    public boolean canSpawn() {
        if (this.tier == 0 || Strings.isNullOrEmpty((String)this.entName)) {
            return false;
        }
        if (TierHandler.getTier(this.tier).equals(TierHandler.BLANK_TIER)) {
            return false;
        }
        if (ConfigHandler.requireOwnerOnline && !Utils.isOwnerOnline(this.owner)) {
            return false;
        }
        if (!ConfigHandler.entityList.contains(this.entName) && !ConfigHandler.enableBlacklistedSpawning) {
            return false;
        }
        if (!this.checkRedstone()) {
            return false;
        }
        if (TierHandler.checksPlayer(this.tier) && !this.isPlayerClose()) {
            return false;
        }
        if (!EntityMapper.specialCases.contains(this.entName) && SoulShardsAPI.isEntityBlacklisted(((Class)EntityList.field_75625_b.get(this.entName)).getCanonicalName())) {
            return false;
        }
        return EntityMapper.isEntityValid(this.entName);
    }

    @Override
    public int getCooldown() {
        return TierHandler.getCooldown(this.tier) * (ConfigHandler.cooldownUsesSeconds ? 20 : 1);
    }

    @Override
    public int getSpawnAmount() {
        return TierHandler.getSpawnAmount(this.tier);
    }

    public void reset() {
        this.func_174888_l();
        this.setTier(0);
        this.setEntName("");
        this.setActiveTime(0);
        this.setOwner("");
    }

    public boolean getActiveState() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (!state.func_177228_b().containsKey((Object)SoulShardsAPI.ACTIVE)) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)SoulShardsAPI.ACTIVE);
    }

    public void setActiveState(boolean activeState) {
        this.func_145831_w().func_175656_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)SoulShardsAPI.ACTIVE, (Comparable)Boolean.valueOf(activeState)));
    }

    private void spawnEntities(int amount, String entName) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        block0: for (int i = 0; i < amount; ++i) {
            for (int attempts = 0; attempts < 5; ++attempts) {
                CageSpawnEvent event;
                double x = (double)this.func_174877_v().func_177958_n() + (this.func_145831_w().field_73012_v.nextDouble() - this.func_145831_w().field_73012_v.nextDouble()) * 4.0;
                double y = this.func_174877_v().func_177956_o() + this.func_145831_w().field_73012_v.nextInt(3) - 1;
                double z = (double)this.func_174877_v().func_177952_p() + (this.func_145831_w().field_73012_v.nextDouble() - this.func_145831_w().field_73012_v.nextDouble()) * 4.0;
                BlockPos spawnAt = new BlockPos(x, y, z);
                ActionResult<? extends EntityLiving> handlerResult = SoulShardsAPI.getEntityHandler(EntityMapper.getLivingClass(entName)).handleLiving(this.func_145831_w(), entName, spawnAt);
                if (handlerResult.func_188397_a() == EnumActionResult.FAIL) continue;
                EntityLiving entityLiving = (EntityLiving)handlerResult.func_188398_b();
                if (TierHandler.checksLight(this.tier) && !this.canSpawnInLight(entityLiving, entityLiving.func_180425_c())) continue;
                entityLiving.func_70012_b(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, MathHelper.func_76142_g((float)(this.func_145831_w().field_73012_v.nextFloat() * 360.0f)), 0.0f);
                entityLiving.getEntityData().func_74757_a(SSTOW, true);
                entityLiving.field_98038_p = true;
                entityLiving.func_110163_bv();
                if (!this.canSpawnAtCoords(entityLiving) || entityLiving.field_70128_L || this.hasReachedSpawnCap(entityLiving) || !ConfigHandler.enableBosses && !entityLiving.func_184222_aU() || MinecraftForge.EVENT_BUS.post((Event)(event = new CageSpawnEvent(this.func_70301_a(0), this.getOwner(), entityLiving)))) continue;
                this.func_145831_w().func_72838_d((Entity)entityLiving);
                if (handlerResult.func_188397_a() != EnumActionResult.SUCCESS) continue block0;
                entityLiving.func_180482_a(this.func_145831_w().func_175649_E(spawnAt), null);
                continue block0;
            }
        }
        SoulShardsTOW.debug("Spawned {} entities in {}", amount, stopwatch.stop());
    }

    private boolean canSpawnAtCoords(EntityLiving ent) {
        return ent.func_70058_J();
    }

    private boolean isRedstoned() {
        return this.func_145831_w().func_175640_z(this.func_174877_v());
    }

    private boolean canSpawnInLight(EntityLiving entityLiving, BlockPos pos) {
        return !(entityLiving instanceof EntityMob) && !(entityLiving instanceof IMob) || Utils.getBlockLightLevel(this.func_145831_w(), pos, this.func_145831_w().func_72935_r()) <= 8;
    }

    private boolean isPlayerClose() {
        return this.func_145831_w().func_175636_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 16.0);
    }

    private boolean checkRedstone() {
        if (ConfigHandler.forceRedstoneRequirement) {
            return this.isRedstoned();
        }
        return !TierHandler.checksRedstone(this.getTier()) || !this.isRedstoned();
    }

    private boolean hasReachedSpawnCap(EntityLiving living) {
        AxisAlignedBB box = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 16), (double)(this.func_174877_v().func_177956_o() - 16), (double)(this.func_174877_v().func_177952_p() - 16), (double)(this.func_174877_v().func_177958_n() + 16), (double)(this.func_174877_v().func_177956_o() + 16), (double)(this.func_174877_v().func_177952_p() + 16));
        int mobCount = 0;
        for (EntityLiving entity : this.func_145831_w().func_72872_a(living.getClass(), box)) {
            if (!Utils.isCageBorn((EntityLivingBase)entity)) continue;
            ++mobCount;
        }
        return mobCount >= ConfigHandler.spawnCap;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == ItemHelper.getItem(ItemSoulShard.class) && ShardHelper.getTierFromShard(stack) > 0 && ShardHelper.isBound(stack);
    }

    @SubscribeEvent
    public void onDeath(LivingExperienceDropEvent event) {
        if (!ConfigHandler.enableExperienceDrop && Utils.isCageBorn(event.getEntityLiving())) {
            event.setDroppedExperience(0);
        }
    }

    public int getActiveTime() {
        return this.activeTime;
    }

    public int getTier() {
        return this.tier;
    }

    public String getEntName() {
        return this.entName;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setActiveTime(int activeTime) {
        this.activeTime = activeTime;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setEntName(String entName) {
        this.entName = entName;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }
}

