/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.util;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackWrapper {
    public final Item item;
    public final int stackSize;
    public final int meta;
    public NBTTagCompound nbtTag;

    public ItemStackWrapper(Item item, int stackSize, int meta) {
        this.item = item;
        this.stackSize = stackSize;
        this.meta = meta;
    }

    public ItemStackWrapper(Item item, int stackSize) {
        this(item, stackSize, 0);
    }

    public ItemStackWrapper(Item item) {
        this(item, 1, 0);
    }

    public ItemStackWrapper(Block block, int stackSize, int meta) {
        this(Item.func_150898_a((Block)block), stackSize, meta);
    }

    public ItemStackWrapper(Block block, int stackSize) {
        this(block, stackSize, 0);
    }

    public ItemStackWrapper(Block block) {
        this(block, 1, 0);
    }

    public ItemStack toStack() {
        return new ItemStack(this.item, this.stackSize, this.meta);
    }

    public String getDisplayName() {
        return this.toStack().func_82833_r();
    }

    public String toString() {
        return this.stackSize + "x" + this.item.func_77658_a() + "@" + this.meta;
    }

    public ItemStack toStack(int count) {
        ItemStack result = new ItemStack(this.item, count, this.meta);
        result.func_77982_d(this.nbtTag);
        return result;
    }

    public void setNbtTag(NBTTagCompound nbtTag) {
        this.nbtTag = nbtTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStackWrapper that = (ItemStackWrapper)o;
        if (this.stackSize != that.stackSize) {
            return false;
        }
        if (this.meta != that.meta) {
            return false;
        }
        if (this.item != null ? !this.item.equals(that.item) : that.item != null) {
            return false;
        }
        return this.nbtTag != null ? this.nbtTag.equals((Object)that.nbtTag) : that.nbtTag == null;
    }

    public int hashCode() {
        int result = this.item != null ? this.item.hashCode() : 0;
        result = 31 * result + this.stackSize;
        result = 31 * result + this.meta;
        result = 31 * result + (this.nbtTag != null ? this.nbtTag.hashCode() : 0);
        return result;
    }

    public static ItemStackWrapper getWrapper(ItemStack stack) {
        return new ItemStackWrapper(stack.func_77973_b(), stack.field_77994_a, stack.func_77952_i());
    }
}

