/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.json.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.whammich.sstow.shade.lib.json.JsonHelper;
import com.whammich.sstow.shade.lib.json.serialization.SerializerBase;
import java.lang.reflect.Type;
import net.minecraft.util.math.BlockPos;

public class SerializerBlockPos
extends SerializerBase<BlockPos> {
    public static final String X_COORD = "xCoord";
    public static final String Y_COORD = "yCoord";
    public static final String Z_COORD = "zCoord";
    public static final String X_OFF = "xOff";
    public static final String Y_OFF = "yOff";
    public static final String Z_OFF = "zOff";
    private final boolean offset;

    public SerializerBlockPos(boolean offset) {
        this.offset = offset;
    }

    public SerializerBlockPos() {
        this(false);
    }

    @Override
    public BlockPos deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        int x = JsonHelper.getInteger(json, this.offset ? X_OFF : X_COORD, 0);
        int y = JsonHelper.getInteger(json, this.offset ? Y_OFF : Y_COORD, 0);
        int z = JsonHelper.getInteger(json, this.offset ? Z_OFF : Z_COORD, 0);
        return new BlockPos(x, y, z);
    }

    @Override
    public JsonElement serialize(BlockPos src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(this.offset ? X_OFF : X_COORD, (Number)src.func_177958_n());
        jsonObject.addProperty(this.offset ? Y_OFF : Y_COORD, (Number)src.func_177956_o());
        jsonObject.addProperty(this.offset ? Z_OFF : Z_COORD, (Number)src.func_177952_p());
        return jsonObject;
    }

    @Override
    public Class<?> getType() {
        return BlockPos.class;
    }
}

