/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.block.base;

import com.whammich.sstow.shade.lib.block.property.PropertyString;
import com.whammich.sstow.shade.lib.block.property.UnlistedPropertyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockString
extends Block {
    private final int maxMeta;
    private final List<String> values;
    private final PropertyString stringProp;
    private final IUnlistedProperty unlistedStringProp;
    private final BlockStateContainer realBlockState;

    public BlockString(Material material, String[] values, String propName) {
        super(material);
        this.maxMeta = values.length - 1;
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].toLowerCase(Locale.ENGLISH);
        }
        this.values = Arrays.asList(values);
        this.stringProp = PropertyString.create(propName, values);
        this.unlistedStringProp = new UnlistedPropertyString(values, propName);
        this.realBlockState = this.createRealBlockState();
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.stringProp, (Comparable)((Object)values[0])));
        this.setupStates();
    }

    public BlockString(Material material, String propName, String ... values) {
        this(material, values, propName);
    }

    public BlockString(Material material, String[] values) {
        this(material, values, "type");
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.stringProp, (Comparable)((Object)this.values.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return this.values.indexOf(String.valueOf(state.func_177229_b((IProperty)this.stringProp)));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public BlockStateContainer func_176194_O() {
        return this.realBlockState;
    }

    public BlockStateContainer func_180661_e() {
        return Blocks.field_150350_a.func_176194_O();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        for (int i = 0; i < this.maxMeta + 1; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    private void setupStates() {
        this.func_180632_j(this.getExtendedBlockState().withProperty(this.unlistedStringProp, (Object)this.values.get(0)).func_177226_a((IProperty)this.stringProp, (Comparable)((Object)this.values.get(0))));
    }

    public ExtendedBlockState getBaseExtendedState() {
        return (ExtendedBlockState)this.func_176194_O();
    }

    public IExtendedBlockState getExtendedBlockState() {
        return (IExtendedBlockState)this.getBaseExtendedState().func_177621_b();
    }

    private BlockStateContainer createRealBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{this.stringProp}, new IUnlistedProperty[]{this.unlistedStringProp});
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public List<String> getValues() {
        return new ArrayList<String>(this.values);
    }

    public PropertyString getStringProp() {
        return this.stringProp;
    }

    public IUnlistedProperty getUnlistedStringProp() {
        return this.unlistedStringProp;
    }

    public BlockStateContainer getRealBlockState() {
        return this.realBlockState;
    }
}

