/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.item;

import com.google.common.base.Strings;
import com.whammich.sstow.ConfigHandler;
import com.whammich.sstow.SoulShardsTOW;
import com.whammich.sstow.api.ISoulShard;
import com.whammich.sstow.api.ISoulWeapon;
import com.whammich.sstow.api.ShardHelper;
import com.whammich.sstow.api.SoulShardsAPI;
import com.whammich.sstow.registry.ModEnchantments;
import com.whammich.sstow.shade.lib.annot.Handler;
import com.whammich.sstow.shade.lib.annot.ModItem;
import com.whammich.sstow.shade.lib.iface.IMeshProvider;
import com.whammich.sstow.shade.lib.util.BlockStack;
import com.whammich.sstow.shade.lib.util.helper.ItemHelper;
import com.whammich.sstow.shade.lib.util.helper.TextHelper;
import com.whammich.sstow.util.EntityMapper;
import com.whammich.sstow.util.TierHandler;
import com.whammich.sstow.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@ModItem(name="ItemSoulShard")
@Handler
public class ItemSoulShard
extends Item
implements ISoulShard,
IMeshProvider {
    public static List<Pair<BlockPos, BlockStack>> multiblock = new ArrayList<Pair<BlockPos, BlockStack>>();
    public static BlockStack originBlock = null;

    public ItemSoulShard() {
        this.func_77655_b("soulshardstow.shard");
        this.func_77637_a(SoulShardsTOW.soulShardsTab);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!Utils.hasMaxedKills(stack) && (tile = world.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
            if (ConfigHandler.allowSpawnerAbsorption) {
                WeightedSpawnerEntity spawnerEntity = (WeightedSpawnerEntity)ObfuscationReflectionHelper.getPrivateValue(MobSpawnerBaseLogic.class, (Object)((TileEntityMobSpawner)tile).func_145881_a(), (String[])new String[]{"randomEntity", "field_98282_f"});
                String name = spawnerEntity.func_185277_b().func_74779_i("id");
                EntityLiving ent = (EntityLiving)EntityList.func_75620_a((String)name, (World)world);
                if (ent == null) {
                    return EnumActionResult.FAIL;
                }
                if (!EntityMapper.isEntityValid(name) || SoulShardsAPI.isEntityBlacklisted(ent)) {
                    return EnumActionResult.FAIL;
                }
                if (ent instanceof EntitySkeleton) {
                    switch (((EntitySkeleton)ent).func_189771_df()) {
                        case STRAY: {
                            name = "Husk";
                            break;
                        }
                        case WITHER: {
                            name = "WitherSkeleton";
                        }
                    }
                }
                if (ent instanceof EntityZombie) {
                    switch (((EntityZombie)ent).func_189777_di()) {
                        case HUSK: {
                            name = "Husk";
                        }
                    }
                }
                if (ent instanceof EntityGuardian && ((EntityGuardian)ent).func_175461_cl()) {
                    name = "ElderGuardian";
                }
                if (ShardHelper.isBound(stack) && ShardHelper.getBoundEntity(stack).equals(name)) {
                    if (!world.field_72995_K) {
                        Utils.increaseShardKillCount(stack, ConfigHandler.spawnerAbsorptionBonus);
                    }
                    world.func_175655_b(pos, false);
                    return EnumActionResult.SUCCESS;
                }
            } else if (world.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextHelper.localizeEffect("chat.sstow.absorb.disabled", new Object[0])));
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ConfigHandler.displayDurabilityBar && ShardHelper.getKillsFromShard(stack) < TierHandler.getMaxKills(TierHandler.tiers.size() - 1);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ShardHelper.getKillsFromShard(stack) / (double)TierHandler.getTier(TierHandler.tiers.size() - 1).getMinKills();
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + (ShardHelper.isBound(stack) ? "" : ".unbound");
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() instanceof ISoulShard && newStack.func_77973_b() instanceof ISoulShard) {
            if (ShardHelper.getTierFromShard(oldStack) != ShardHelper.getTierFromShard(newStack)) {
                return true;
            }
            if (!ShardHelper.getBoundEntity(oldStack).equals(ShardHelper.getBoundEntity(newStack))) {
                return true;
            }
        }
        return slotChanged;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return Utils.hasMaxedKills(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List<ItemStack> list) {
        for (int i = 0; i <= TierHandler.tiers.size() - 1; ++i) {
            ItemStack stack = new ItemStack(item);
            ShardHelper.setKillsForShard(stack, TierHandler.getMinKills(i));
            ShardHelper.setTierForShard(stack, i);
            list.add(stack);
        }
        if (ConfigHandler.addShardsForAllMobs) {
            for (String ent : EntityMapper.entityList) {
                if (ent.equals("Wither Skeleton") || !ConfigHandler.ignoreBlacklistForTab && !EntityMapper.isEntityValid(ent)) continue;
                ItemStack stack = new ItemStack(item);
                Utils.setMaxedKills(stack);
                ShardHelper.setTierForShard(stack, TierHandler.tiers.size() - 1);
                ShardHelper.setBoundEntity(stack, ent);
                list.add(stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean bool) {
        if (ShardHelper.isBound(stack)) {
            String boundEnt = ShardHelper.getBoundEntity(stack);
            boolean disabled = !EntityMapper.specialCases.contains(boundEnt) ? !ConfigHandler.entityList.contains(boundEnt) || SoulShardsAPI.isEntityBlacklisted(((Class)EntityList.field_75625_b.get(boundEnt)).getCanonicalName()) : !ConfigHandler.entityList.contains(boundEnt);
            list.add((disabled ? TextFormatting.RED.toString() : "") + TextHelper.localizeEffect("tooltip.soulshardstow.bound", Utils.getEntityNameTranslated(boundEnt)));
        }
        if (ShardHelper.getKillsFromShard(stack) >= 0) {
            list.add(TextHelper.localizeEffect("tooltip.soulshardstow.kills", ShardHelper.getKillsFromShard(stack)));
        }
        list.add(TextHelper.localizeEffect("tooltip.soulshardstow.tier", ShardHelper.getTierFromShard(stack)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getMeshDefinition() {
        return new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (ShardHelper.isBound(stack)) {
                    return new ModelResourceLocation(new ResourceLocation("soulshardstow:item/ItemSoulShard"), "tier=" + ShardHelper.getTierFromShard(stack));
                }
                return new ModelResourceLocation(new ResourceLocation("soulshardstow:item/ItemSoulShard"), "tier=unbound");
            }
        };
    }

    @Override
    public List<String> getVariants() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("tier=unbound");
        for (int i = 0; i < TierHandler.tiers.size(); ++i) {
            ret.add("tier=" + i);
        }
        return ret;
    }

    @Override
    @Nullable
    public ResourceLocation getCustomLocation() {
        return null;
    }

    public static void buildMultiblock() {
        originBlock = new BlockStack(Blocks.field_150426_aN);
        multiblock.clear();
        multiblock.add((Pair<BlockPos, BlockStack>)Pair.of((Object)new BlockPos(0, 0, 0), (Object)new BlockStack(Blocks.field_150426_aN)));
        multiblock.add((Pair<BlockPos, BlockStack>)Pair.of((Object)new BlockPos(1, 0, 0), (Object)new BlockStack(Blocks.field_150371_ca)));
        multiblock.add((Pair<BlockPos, BlockStack>)Pair.of((Object)new BlockPos(-1, 0, 0), (Object)new BlockStack(Blocks.field_150371_ca)));
        multiblock.add((Pair<BlockPos, BlockStack>)Pair.of((Object)new BlockPos(0, 0, 1), (Object)new BlockStack(Blocks.field_150371_ca)));
        multiblock.add((Pair<BlockPos, BlockStack>)Pair.of((Object)new BlockPos(0, 0, -1), (Object)new BlockStack(Blocks.field_150371_ca)));
        multiblock.add((Pair<BlockPos, BlockStack>)Pair.of((Object)new BlockPos(1, 0, 1), (Object)new BlockStack(Blocks.field_150343_Z)));
        multiblock.add((Pair<BlockPos, BlockStack>)Pair.of((Object)new BlockPos(1, 0, -1), (Object)new BlockStack(Blocks.field_150343_Z)));
        multiblock.add((Pair<BlockPos, BlockStack>)Pair.of((Object)new BlockPos(-1, 0, 1), (Object)new BlockStack(Blocks.field_150343_Z)));
        multiblock.add((Pair<BlockPos, BlockStack>)Pair.of((Object)new BlockPos(-1, 0, -1), (Object)new BlockStack(Blocks.field_150343_Z)));
    }

    @SubscribeEvent
    public void onEntityKill(LivingDeathEvent event) {
        ItemStack shard;
        World world = event.getEntity().field_70170_p;
        if (world.field_72995_K || !(event.getEntity() instanceof EntityLiving) || !(event.getSource().func_76346_g() instanceof EntityPlayer) || event.getSource().func_76346_g() instanceof FakePlayer) {
            return;
        }
        EntityLiving dead = (EntityLiving)event.getEntity();
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        String entName = EntityList.func_75621_b((Entity)dead);
        if (Strings.isNullOrEmpty((String)entName)) {
            SoulShardsTOW.instance.getLogHelper().severe("Player killed an entity with no mapped name: {}", dead);
            return;
        }
        if (dead instanceof EntitySkeleton) {
            switch (((EntitySkeleton)dead).func_189771_df()) {
                case STRAY: {
                    entName = "Stray";
                    break;
                }
                case WITHER: {
                    entName = "WitherSkeleton";
                }
            }
        }
        if (dead instanceof EntityZombie) {
            switch (((EntityZombie)dead).func_189777_di()) {
                case HUSK: {
                    entName = "Husk";
                }
            }
        }
        if (dead instanceof EntityGuardian && ((EntityGuardian)dead).func_175461_cl()) {
            entName = "ElderGuardian";
        }
        if ((shard = Utils.getShardFromInv(player, entName)) == null) {
            return;
        }
        if (!ConfigHandler.entityList.contains(entName) || SoulShardsAPI.isEntityBlacklisted(dead)) {
            return;
        }
        if (!EntityMapper.isEntityValid(entName)) {
            return;
        }
        if (!ConfigHandler.countCageBornForShard && Utils.isCageBorn((EntityLivingBase)dead)) {
            return;
        }
        if (!ShardHelper.isBound(shard)) {
            ShardHelper.setBoundEntity(shard, entName);
        }
        int soulStealer = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.soulStealer, (ItemStack)player.func_184614_ca());
        soulStealer *= ConfigHandler.soulStealerBonus;
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ISoulWeapon) {
            soulStealer += ((ISoulWeapon)player.func_184614_ca().func_77973_b()).getBonusSouls(player.func_184614_ca());
        }
        Utils.increaseShardKillCount(shard, 1 + soulStealer);
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (multiblock.isEmpty()) {
            ItemSoulShard.buildMultiblock();
        }
        if (event.getItemStack() != null && ItemStack.func_179545_c((ItemStack)event.getItemStack(), (ItemStack)ConfigHandler.catalystItem) && originBlock.equals(BlockStack.getStackFromPos(event.getWorld(), event.getPos()))) {
            for (Pair<BlockPos, BlockStack> multiblockPair : multiblock) {
                BlockStack worldStack = BlockStack.getStackFromPos(event.getWorld(), event.getPos().func_177971_a((Vec3i)multiblockPair.getLeft()));
                if (((BlockStack)multiblockPair.getRight()).equals(worldStack)) continue;
                return;
            }
            for (Pair<BlockPos, BlockStack> multiblockPair : multiblock) {
                event.getWorld().func_175655_b(event.getPos().func_177971_a((Vec3i)multiblockPair.getLeft()), false);
            }
            if (!event.getWorld().field_72995_K) {
                EntityItem invItem = new EntityItem(event.getWorld(), event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u + 0.25, event.getEntityPlayer().field_70161_v, new ItemStack(ItemHelper.getItem(this.getClass()), 1, 0));
                event.getWorld().func_72838_d((Entity)invItem);
            }
            if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                if (event.getItemStack().field_77994_a > 1) {
                    --event.getItemStack().field_77994_a;
                } else {
                    event.getEntityPlayer().func_184611_a(event.getHand(), null);
                }
            }
            event.getEntityPlayer().func_184609_a(event.getHand());
            event.setCanceled(true);
        }
    }
}

