/*
 * Decompiled with CFR 0.152.
 */
package lib.utils;

import com.google.common.base.Function;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class RenderUtils {
    public static final Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        }
    };
    private static RenderItem renderItem;

    private RenderUtils() {
    }

    public static int getAverageColor(ItemStack stack) {
        TextureAtlasSprite sprite = RenderUtils.getSprite(stack);
        if (sprite == null) {
            return -1;
        }
        int pixelCount = 0;
        int[] data = sprite.func_147965_a(0)[0];
        int[] avgColor = new int[3];
        int k = 3;
        pixelCount = sprite.func_94216_b() * sprite.func_94211_a();
        for (int j = k; j < sprite.func_94216_b() - k; ++j) {
            for (int i = k; i < sprite.func_94211_a() - k; ++i) {
                int c = data[j * sprite.func_94211_a() + i];
                int r = c & 0xFF;
                int g = c >> 8 & 0xFF;
                int b = c >> 16 & 0xFF;
                avgColor[0] = avgColor[0] + r;
                avgColor[1] = avgColor[1] + g;
                avgColor[2] = avgColor[2] + b;
            }
        }
        for (int i = 0; i < 3; ++i) {
            avgColor[i] = avgColor[i] / pixelCount & 0xFF;
        }
        return avgColor[0] | avgColor[1] << 8 | avgColor[2] << 16 | 0xFF000000;
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getSprite(ItemStack stack) {
        if (renderItem == null) {
            renderItem = Minecraft.func_71410_x().func_175599_af();
        }
        return renderItem.func_184393_a(stack, null, null).func_177554_e();
    }

    public static void drawSelectionBox(EntityPlayer player, RayTraceResult movingObjectPositionIn, int execute, float partialTicks) {
        World world = player.func_130014_f_();
        if (execute == 0 && movingObjectPositionIn.field_72313_a == RayTraceResult.Type.BLOCK) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            BlockPos pos = movingObjectPositionIn.func_178782_a();
            IBlockState state = world.func_180495_p(pos);
            EnumFacing.Axis facing = player.func_174811_aO().func_176740_k();
            if (state.func_185904_a() != Material.field_151579_a && world.func_175723_af().func_177746_a(pos)) {
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                AxisAlignedBB block = state.func_185918_c(world, pos);
                double x = pos.func_177958_n();
                double y = block.field_72337_e;
                double z = pos.func_177952_p();
                for (int i = 1; i <= 4; ++i) {
                    for (int j = 1; j <= 2; ++j) {
                        AxisAlignedBB box = new AxisAlignedBB(x + 0.5 * (double)(j - 1), y, z + (double)i / 4.0 - 0.25, x + (double)j * 0.5, y, z + (double)i / 4.0).func_186662_g(0.002).func_72317_d(-d0, -d1, -d2);
                        RenderUtils.drawLine(box);
                    }
                }
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    private static void drawLine(AxisAlignedBB boundingBox) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181675_d();
        vertexbuffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
    }

    public static enum AveragingMode {
        FULL,
        H_EDGES_ONLY,
        V_EDGES_ONLY;

    }
}

