/*
 * Decompiled with CFR 0.152.
 */
package com.primetoxinz.stacksonstacks.render;

import com.primetoxinz.stacksonstacks.Config;
import com.primetoxinz.stacksonstacks.ingot.PartIngot;
import com.primetoxinz.stacksonstacks.render.CustomQuad;
import java.awt.Color;
import lib.render.ModelFactory;
import lib.render.SimpleBakedModel;
import lib.utils.RenderUtils;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class RenderIngot
extends ModelFactory<PartIngot> {
    public static ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("stacksonstacks", "blocks/ingot" + Config.textureVersion);
    private TextureAtlasSprite sprite;
    private VertexFormat format;

    public RenderIngot(VertexFormat format) {
        super(PartIngot.PROPERTY);
        this.format = format;
    }

    private void putVertex(CustomQuad.Builder builder, Vec3d normal, double x, double y, double z, float u, float v) {
        Color c = new Color(builder.getTint());
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, (float)x, (float)y, (float)z, 1.0f);
                    continue block6;
                }
                case COLOR: {
                    if (builder.getTint() == 0) {
                        builder.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                        continue block6;
                    }
                    builder.put(e, (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, 1.0f);
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        u = this.sprite.func_94214_a((double)u);
                        v = this.sprite.func_94207_b((double)v);
                        builder.put(e, u, v, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, (float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f);
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, EnumFacing side, int color) {
        Vec3d normal = new Vec3d(0.0, 0.0, 1.0);
        CustomQuad.Builder builder = new CustomQuad.Builder(this.format);
        builder.setTexture(this.sprite);
        builder.setQuadTint(color);
        builder.setApplyDiffuseLighting(false);
        if (side == EnumFacing.WEST || side == EnumFacing.NORTH || side == EnumFacing.UP) {
            this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f);
            this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, 16.0f);
            this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, 16.0f, 16.0f);
            this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, 16.0f, 0.0f);
        } else {
            this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f);
            this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 16.0f, 0.0f);
            this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, 16.0f, 16.0f);
            this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, 0.0f, 16.0f);
        }
        return builder.build();
    }

    public SimpleBakedModel createRectPrism(double x, double y, double z, float w, float h, float l, int color) {
        SimpleBakedModel model = new SimpleBakedModel(this);
        Vec3d vec = new Vec3d(x, y, z);
        float o = 0.025f;
        model.addQuad(null, this.createQuad(vec, vec.func_72441_c((double)w, 0.0, 0.0), vec.func_72441_c((double)w, 0.0, (double)l), vec.func_72441_c(0.0, 0.0, (double)l), EnumFacing.DOWN, color));
        vec = vec.func_72441_c(0.0, (double)h, 0.0);
        model.addQuad(null, this.createQuad(vec.func_72441_c((double)o, 0.0, (double)o), vec.func_72441_c((double)o, 0.0, (double)(l - o)), vec.func_72441_c((double)(w - o), 0.0, (double)(l - o)), vec.func_72441_c((double)(w - o), 0.0, (double)o), EnumFacing.UP, color));
        vec = new Vec3d(x, y, z);
        model.addQuad(null, this.createQuad(vec, vec.func_72441_c((double)o, (double)h, (double)o), vec.func_72441_c((double)(w - o), (double)h, (double)o), vec.func_72441_c((double)w, 0.0, 0.0), EnumFacing.NORTH, color));
        vec = vec.func_72441_c(0.0, 0.0, (double)l);
        model.addQuad(null, this.createQuad(vec, vec.func_72441_c((double)w, 0.0, 0.0), vec.func_72441_c((double)(w - o), (double)h, (double)(-o)), vec.func_72441_c((double)o, (double)h, (double)(-o)), EnumFacing.SOUTH, color));
        vec = new Vec3d(x, y, z);
        model.addQuad(null, this.createQuad(vec, vec.func_72441_c(0.0, 0.0, (double)l), vec.func_72441_c((double)o, (double)h, (double)(l - o)), vec.func_72441_c((double)o, (double)h, (double)o), EnumFacing.EAST, color));
        vec = vec.func_72441_c((double)w, 0.0, 0.0);
        model.addQuad(null, this.createQuad(vec, vec.func_72441_c((double)(-o), (double)h, (double)o), vec.func_72441_c((double)(-o), (double)h, (double)(l - o)), vec.func_72441_c(0.0, 0.0, (double)l), EnumFacing.WEST, color));
        return model;
    }

    @Override
    public IBakedModel bake(PartIngot ingot, boolean isItem, BlockRenderLayer layer) {
        ingot.type.initRender();
        TextureAtlasSprite tex = ingot.type.getSprite();
        this.sprite = tex != null ? tex : (TextureAtlasSprite)RenderUtils.textureGetter.apply((Object)DEFAULT_TEXTURE);
        Vec3d loc = ingot.location.getRelativeLocation();
        float o = 0.00625f;
        return this.createRectPrism(loc.field_72450_a + (double)o, loc.field_72448_b, loc.field_72449_c + (double)o, 0.5f - 2.0f * o, 0.125f, 0.25f - 2.0f * o, ingot.type.getColor());
    }

    @Override
    public PartIngot fromItemStack(ItemStack stack) {
        return null;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.sprite;
    }
}

