/*
 * Decompiled with CFR 0.152.
 */
package com.primetoxinz.stacksonstacks.logic;

import com.primetoxinz.stacksonstacks.Config;
import com.primetoxinz.stacksonstacks.logic.DummyStack;
import com.primetoxinz.stacksonstacks.logic.OreDictUtil;
import com.primetoxinz.stacksonstacks.render.RenderIngot;
import java.io.IOException;
import java.util.HashMap;
import lib.utils.RenderUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class IngotType {
    public static HashMap<DummyStack, Integer> colorCache = new HashMap();
    public static HashMap<DummyStack, TextureAtlasSprite> spriteCache = new HashMap();
    public ItemStack stack;
    public int color;
    public String spriteName;

    public IngotType(ItemStack stack) {
        if (stack != null) {
            stack = stack.func_77946_l();
            stack.field_77994_a = 1;
        }
        this.stack = stack;
        if (stack != null) {
            this.findColor();
            if (Config.useIngotBlockTexture) {
                this.findTexture();
            } else {
                this.spriteName = RenderIngot.DEFAULT_TEXTURE.toString();
            }
        }
    }

    public void findColor() {
        DummyStack dummy = this.getDummy();
        if (colorCache.containsKey(dummy)) {
            this.color = colorCache.get(dummy);
        } else {
            this.color = RenderUtils.getAverageColor(this.stack);
            colorCache.put(dummy, this.color);
        }
    }

    public void findTexture() {
        DummyStack dummy = this.getDummy();
        if (spriteCache.containsKey(dummy)) {
            this.spriteName = spriteCache.get(dummy).func_94215_i();
        } else {
            TextureAtlasSprite sprite;
            ItemStack compress = OreDictUtil.getCompressIngotBlock(this.stack);
            if (compress != null) {
                sprite = RenderUtils.getSprite(compress);
                colorCache.put(dummy, 0);
            } else {
                sprite = (TextureAtlasSprite)RenderUtils.textureGetter.apply((Object)RenderIngot.DEFAULT_TEXTURE);
            }
            spriteCache.put(dummy, sprite);
            this.spriteName = sprite.func_94215_i();
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        if (this.stack != null) {
            this.stack.func_77955_b(tag);
        }
        tag.func_74768_a("color", this.color);
        if (this.spriteName != null) {
            tag.func_74778_a("sprite", this.spriteName);
        }
        return tag;
    }

    public static IngotType readFromNBT(NBTTagCompound tag) {
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
        IngotType type = new IngotType(stack);
        type.color = tag.func_74762_e("color");
        type.spriteName = tag.func_74779_i("sprite");
        return type;
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        buf.func_150788_a(this.stack);
        buf.writeInt(this.color);
        buf.writeInt(this.spriteName.length());
        buf.func_180714_a(this.spriteName);
    }

    public static IngotType readUpdatePacket(PacketBuffer buf) {
        ItemStack stack = null;
        try {
            stack = buf.func_150791_c();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IngotType type = new IngotType(stack);
        type.color = buf.readInt();
        int l = buf.readInt();
        type.spriteName = buf.func_150789_c(l);
        return type;
    }

    public int getColor() {
        return this.color;
    }

    public TextureAtlasSprite getSprite() {
        return spriteCache.get(this.getDummy());
    }

    public DummyStack getDummy() {
        return new DummyStack(this.stack);
    }
}

