/*
 * Decompiled with CFR 0.152.
 */
package com.primetoxinz.stacksonstacks.logic;

import com.primetoxinz.stacksonstacks.capability.IIngotCount;
import com.primetoxinz.stacksonstacks.capability.IngotCapabilities;
import com.primetoxinz.stacksonstacks.capability.IngotCountProvider;
import com.primetoxinz.stacksonstacks.ingot.DummyStack;
import com.primetoxinz.stacksonstacks.ingot.IngotLocation;
import com.primetoxinz.stacksonstacks.ingot.IngotType;
import com.primetoxinz.stacksonstacks.ingot.PartIngot;
import com.primetoxinz.stacksonstacks.logic.OreDictUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import lib.utils.RenderUtils;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.MultipartRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IngotPlacer {
    public static ArrayList<DummyStack> ingotRegistry = new ArrayList();

    @SubscribeEvent(priority=EventPriority.LOW)
    @SideOnly(value=Side.CLIENT)
    public final void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.getPlayer();
        if (IngotPlacer.canBeIngot(player.func_184614_ca()) || IngotPlacer.canBeIngot(player.func_184592_cb())) {
            RenderUtils.drawSelectionBox(player, event.getTarget(), 0, event.getPartialTicks());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void placeIngot(PlayerInteractEvent.RightClickBlock e) {
        IngotPlacer.onItemUse(e.getItemStack(), e.getEntityPlayer(), e.getWorld(), e.getPos(), e.getHand(), e.getFace(), e.getHitVec());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void attachCapability(AttachCapabilitiesEvent.TileEntity e) {
        TileMultipartContainer container;
        if (e.getTileEntity() instanceof TileMultipartContainer && !(container = (TileMultipartContainer)e.getTileEntity()).hasCapability(IngotCapabilities.CAPABILITY_INGOT, null)) {
            e.addCapability(new ResourceLocation("stacksonstacks", "ingot_capability"), (ICapabilityProvider)new IngotCountProvider());
        }
    }

    private static EnumActionResult onItemUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, Vec3d hit) {
        if (IngotPlacer.canBeIngot(stack) && player.func_175151_a(pos, side, stack)) {
            IngotPlacer.place(world, pos, side, hit, stack, player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static boolean canBeIngot(ItemStack stack) {
        if (stack != null) {
            DummyStack dummy = new DummyStack(stack);
            if (ingotRegistry.contains(dummy)) {
                return true;
            }
            String ingotName = OreDictUtil.getOreDictionaryNameStartingWith(stack, "ingot");
            if (ingotName != null) {
                ingotRegistry.add(dummy);
                return true;
            }
        }
        return false;
    }

    private static boolean canAddPart(World world, BlockPos pos, PartIngot ingot) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (container == null) {
            if (!world.func_180495_p(pos).func_185904_a().func_76222_j()) {
                return false;
            }
            ArrayList list = new ArrayList();
            for (AxisAlignedBB bb : list) {
                if (world.func_72855_b(bb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) continue;
                return false;
            }
            Collection parts = MultipartRegistry.convert((IBlockAccess)world, (BlockPos)pos, (boolean)true);
            if (parts != null && !parts.isEmpty()) {
                TileMultipartContainer tmp = new TileMultipartContainer();
                for (IMultipart p : parts) {
                    tmp.getPartContainer().addPart(p, false, false, false, false, UUID.randomUUID());
                }
                return tmp.canAddPart((IMultipart)ingot);
            }
            return true;
        }
        return container.canAddPart((IMultipart)ingot);
    }

    private static Vec3d nextHit(Vec3d hit) {
        double x = hit.field_72450_a;
        double y = hit.field_72448_b;
        double z = hit.field_72449_c;
        if (x > 0.5) {
            if ((z += 0.25) > 0.75) {
                y += 0.125;
                z = 0.0;
            }
            x = 0.0;
        } else {
            x += 0.5;
        }
        return new Vec3d(x, y, z);
    }

    private static void place(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        BlockPos place = pos;
        boolean full = IngotPlacer.isContainerFull((TileMultipartContainer)container);
        if (container != null) {
            IMultipartContainer next;
            if (full && (next = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)(place = pos.func_177984_a()))) != null) {
                IngotPlacer.place(world, place, side, hit, stack, player);
            }
        } else {
            if (world.func_175625_s(pos) != null) {
                return;
            }
            place = pos.func_177972_a(side);
        }
        if (player.func_70093_af()) {
            IngotPlacer.placeAll(world, place, stack, player);
        } else if (!full) {
            IngotPlacer.place(world, place, hit, stack, player);
        }
    }

    private static void placeAll(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        new Thread(() -> {
            long startTime = System.currentTimeMillis();
            Vec3d hit = new Vec3d(0.0, 0.0, 0.0);
            while (stack.field_77994_a > 0 && System.currentTimeMillis() - startTime < 2000L) {
                IngotPlacer.place(world, pos, hit, stack, player);
                hit = IngotPlacer.nextHit(hit);
            }
        }).start();
    }

    private static void place(World world, BlockPos pos, Vec3d hit, ItemStack stack, EntityPlayer player) {
        IngotLocation location = IngotLocation.fromHit(hit, player.func_174811_aO().func_176740_k());
        PartIngot part = new PartIngot(location, new IngotType(stack));
        if (IngotPlacer.canAddPart(world, pos, part)) {
            if (!world.field_72995_K) {
                try {
                    MultipartHelper.addPart((World)world, (BlockPos)pos, (IMultipart)part);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            IngotPlacer.consumeItem(player, stack);
        }
    }

    public static boolean isContainerFull(TileMultipartContainer container) {
        if (container != null && container.hasCapability(IngotCapabilities.CAPABILITY_INGOT, null)) {
            IIngotCount cap = (IIngotCount)container.getCapability(IngotCapabilities.CAPABILITY_INGOT, null);
            return cap.isFull();
        }
        return false;
    }

    private static void consumeItem(EntityPlayer player, ItemStack stack) {
        if (!player.func_184812_l_()) {
            --stack.field_77994_a;
        }
        if (stack.field_77994_a <= 0 && player.func_184600_cs() != null) {
            player.func_184611_a(player.func_184600_cs(), null);
        }
    }
}

