/*
 * Decompiled with CFR 0.152.
 */
package cyano.orespawn.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import cyano.orespawn.OreSpawn;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameData;

public class OreSpawnData {
    public final float frequency;
    public final int spawnQuantity;
    public final int minY;
    public final int maxY;
    public final int variation;
    public final boolean restrictBiomes;
    public final Set<String> biomesByName;
    public final Block ore;
    public final int metaData;
    public static final OreSpawnData EMPTY_PLACEHOLDER = new OreSpawnData(Blocks.field_150348_b, 0, 1, 127, 0.0f, 1, 1, Collections.EMPTY_LIST);
    private static boolean doOnce = true;

    public OreSpawnData(Block oreBlock, int metaDataValue, int minHeight, int maxHeight, float spawnFrequency, int spawnQuantity, int spawnQuantityVariation, Collection<String> biomes) {
        this.spawnQuantity = spawnQuantity;
        this.frequency = spawnFrequency;
        this.minY = minHeight;
        this.maxY = maxHeight;
        this.ore = oreBlock;
        this.metaData = metaDataValue;
        this.variation = spawnQuantityVariation;
        this.restrictBiomes = biomes != null && !biomes.isEmpty();
        HashSet<String> list = new HashSet<String>();
        if (this.restrictBiomes) {
            list.addAll(biomes);
        }
        this.biomesByName = Collections.unmodifiableSet(list);
    }

    public static OreSpawnData parseOreSpawnData(JsonObject jsonEntry) {
        String blockName = jsonEntry.get("blockID").getAsString();
        if (blockName == null || Block.func_149684_b((String)blockName) == null) {
            if (OreSpawn.ignoreNonExistant) {
                FMLLog.warning((String)"%s: ignoring orespawn data for %s because that block does not exist", (Object[])new Object[]{"orespawn", blockName});
                return EMPTY_PLACEHOLDER;
            }
            throw new IllegalArgumentException(String.format("Ore block with ID %s does not exist!", blockName));
        }
        return new OreSpawnData(jsonEntry);
    }

    private OreSpawnData(JsonObject jsonEntry) {
        String name;
        String modId;
        String blockName = jsonEntry.get("blockID").getAsString();
        if (blockName.contains(":")) {
            modId = blockName.substring(0, blockName.indexOf(":"));
            name = blockName.substring(blockName.indexOf(":") + 1);
        } else {
            modId = "minecraft";
            name = blockName;
        }
        ResourceLocation blockKey = new ResourceLocation(blockName);
        if (!Block.field_149771_c.func_148741_d((Object)blockKey)) {
            FMLLog.severe((String)("Failed to find ore block " + modId + ":" + name), (Object[])new Object[0]);
            if (doOnce) {
                StringBuilder sb = new StringBuilder("Valid block IDs:\n");
                for (Object key : GameData.getBlockRegistry().func_148742_b()) {
                    sb.append("\t(").append(key.getClass().getName()).append(")\t").append(String.valueOf(key)).append("\n");
                }
                FMLLog.severe((String)sb.toString(), (Object[])new Object[0]);
                doOnce = false;
            }
        }
        this.ore = (Block)Block.field_149771_c.func_82594_a((Object)blockKey);
        this.metaData = OreSpawnData.get("blockMeta", 0, jsonEntry);
        this.spawnQuantity = (int)OreSpawnData.get("size", 8.0f, jsonEntry);
        this.frequency = OreSpawnData.get("frequency", 20.0f, jsonEntry);
        this.minY = OreSpawnData.get("minHeight", 0, jsonEntry);
        this.maxY = OreSpawnData.get("maxHeight", 255, jsonEntry);
        this.variation = (int)OreSpawnData.get("variation", 0.5f * (float)this.spawnQuantity, jsonEntry);
        if (jsonEntry.has("biomes") && jsonEntry.get("biomes").getAsJsonArray().size() > 0) {
            this.restrictBiomes = true;
            JsonArray biomeEntries = jsonEntry.get("biomes").getAsJsonArray();
            HashSet<String> list = new HashSet<String>();
            for (int n = 0; n < biomeEntries.size(); ++n) {
                list.add(biomeEntries.get(n).getAsString());
            }
            this.biomesByName = Collections.unmodifiableSet(list);
        } else {
            this.restrictBiomes = false;
            this.biomesByName = Collections.EMPTY_SET;
        }
    }

    private static int get(String key, int defaultValue, JsonObject root) {
        if (root.has(key)) {
            return root.get(key).getAsInt();
        }
        return defaultValue;
    }

    private static float get(String key, float defaultValue, JsonObject root) {
        if (root.has(key)) {
            return root.get(key).getAsFloat();
        }
        return defaultValue;
    }

    private static String get(String key, String defaultValue, JsonObject root) {
        if (root.has(key)) {
            return root.get(key).getAsString();
        }
        return defaultValue;
    }

    public String toString() {
        return "oreSpawn: [ore=" + this.ore + "#" + this.metaData + ",frequency=" + this.frequency + ",spawnQuantity=" + this.spawnQuantity + ",variation=+/-" + this.variation + ",Y-range=" + this.minY + "-" + this.maxY + ",restrictBiomes=" + this.restrictBiomes + ",biomes=" + Arrays.toString(this.biomesByName.toArray()) + "]";
    }
}

