/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.tile;

import com.mrdimka.hammercore.HammerCore;
import com.mrdimka.hammercore.net.HCNetwork;
import com.mrdimka.hammercore.net.pkt.PacketSyncSyncableTile;
import com.mrdimka.hammercore.tile.TileSyncableTickable;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileSyncable
extends TileEntity {
    private NBTTagCompound lastSyncTag;
    public boolean escapeSyncIfIdentical = true;
    private IItemHandler[] itemHandlers = new SidedInvWrapper[6];

    public void func_70296_d() {
        super.func_70296_d();
        this.sync();
    }

    public void sync() {
        if (this.escapeSyncIfIdentical) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeNBT(nbt);
            if (this.lastSyncTag != null && this.lastSyncTag.equals((Object)nbt)) {
                return;
            }
            this.lastSyncTag = nbt;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            PacketSyncSyncableTile tile = new PacketSyncSyncableTile(this);
            HCNetwork.manager.sendToAllAround(tile, this.getSyncPoint(512));
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeNBT(nbt);
        if (this instanceof TileSyncableTickable) {
            nbt.func_74768_a("ticksExisted", ((TileSyncableTickable)this).ticksExisted);
        }
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readNBT(pkt.func_148857_g());
        if (this instanceof TileSyncableTickable) {
            ((TileSyncableTickable)this).ticksExisted = pkt.func_148857_g().func_74762_e("ticksExisted");
        }
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readNBT(tag);
        if (this instanceof TileSyncableTickable) {
            ((TileSyncableTickable)this).ticksExisted = tag.func_74762_e("ticksExisted");
        }
    }

    public NetworkRegistry.TargetPoint getSyncPoint(int range) {
        return new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)range);
    }

    public abstract void writeNBT(NBTTagCompound var1);

    public abstract void readNBT(NBTTagCompound var1);

    public final NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeNBT(tag);
        nbt.func_74782_a("tags", (NBTBase)tag);
        if (this instanceof TileSyncableTickable) {
            nbt.func_74768_a("ticksExisted", ((TileSyncableTickable)this).ticksExisted);
        }
        return nbt;
    }

    public final void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNBT(nbt.func_74775_l("tags"));
        if (this instanceof TileSyncableTickable) {
            ((TileSyncableTickable)this).ticksExisted = nbt.func_74762_e("ticksExisted");
        }
    }

    protected IItemHandler createSidedHandler(EnumFacing side) {
        if (this instanceof ISidedInventory) {
            SidedInvWrapper sidedInvWrapper = new SidedInvWrapper((ISidedInventory)this, side);
            this.itemHandlers[side.ordinal()] = sidedInvWrapper;
            return sidedInvWrapper;
        }
        if (this instanceof IInventory) {
            InvWrapper invWrapper = new InvWrapper((IInventory)this);
            this.itemHandlers[side.ordinal()] = invWrapper;
            return invWrapper;
        }
        return null;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this instanceof IInventory) {
            return (T)(this.itemHandlers[facing.ordinal()] == null ? this.createSidedHandler(facing) : this.itemHandlers[facing.ordinal()]);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this instanceof IInventory || super.hasCapability(capability, facing);
    }

    public boolean atTickRate(int rate) {
        return (this.field_145850_b.func_82737_E() + this.field_174879_c.func_177986_g()) % (long)rate == 0L;
    }

    public final void tryOpenGui(EntityPlayer player, World world) {
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)HammerCore.instance, (int)0, (World)world, (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p());
        }
    }

    public boolean hasGui() {
        return false;
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return null;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return null;
    }
}

