/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.structure;

import com.mrdimka.hammercore.structure.Structure;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureAPI {
    public static Structure Export(World world, BlockPos start, BlockPos end, boolean includeAir) {
        Structure s = new Structure();
        for (int x = Math.min(start.func_177958_n(), end.func_177958_n()); x <= Math.max(start.func_177958_n(), end.func_177958_n()); ++x) {
            for (int y = Math.min(start.func_177956_o(), end.func_177956_o()); y <= Math.max(start.func_177956_o(), end.func_177956_o()); ++y) {
                for (int z = Math.min(start.func_177952_p(), end.func_177952_p()); z <= Math.max(start.func_177952_p(), end.func_177952_p()); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (world.func_175623_d(pos) && !includeAir) continue;
                    BlockPos absPos = new BlockPos(x - Math.min(start.func_177958_n(), end.func_177958_n()), y - Math.min(start.func_177956_o(), end.func_177956_o()), z - Math.min(start.func_177952_p(), end.func_177952_p()));
                    s.placeStateAt(absPos, world.func_180495_p(pos));
                    if (world.func_175625_s(pos) == null) continue;
                    NBTTagCompound nbt = world.func_175625_s(pos).serializeNBT();
                    nbt.func_82580_o("x");
                    nbt.func_82580_o("y");
                    nbt.func_82580_o("z");
                    s.placeTileNBTAt(absPos, nbt);
                }
            }
        }
        return s;
    }

    public static void Import(World world, BlockPos startPos, Structure structure) {
        structure.build(world, startPos);
    }

    public static void Save(Structure s, OutputStream os) throws IOException {
        CompressedStreamTools.func_74799_a((NBTTagCompound)s.serialize(), (OutputStream)os);
    }

    public static Structure Load(InputStream in) throws IOException {
        Structure s = new Structure();
        s.deserialize(CompressedStreamTools.func_74796_a((InputStream)in));
        return s;
    }
}

