/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.common.match.fluid;

import com.mrdimka.hammercore.common.match.fluid.FluidMatchParams;
import com.mrdimka.hammercore.fluiddict.FluidDictionary;
import java.util.List;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidContainer {
    private final String fluid;
    private final int count;
    private final String nbt;
    private final String fluiddictNames;
    private final String mod;
    private final byte type;

    private FluidContainer(FluidStack stack) {
        this.fluid = FluidRegistry.getFluidName((FluidStack)stack);
        this.count = stack.amount;
        this.nbt = stack.tag + "";
        String ods = "";
        List<String> fluiddicts = FluidDictionary.getNamesByFluidId(FluidDictionary.getFluidId(stack));
        for (String i : fluiddicts) {
            ods = ods + i + ";";
        }
        if (ods.endsWith(";")) {
            ods = ods.substring(0, ods.length() - 1);
        }
        this.fluiddictNames = ods;
        this.mod = stack.getFluid().getBlock().delegate.name().func_110624_b();
        this.type = 0;
    }

    private FluidContainer(String fluiddict) {
        this.fluiddictNames = fluiddict;
        this.fluid = null;
        this.count = 0;
        this.nbt = null;
        this.mod = null;
        this.type = 1;
    }

    public int getCount() {
        return this.count;
    }

    public Object getFluid() {
        return this.fluid != null ? FluidRegistry.getFluid((String)this.fluid) : this.fluiddictNames.split(";");
    }

    public static boolean fluiddictMatches(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        for (String as : a.split(";")) {
            if (!b.contains(as)) continue;
            return true;
        }
        return false;
    }

    public byte getType() {
        return this.type;
    }

    private static boolean fluidsMatch(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public boolean matches(FluidContainer other, FluidMatchParams params) {
        boolean modOK = !params.useMod || this.mod != null && other.mod != null && other.mod.equals(this.mod);
        boolean nbtOK = !params.useNBT || this.nbt != null && other.nbt != null && other.nbt.equals(this.nbt);
        boolean itmOK = FluidContainer.fluidsMatch(this.fluid, other.fluid);
        boolean ctnOK = !params.useCount || this.count == other.count;
        boolean ordOK = params.useFluiddict && FluidContainer.fluiddictMatches(this.fluiddictNames, other.fluiddictNames);
        return ordOK || modOK && nbtOK && itmOK && ctnOK;
    }

    public boolean matches(FluidStack stack, FluidMatchParams params) {
        return this.matches(new FluidContainer(stack), params);
    }
}

