/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client;

import com.mrdimka.hammercore.api.RequiredDeps;
import com.mrdimka.hammercore.client.renderer.RenderHelperImpl;
import com.mrdimka.hammercore.client.renderer.item.EnumItemRender;
import com.mrdimka.hammercore.client.renderer.item.IItemRenderer;
import com.mrdimka.hammercore.client.utils.GLImageManager;
import com.mrdimka.hammercore.client.utils.RenderUtil;
import com.mrdimka.hammercore.common.utils.IOUtils;
import com.mrdimka.hammercore.config.HCConfigs;
import com.mrdimka.hammercore.gui.GuiMissingApis;
import com.mrdimka.hammercore.gui.smooth.GuiBrewingStandSmooth;
import com.mrdimka.hammercore.gui.smooth.GuiFurnaceSmooth;
import com.mrdimka.hammercore.json.JSONArray;
import com.mrdimka.hammercore.json.JSONObject;
import com.mrdimka.hammercore.json.JSONTokener;
import com.mrdimka.hammercore.math.ExpressionEvaluator;
import com.mrdimka.hammercore.math.functions.ExpressionFunction;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderGui {
    private static final SpecialUser user = new SpecialUser();

    @SubscribeEvent
    public void guiRender(GuiScreenEvent.DrawScreenEvent.Post e) {
        GuiScreen gui = e.getGui();
        if (gui instanceof GuiMainMenu) {
            RenderGui.user.draw();
        }
        if (gui instanceof GuiContainer) {
            GuiContainer gc = (GuiContainer)gui;
            int guiLeft = 0;
            int guiTop = 0;
            try {
                guiLeft = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)gc, (String[])new String[]{"guiLeft", "field_147003_i"});
                guiTop = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)gc, (String[])new String[]{"guiTop", "field_147009_r"});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Container c = gc.field_147002_h;
            for (int i = 0; i < c.field_75151_b.size(); ++i) {
                ItemStack stack = ((Slot)c.field_75151_b.get(i)).func_75211_c();
                if (stack == null) continue;
                Slot sl = c.func_75139_a(i);
                IItemRenderer renderer = RenderHelperImpl.INSTANCE.getRenderFor(stack, EnumItemRender.GUI);
                if (renderer == null) continue;
                GlStateManager.func_179097_i();
                renderer.render(EnumItemRender.GUI, stack, guiLeft + sl.field_75223_e, guiTop + sl.field_75221_f, 0.0);
                GlStateManager.func_179126_j();
            }
            ItemStack stack = gc.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            if (stack != null) {
                guiLeft = e.getMouseX();
                guiTop = e.getMouseY();
                IItemRenderer renderer = RenderHelperImpl.INSTANCE.getRenderFor(stack, EnumItemRender.GUI);
                if (renderer != null) {
                    renderer.render(EnumItemRender.GUI, stack, guiLeft - 8, guiTop - 8, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void openGui(GuiOpenEvent evt) {
        Object gui;
        GuiScreen fgui = gui = evt.getGui();
        if (gui instanceof GuiMainMenu) {
            new Thread(() -> {
                RenderGui.user.download();
                RenderGui.user.reload(true);
            }).start();
        }
        if (gui instanceof GuiMainMenu && !RequiredDeps.allDepsResolved()) {
            gui = new GuiMissingApis();
        }
        if (HCConfigs.vanilla_useSmoothGui) {
            InventoryPlayer playerInv;
            Field pinv;
            Field[] fs;
            if (gui instanceof GuiFurnace) {
                try {
                    fs = GuiFurnace.class.getDeclaredFields();
                    pinv = fs[1];
                    pinv.setAccessible(true);
                    Field furn = fs[2];
                    furn.setAccessible(true);
                    playerInv = (InventoryPlayer)pinv.get(gui);
                    IInventory furnaceInv = (IInventory)furn.get(gui);
                    gui = new GuiFurnaceSmooth(playerInv, furnaceInv);
                }
                catch (Throwable err) {
                    err.printStackTrace();
                }
            }
            if (gui instanceof GuiBrewingStand) {
                try {
                    fs = GuiBrewingStand.class.getDeclaredFields();
                    pinv = fs[2];
                    pinv.setAccessible(true);
                    Field bs = fs[3];
                    bs.setAccessible(true);
                    playerInv = (InventoryPlayer)pinv.get(gui);
                    IInventory tbsInv = (IInventory)bs.get(gui);
                    gui = new GuiBrewingStandSmooth(playerInv, tbsInv);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (fgui != gui) {
            evt.setGui(gui);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static final class IMG {
        private BufferedImage img;
        private String x;
        private String y;
        private String width;
        private String height;

        private IMG() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static final class SpecialUser {
        private final int glImage = GL11.glGenTextures();
        private final List<IMG> images = new ArrayList<IMG>();
        private long lastDownload = 0L;
        private final SecureRandom rand = new SecureRandom();
        private double x;
        private double y;
        private double width;
        private double height;
        private IMG currImg;

        private SpecialUser() {
        }

        private void download() {
            try {
                int i;
                JSONArray arr;
                JSONArray ar0 = arr = (JSONArray)new JSONTokener(new String(IOUtils.downloadData("https://pastebin.com/raw/JKDpcHL1"))).nextValue();
                for (i = 0; i < arr.length(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    if (!obj.optBoolean("enabled", false) || !obj.getString("username").equals(Minecraft.func_71410_x().func_110432_I().func_111285_a())) continue;
                    arr = obj.getJSONArray("images");
                    break;
                }
                this.images.clear();
                if (arr != ar0) {
                    for (i = 0; i < arr.length(); ++i) {
                        JSONObject o = arr.getJSONObject(i);
                        IMG img = new IMG();
                        img.img = IOUtils.downloadPicture(o.getString("url"));
                        JSONObject signature = o.getJSONObject("signature");
                        img.x = signature.getString("x");
                        img.y = signature.getString("y");
                        img.width = signature.getString("width");
                        img.height = signature.getString("height");
                        this.images.add(img);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private boolean reload(boolean launchThread) {
            try {
                if (this.images.isEmpty()) {
                    this.currImg = null;
                    this.height = 0.0;
                    this.width = 0.0;
                    this.y = 0.0;
                    this.x = 0.0;
                    return true;
                }
                IMG i = this.currImg = this.images.get(this.rand.nextInt(this.images.size()));
                String sx = i.x;
                String sy = i.y;
                String sw = i.width;
                String sh = i.height;
                sx = this.format(sx);
                sy = this.format(sy);
                sw = this.format(sw);
                sh = this.format(sh);
                this.x = ExpressionEvaluator.evaluateDouble(sx, new ExpressionFunction[0]);
                this.y = ExpressionEvaluator.evaluateDouble(sy, new ExpressionFunction[0]);
                this.width = ExpressionEvaluator.evaluateDouble(sw, new ExpressionFunction[0]);
                this.height = ExpressionEvaluator.evaluateDouble(sh, new ExpressionFunction[0]);
                return true;
            }
            catch (Throwable err) {
                if (launchThread) {
                    new Thread(() -> {
                        int i = 0;
                        while (++i < 5 && !this.reload(false)) {
                        }
                    }).start();
                }
                return false;
            }
        }

        private String format(String s) {
            if (s == null) {
                return "0";
            }
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution sr = new ScaledResolution(mc);
            GuiScreen gs = mc.field_71462_r;
            double displacex = sr.func_78327_c() / (double)sr.func_78326_a();
            double displacey = sr.func_78324_d() / (double)sr.func_78328_b();
            s = s.replaceAll("mc-width", mc.field_71443_c + "");
            s = s.replaceAll("mc-height", mc.field_71440_d + "");
            return s;
        }

        private void draw() {
            if (this.currImg == null || this.currImg.img == null) {
                return;
            }
            if (System.currentTimeMillis() - this.lastDownload > 10000L) {
                GLImageManager.loadTexture(this.currImg.img, this.glImage, false);
                this.lastDownload = System.currentTimeMillis();
            }
            GlStateManager.func_179144_i((int)this.glImage);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glTranslated((double)this.x, (double)this.y, (double)0.0);
            GL11.glScaled((double)this.width, (double)this.height, (double)1.0);
            GL11.glScaled((double)(1.0 / (double)this.currImg.img.getWidth()), (double)(1.0 / (double)this.currImg.img.getHeight()), (double)1.0);
            RenderUtil.drawTexturedModalRect(0.0, 0.0, 0.0, 0.0, 256.0, 256.0);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }
}

