/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore;

import com.mrdimka.hammercore.RayCubeRegistry;
import com.mrdimka.hammercore.annotations.MCFBus;
import com.mrdimka.hammercore.api.HammerCoreAPI;
import com.mrdimka.hammercore.api.IHammerCoreAPI;
import com.mrdimka.hammercore.api.RequiredDeps;
import com.mrdimka.hammercore.api.WrappedFMLLog;
import com.mrdimka.hammercore.api.mhb.IRayRegistry;
import com.mrdimka.hammercore.api.mhb.RaytracePlugin;
import com.mrdimka.hammercore.command.CommandPosToLong;
import com.mrdimka.hammercore.command.CommandTPX;
import com.mrdimka.hammercore.common.capabilities.CapabilityEJ;
import com.mrdimka.hammercore.common.utils.AnnotatedInstanceUtil;
import com.mrdimka.hammercore.common.utils.HammerCoreUtils;
import com.mrdimka.hammercore.common.utils.WrappedLog;
import com.mrdimka.hammercore.config.HCConfigs;
import com.mrdimka.hammercore.event.AddCalculatronRecipeEvent;
import com.mrdimka.hammercore.event.GetAllRequiredApisEvent;
import com.mrdimka.hammercore.ext.TeslaAPI;
import com.mrdimka.hammercore.fluiddict.FluidDictionary;
import com.mrdimka.hammercore.gui.GuiManager;
import com.mrdimka.hammercore.init.ModBlocks;
import com.mrdimka.hammercore.init.ModItems;
import com.mrdimka.hammercore.net.HCNetwork;
import com.mrdimka.hammercore.proxy.AudioProxy_Common;
import com.mrdimka.hammercore.proxy.ParticleProxy_Common;
import com.mrdimka.hammercore.proxy.RenderProxy_Common;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Level;

@Mod(modid="hammercore", version="1.4.8", name="Hammer Core", acceptedMinecraftVersions="[1.10.2]")
public class HammerCore {
    public static final boolean IS_OBFUSCATED_MC = false;
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.RenderProxy_Client", serverSide="com.mrdimka.hammercore.proxy.RenderProxy_Common")
    public static RenderProxy_Common renderProxy;
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.AudioProxy_Client", serverSide="com.mrdimka.hammercore.proxy.AudioProxy_Common")
    public static AudioProxy_Common audioProxy;
    @SidedProxy(modId="hammercore", clientSide="com.mrdimka.hammercore.proxy.ParticleProxy_Client", serverSide="com.mrdimka.hammercore.proxy.ParticleProxy_Common")
    public static ParticleProxy_Common particleProxy;
    @Mod.Instance(value="hammercore")
    public static HammerCore instance;
    public static final CreativeTabs tab;
    public static final Map<IHammerCoreAPI, HammerCoreAPI> APIS;
    public static final WrappedLog LOG;
    private List<IRayRegistry> raytracePlugins;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent e) {
        renderProxy.construct();
        audioProxy.construct();
        if (!FluidRegistry.isUniversalBucketEnabled()) {
            FluidRegistry.enableUniversalBucket();
        }
        new FluidDictionary();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        CapabilityEJ.register();
        HCConfigs.init(e.getSuggestedConfigurationFile());
        List<IHammerCoreAPI> apis = AnnotatedInstanceUtil.getInstances(e.getAsmData(), HammerCoreAPI.class, IHammerCoreAPI.class);
        List<Object> toRegister = AnnotatedInstanceUtil.getInstances(e.getAsmData(), MCFBus.class, Object.class);
        this.raytracePlugins = AnnotatedInstanceUtil.getInstances(e.getAsmData(), RaytracePlugin.class, IRayRegistry.class);
        for (Object o : toRegister) {
            MinecraftForge.EVENT_BUS.register(o);
            FMLLog.log((String)"Hammer Core", (Level)Level.INFO, (String)("Added \"" + o + "\" to MCF Event Bus."), (Object[])new Object[0]);
        }
        FMLLog.log((String)"Hammer Core", (Level)Level.INFO, (String)("Added " + toRegister.size() + " object to MCF Event Bus."), (Object[])new Object[0]);
        GetAllRequiredApisEvent evt = new GetAllRequiredApisEvent();
        MinecraftForge.EVENT_BUS.post((Event)evt);
        RequiredDeps.addRequests(evt);
        for (IHammerCoreAPI api : apis) {
            HammerCoreAPI apia = api.getClass().getAnnotation(HammerCoreAPI.class);
            if (apia == null) continue;
            WrappedFMLLog log = new WrappedFMLLog(apia.name());
            api.init(log, apia.version());
            APIS.put(api, apia);
        }
        new ModBlocks();
        new ModItems();
        ModMetadata meta = e.getModMetadata();
        meta.autogenerated = false;
        meta.version = "1.4.8";
        meta.authorList = Arrays.asList("MrDimkas_Studio");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        renderProxy.init();
        HCNetwork.clinit();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiManager());
        if (ModItems.calculatron != null) {
            AddCalculatronRecipeEvent evt = new AddCalculatronRecipeEvent();
            evt.setRecipe((IRecipe)new ShapedOreRecipe(ModItems.calculatron, new Object[]{"igi", "rlr", "idi", Character.valueOf('g'), "blockGlass", Character.valueOf('i'), "ingotIron", Character.valueOf('r'), "dustRedstone", Character.valueOf('d'), "ingotGold", Character.valueOf('l'), "dyeLime"}));
            if (!MinecraftForge.EVENT_BUS.post((Event)evt)) {
                GameRegistry.addRecipe((IRecipe)evt.getRecipe());
            }
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandPosToLong());
        e.registerServerCommand((ICommand)new CommandTPX());
        File hc_recipes_global = new File("hc-recipes");
        MinecraftServer server = e.getServer();
        File worldFolder = new File((server.func_71262_S() ? "" : "saves" + File.separator) + server.func_71270_I(), "hc-recipes");
        worldFolder.mkdirs();
        hc_recipes_global.mkdirs();
        this.reloadRaytracePlugins();
    }

    public void reloadRaytracePlugins() {
        TeslaAPI.refreshTeslaClassData();
        RayCubeRegistry.instance.cubes.clear();
        RayCubeRegistry.instance.mgrs.clear();
        for (IRayRegistry reg : this.raytracePlugins) {
            LOG.info("Registering raytrace plugin: " + reg.getClass().getName() + " ...", new Object[0]);
            long start = System.currentTimeMillis();
            reg.registerCubes(RayCubeRegistry.instance);
            LOG.info("Registered raytrace  plugin: " + reg.getClass().getName() + " in " + (System.currentTimeMillis() - start) + " ms", new Object[0]);
        }
    }

    static {
        tab = HammerCoreUtils.createDynamicCreativeTab("hammercore", 150);
        APIS = new HashMap<IHammerCoreAPI, HammerCoreAPI>();
        LOG = new WrappedLog("Hammer Core");
    }
}

