/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.trap;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.darkutils.features.trap.TrapType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTrap
extends Block {
    public static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    public static final PropertyEnum<TrapType> VARIANT = PropertyEnum.func_177709_a((String)"variant", TrapType.class);

    public BlockTrap() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)TrapType.POISON)));
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149713_g(0);
    }

    private boolean checkForDrop(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return false;
        }
        return true;
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        return !world.func_175623_d(pos.func_177977_b()) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        this.checkForDrop(worldIn, pos, state);
    }

    public int func_180651_a(IBlockState state) {
        return ((TrapType)((Object)state.func_177229_b(BlockTrap.VARIANT))).meta;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)TrapType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((TrapType)((Object)state.func_177229_b(BlockTrap.VARIANT))).meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            PotionEffect effect = null;
            int type = this.func_176201_c(state);
            if (type == 0) {
                effect = new PotionEffect(MobEffects.field_76436_u, 100);
            }
            if (type == 1) {
                effect = new PotionEffect(MobEffects.field_76437_t, 60);
            }
            if (type == 2) {
                living.func_70097_a(DamageSource.field_76376_m, 2.5f);
            }
            if (type == 3) {
                effect = new PotionEffect(MobEffects.field_76421_d, 60, 2);
            }
            if (type == 4) {
                living.func_70015_d(1);
            }
            if (type == 5) {
                effect = new PotionEffect(MobEffects.field_82731_v, 60);
            }
            if (effect != null) {
                effect.setCurativeItems(new ArrayList());
                living.func_70690_d(effect);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (TrapType type : TrapType.values()) {
            list.add(new ItemStack(itemIn, 1, type.meta));
        }
    }
}

