/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.sneaky;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.darkhax.bookshelf.lib.BlockStates;
import net.darkhax.darkutils.features.sneaky.BlockSneaky;
import net.darkhax.darkutils.features.sneaky.BlockSneakyLever;
import net.darkhax.darkutils.features.sneaky.BlockSneakyPressurePlate;
import net.darkhax.darkutils.features.sneaky.BlockSneakyTorch;
import net.darkhax.darkutils.features.sneaky.TileEntitySneaky;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelSneakyBlock
implements IBakedModel {
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (!(state.func_177230_c() instanceof BlockSneaky)) {
            return mc.func_175602_ab().func_175023_a().func_178126_b().func_174951_a().func_188616_a(state, side, rand);
        }
        IBlockState heldState = (IBlockState)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockStates.HELD_STATE);
        IBlockAccess heldWorld = (IBlockAccess)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockStates.BLOCK_ACCESS);
        BlockPos heldPos = (BlockPos)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockStates.BLOCKPOS);
        if (heldWorld == null || heldPos == null) {
            return ImmutableList.of();
        }
        if (heldState == null && layer == BlockRenderLayer.SOLID) {
            Block block = state.func_177230_c();
            if (block instanceof BlockSneakyLever) {
                return mc.func_175602_ab().func_175023_a().func_178126_b().func_174953_a(new ModelResourceLocation("darkutils:sneaky_lever")).func_188616_a(state, side, rand);
            }
            if (block instanceof BlockSneakyTorch) {
                return mc.func_175602_ab().func_175023_a().func_178126_b().func_174953_a(new ModelResourceLocation("darkutils:sneaky_torch")).func_188616_a(state, side, rand);
            }
            if (block instanceof BlockSneakyPressurePlate) {
                return mc.func_175602_ab().func_175023_a().func_178126_b().func_174953_a(new ModelResourceLocation("darkutils:sneaky_plate")).func_188616_a(state, side, rand);
            }
            return mc.func_175602_ab().func_175023_a().func_178126_b().func_174953_a(new ModelResourceLocation("darkutils:sneaky_default")).func_188616_a(state, side, rand);
        }
        if (heldState != null && heldState.func_177230_c().canRenderInLayer(heldState, layer)) {
            IBlockState actualState = heldState.func_177230_c().func_176221_a(heldState, (IBlockAccess)new SneakyBlockAccess(heldWorld), heldPos);
            IBakedModel model = mc.func_175602_ab().func_175023_a().func_178125_b(actualState);
            IBlockState extended = heldState.func_177230_c().getExtendedState(actualState, (IBlockAccess)new SneakyBlockAccess(heldWorld), heldPos);
            return model.func_188616_a(extended, side, rand);
        }
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b("darkutils:blocks/trap_base");
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private static class SneakyBlockAccess
    implements IBlockAccess {
        private final IBlockAccess access;

        private SneakyBlockAccess(IBlockAccess access) {
            this.access = access;
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return this.access.func_175625_s(pos);
        }

        public int func_175626_b(BlockPos pos, int light) {
            return 0xF000F0;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            IBlockState state = this.access.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockSneaky) {
                state = ((TileEntitySneaky)this.access.func_175625_s((BlockPos)pos)).heldState;
            }
            return state == null ? Blocks.field_150350_a.func_176223_P() : state;
        }

        public boolean func_175623_d(BlockPos pos) {
            return this.access.func_175623_d(pos);
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return this.access.func_175627_a(pos, direction);
        }

        public WorldType func_175624_G() {
            return this.access.func_175624_G();
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return this.access.isSideSolid(pos, side, _default);
        }

        public Biome func_180494_b(BlockPos pos) {
            return this.access.func_180494_b(pos);
        }
    }
}

