/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.sneaky;

import java.util.List;
import java.util.Random;
import net.darkhax.bookshelf.lib.BlockStates;
import net.darkhax.darkutils.features.sneaky.BlockSneaky;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockSneakyPressurePlate
extends BlockSneaky {
    protected static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.99, 1.0);

    public BlockSneakyPressurePlate() {
        this.func_180632_j(((IExtendedBlockState)this.field_176227_L.func_177621_b()).withProperty((IUnlistedProperty)BlockStates.HELD_STATE, null).withProperty((IUnlistedProperty)BlockStates.BLOCK_ACCESS, null).withProperty((IUnlistedProperty)BlockStates.BLOCKPOS, null).func_177226_a((IProperty)BlockStates.POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BlockStates.POWERED}, new IUnlistedProperty[]{BlockStates.HELD_STATE, BlockStates.BLOCK_ACCESS, BlockStates.BLOCKPOS});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStates.POWERED) != false ? 1 : 0;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockStates.POWERED, (Comparable)Boolean.valueOf(meta != 0));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int power;
        if (!worldIn.field_72995_K && (power = this.getRedstoneStrength(state)) > 0) {
            this.updateState(worldIn, pos, state, power);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        int power;
        if (!worldIn.field_72995_K && (power = this.getRedstoneStrength(state)) == 0) {
            this.updateState(worldIn, pos, state, power);
        }
    }

    protected void updateState(World worldIn, BlockPos pos, IBlockState state, int oldPower) {
        boolean turnOn;
        int power = this.computeRedstoneStrength(worldIn, pos);
        boolean bl = turnOn = power > 0;
        if (oldPower != power) {
            state = this.setRedstoneStrength(state, power);
            worldIn.func_180501_a(pos, state, 2);
            this.updateNeighbors(worldIn, pos);
            worldIn.func_175704_b(pos, pos);
        }
        if (turnOn) {
            worldIn.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (this.getRedstoneStrength(state) > 0) {
            this.updateNeighbors(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    protected void updateNeighbors(World worldIn, BlockPos pos) {
        worldIn.func_175685_c(pos, (Block)this);
        worldIn.func_175685_c(pos.func_177977_b(), (Block)this);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getRedstoneStrength(blockState);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? this.getRedstoneStrength(blockState) : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    protected int getRedstoneStrength(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStates.POWERED) != false ? 15 : 0;
    }

    protected IBlockState setRedstoneStrength(IBlockState state, int strength) {
        return state.func_177226_a((IProperty)BlockStates.POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    protected int computeRedstoneStrength(World worldIn, BlockPos pos) {
        AxisAlignedBB axisalignedbb = BOUNDS.func_186670_a(pos.func_177984_a());
        List list = worldIn.func_72839_b((Entity)null, axisalignedbb);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.func_145773_az()) continue;
                return 15;
            }
        }
        return 0;
    }
}

