/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.common.Function;
import shetiphian.multistorage.common.misc.UUIDHelper;

public class VaultAccess {
    private final LinkedHashMap<UUID, Pair<String, EnumStatus>> access = new LinkedHashMap();
    private final List<UUID> superuser = new ArrayList<UUID>();
    private Pair<UUID, String> owner;
    private boolean whitelist = true;
    private byte defence = 0;

    public void add(EntityPlayer player) {
        this.add(player.func_110124_au(), player.func_70005_c_());
    }

    public void add(String name) {
        this.add(UUIDHelper.getCachedUUID(name), name);
    }

    public void add(UUID uuid, String name) {
        UUID key;
        UUID uuid2 = UUIDHelper.getOfflineUUID(name);
        EnumStatus status = uuid != null && !uuid.equals(uuid2) ? EnumStatus.VERIFIED : EnumStatus.OFFLINE;
        UUID uUID = key = status == EnumStatus.VERIFIED ? uuid : uuid2;
        if (!this.contains(key)) {
            this.access.put(key, (Pair<String, EnumStatus>)Pair.of((Object)name, (Object)((Object)status)));
        }
    }

    public void remove(UUID uuid) {
        if (this.contains(uuid)) {
            this.access.remove(uuid);
        }
    }

    public int size() {
        return this.access.size();
    }

    public boolean contains(UUID uuid) {
        return this.access.containsKey(uuid);
    }

    public String getName(UUID uuid) {
        return this.contains(uuid) ? (String)this.access.get(uuid).getKey() : "<- INVALID ->";
    }

    public UUID getUUID(int index) {
        for (Map.Entry<UUID, Pair<String, EnumStatus>> entry : this.access.entrySet()) {
            if (index-- != 0) continue;
            return entry.getKey();
        }
        return null;
    }

    public int indexOf(UUID uuid) {
        int counter = 0;
        for (Map.Entry<UUID, Pair<String, EnumStatus>> entry : this.access.entrySet()) {
            if (entry.getKey().equals(uuid)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    private EnumStatus getStatus(UUID uuid) {
        return this.contains(uuid) ? (EnumStatus)((Object)this.access.get(uuid).getValue()) : EnumStatus.UNKNOWN;
    }

    public boolean isSuperUser(UUID uuid) {
        return this.superuser.contains(uuid);
    }

    public void makeSuperUser(UUID uuid) {
        if (!this.isSuperUser(uuid)) {
            this.superuser.add(uuid);
        }
    }

    public void revokeSuperUser(UUID uuid) {
        if (this.isSuperUser(uuid)) {
            this.superuser.remove(uuid);
        }
    }

    public void setOwner(UUID uuid) {
        if (!this.getOwnerName().equalsIgnoreCase("NoOwner")) {
            this.add(this.getOwnerId(), this.getOwnerName());
            this.makeSuperUser(this.getOwnerId());
        }
        this.owner = Pair.of((Object)uuid, (Object)UUIDHelper.getCachedName(uuid));
    }

    private Pair<UUID, String> getOwner() {
        return this.owner != null ? this.owner : Pair.of((Object)UUIDHelper.getOfflineUUID("NoOwner"), (Object)"NoOwner");
    }

    public UUID getOwnerId() {
        return (UUID)this.getOwner().getKey();
    }

    public String getOwnerName() {
        return (String)this.getOwner().getValue();
    }

    public void setWhitelist(boolean value) {
        this.whitelist = value;
    }

    public boolean isWhitelist() {
        return this.whitelist;
    }

    public void setDefence(int value) {
        this.defence = (byte)(value < 0 ? -1 : (value > 0 ? 1 : 0));
    }

    public boolean isDefenceEnabled() {
        return this.defence >= 0;
    }

    public boolean isDefenceKill() {
        return this.defence == 0;
    }

    public boolean hasFullAccess(EntityPlayer player) {
        boolean isOwner = this.getOwnerId().equals(player.func_110124_au()) || this.getOwnerId().equals(UUIDHelper.getOfflineUUID(player.func_70005_c_()));
        return isOwner || Function.isCreativeOP((EntityPlayer)player);
    }

    public boolean canEditVault(EntityPlayer player) {
        boolean isSuper = this.isSuperUser(player.func_110124_au()) || this.isSuperUser(UUIDHelper.getOfflineUUID(player.func_70005_c_()));
        return isSuper || this.hasFullAccess(player);
    }

    public boolean canUseVault(EntityPlayer player) {
        boolean onList = this.contains(player.func_110124_au()) || this.contains(UUIDHelper.getOfflineUUID(player.func_70005_c_()));
        return onList == this.isWhitelist() || this.canEditVault(player);
    }

    NBTTagCompound serialize() {
        NBTTagList nbtList = new NBTTagList();
        for (Map.Entry<UUID, Pair<String, EnumStatus>> entry : this.access.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("uuid", entry.getKey().toString());
            tag.func_74778_a("name", (String)entry.getValue().getKey());
            tag.func_74757_a("super", this.isSuperUser(entry.getKey()));
            tag.func_74774_a("status", ((EnumStatus)((Object)entry.getValue().getValue())).getValue());
            nbtList.func_74742_a((NBTBase)tag);
        }
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.func_74778_a("ownerid", this.getOwnerId().toString());
        nbtTag.func_74778_a("owner", this.getOwnerName());
        nbtTag.func_74757_a("whitelist", this.isWhitelist());
        nbtTag.func_74774_a("defence", this.defence);
        nbtTag.func_74782_a("list", (NBTBase)nbtList);
        return nbtTag;
    }

    void deserialize(NBTTagCompound nbtTag) {
        this.owner = this.getSet(nbtTag.func_74779_i("ownerid"), nbtTag.func_74779_i("owner"));
        this.setWhitelist(nbtTag.func_74767_n("whitelist"));
        this.setDefence(nbtTag.func_74771_c("defence"));
        NBTTagList nbtList = nbtTag.func_150295_c("list", 10);
        this.access.clear();
        for (int entry = 0; entry < nbtList.func_74745_c(); ++entry) {
            NBTTagCompound tag = nbtList.func_150305_b(entry);
            if (!tag.func_74764_b("uuid") || !tag.func_74764_b("name")) continue;
            Pair user = this.getSet(tag.func_74779_i("uuid"), tag.func_74779_i("name"));
            if (UUIDHelper.containsKey((UUID)user.getKey())) {
                user = Pair.of((Object)user.getKey(), (Object)UUIDHelper.getCachedName((UUID)user.getKey()));
            }
            EnumStatus status = EnumStatus.byValue(tag.func_74771_c("status"));
            this.access.put((UUID)user.getKey(), (Pair<String, EnumStatus>)Pair.of((Object)user.getValue(), (Object)((Object)status)));
            if (!tag.func_74767_n("super")) continue;
            this.superuser.add((UUID)user.getKey());
        }
    }

    private Pair<UUID, String> getSet(String id, String name) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(id);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (uuid == null) {
            uuid = UUIDHelper.getCachedUUID(name);
        }
        if (uuid == null) {
            uuid = UUIDHelper.getOfflineUUID(name);
        }
        return Pair.of((Object)uuid, (Object)name);
    }

    public int getNameColor(UUID uuid) {
        return this.getStatus(uuid).getColor();
    }

    private static enum EnumStatus {
        UNKNOWN(0, -32897),
        OFFLINE(1, -16513),
        VERIFIED(2, -8405121);

        private static final EnumStatus[] array;
        private final byte value;
        private final int color;

        private EnumStatus(int value, int color) {
            this.value = (byte)value;
            this.color = color;
        }

        public byte getValue() {
            return this.value;
        }

        public int getColor() {
            return this.color;
        }

        public static EnumStatus byValue(byte value) {
            return value >= 0 && value < array.length ? array[value] : UNKNOWN;
        }

        static {
            array = new EnumStatus[3];
            EnumStatus[] enumStatusArray = EnumStatus.values();
            int n = enumStatusArray.length;
            for (int i = 0; i < n; ++i) {
                EnumStatus value;
                EnumStatus.array[value.getValue()] = value = enumStatusArray[i];
            }
        }
    }
}

