/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vacuum;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector4f;
import com.google.common.base.Predicate;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.conduit.item.FilterRegister;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.item.filter.ItemFilter;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.ranged.IRanged;
import crazypants.enderio.machine.ranged.RangeParticle;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.YetaUtil;
import crazypants.util.MagnetUtil;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileVacuumChest
extends TileEntityEio
implements Predicate<EntityItem>,
IInventory,
IRedstoneModeControlable,
IPaintable.IPaintableTileEntity,
IRanged {
    public static final int ITEM_ROWS = 3;
    public static final int ITEM_SLOTS = 27;
    public static final int FILTER_SLOTS = 5;
    @Store
    private final ItemStack[] inv = new ItemStack[27];
    @Store
    private int range = Config.vacuumChestRange;
    private ItemFilter filter;
    @Store
    private ItemStack filterItem;
    @Store
    protected RedstoneControlMode redstoneControlMode = RedstoneControlMode.IGNORE;
    protected boolean redstoneCheckPassed;
    private boolean redstoneStateDirty = true;
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    protected IBlockState sourceBlock;
    private boolean showingRange;
    private static final Vector4f color = new Vector4f(0.11f, 0.11f, 0.94f, 0.4f);

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            YetaUtil.refresh((TileEntity)this);
        }
        if (this.redstoneStateDirty) {
            this.updateRedstoneStatus();
        }
        if (this.redstoneCheckPassed && !this.isFull()) {
            this.doHoover();
        }
    }

    private void updateRedstoneStatus() {
        boolean prevRedstoneCheckPassed = this.redstoneCheckPassed;
        this.redstoneCheckPassed = RedstoneControlMode.isConditionMet(this.redstoneControlMode, (TileEntity)this);
        this.redstoneStateDirty = false;
        if (this.redstoneCheckPassed != prevRedstoneCheckPassed) {
            this.updateBlock();
        }
    }

    public void onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
    }

    public boolean apply(@Nullable EntityItem entity) {
        return MagnetUtil.shouldAttract(this.func_174877_v(), (Entity)entity);
    }

    private void doHoover() {
        int rangeSqr = this.range * this.range;
        List interestingItems = this.field_145850_b.func_175647_a(EntityItem.class, (AxisAlignedBB)this.getBounds(), (Predicate)this);
        for (EntityItem entity : interestingItems) {
            double z;
            double y;
            if (this.filter != null && !this.filter.doesItemPassFilter(entity.func_92059_d())) continue;
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 - entity.field_70165_t;
            double distance = Math.sqrt(x * x + (y = (double)this.field_174879_c.func_177956_o() + 0.5 - entity.field_70163_u) * y + (z = (double)this.field_174879_c.func_177952_p() + 0.5 - entity.field_70161_v) * z);
            if (distance < 1.25 || this.range == 0) {
                this.hooverEntity((Entity)entity);
                continue;
            }
            double speed = 0.06;
            double distScale = 1.0 - Math.min(0.9, distance / (double)rangeSqr);
            distScale *= distScale;
            entity.field_70159_w += x / distance * distScale * speed;
            entity.field_70181_x += y / distance * distScale * 0.2;
            entity.field_70179_y += z / distance * distScale * speed;
        }
    }

    private void hooverEntity(Entity entity) {
        if (!this.field_145850_b.field_72995_K && entity instanceof EntityItem && !entity.field_70128_L) {
            EntityItem item = (EntityItem)entity;
            ItemStack stack = item.func_92059_d().func_77946_l();
            int numInserted = ItemUtil.doInsertItem((Object)this, (ItemStack)stack, null);
            stack.field_77994_a -= numInserted;
            item.func_92058_a(stack);
            if (stack.field_77994_a == 0) {
                item.func_70106_y();
            }
        }
    }

    private boolean isFull() {
        for (ItemStack stack : this.inv) {
            if (stack != null && stack.field_77994_a >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.inv.length) {
            return null;
        }
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return Util.decrStackSize((IInventory)this, (int)slot, (int)amount);
    }

    public void func_70299_a(int slot, @Nullable ItemStack contents) {
        if (slot < 0 || slot >= this.inv.length) {
            return;
        }
        this.inv[slot] = contents == null ? contents : contents.func_77946_l();
        if (contents != null && contents.field_77994_a > this.func_70297_j_()) {
            contents.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70304_b(int index) {
        ItemStack fromStack = this.inv[index];
        this.inv[index] = null;
        return fromStack;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = null;
        }
    }

    public String func_70005_c_() {
        return ModObject.blockVacuumChest.getUnlocalisedName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    public boolean isItemValidForFilter(ItemStack itemstack) {
        return itemstack != null && itemstack.func_77973_b() == ModObject.itemBasicFilterUpgrade.getItem() && itemstack.func_77952_i() == 0;
    }

    private int limitRange(int rangeIn) {
        return Math.max(0, Math.min(Config.vacuumChestRange, rangeIn));
    }

    public void setRange(int range) {
        this.range = this.limitRange(range);
        this.updateBlock();
    }

    public ItemStack getFilterItem() {
        return this.filterItem;
    }

    public void setFilterItem(ItemStack filterItem) {
        IItemFilter newFilter = FilterRegister.getFilterForUpgrade(filterItem);
        if (newFilter == null || newFilter instanceof ItemFilter) {
            this.filterItem = filterItem;
            this.filter = (ItemFilter)newFilter;
            this.updateBlock();
        }
    }

    public void setFilterBlacklist(boolean isBlacklist) {
        if (this.filter != null) {
            this.filter.setBlacklist(isBlacklist);
            this.updateFilterItem();
        }
    }

    public void setFilterMatchMeta(boolean matchMeta) {
        if (this.filter != null) {
            this.filter.setMatchMeta(matchMeta);
            this.updateFilterItem();
        }
    }

    public boolean hasItemFilter() {
        return this.filter != null;
    }

    public ItemFilter getItemFilter() {
        return this.filter;
    }

    public void setItemFilterSlot(int slot, ItemStack stack) {
        if (slot >= 0 && slot < 5 && this.filter != null) {
            this.filter.func_70299_a(slot, stack);
            this.updateFilterItem();
        }
    }

    private void updateFilterItem() {
        FilterRegister.writeFilterToStack(this.filter, this.filterItem);
        this.updateBlock();
    }

    @Override
    public RedstoneControlMode getRedstoneControlMode() {
        return this.redstoneControlMode;
    }

    @Override
    public void setRedstoneControlMode(RedstoneControlMode redstoneControlMode) {
        this.redstoneControlMode = redstoneControlMode;
        this.redstoneStateDirty = true;
        this.updateBlock();
    }

    @Override
    protected void onAfterDataPacket() {
        this.refreshFilter();
        this.updateBlock();
    }

    private void refreshFilter() {
        IItemFilter flt = FilterRegister.getFilterForUpgrade(this.filterItem);
        if (flt instanceof ItemFilter) {
            this.filter = (ItemFilter)flt;
        } else {
            this.filterItem = null;
        }
    }

    @Override
    protected void readCustomNBT(NBTTagCompound root) {
        super.readCustomNBT(root);
        this.refreshFilter();
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nbtRoot) {
        super.readContentsFromNBT(nbtRoot);
        this.refreshFilter();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    @Override
    public IBlockState getPaintSource() {
        return this.sourceBlock;
    }

    @Override
    public void setPaintSource(@Nullable IBlockState sourceBlock) {
        this.sourceBlock = sourceBlock;
        this.func_70296_d();
        this.updateBlock();
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(new RangeParticle<TileVacuumChest>(this, color));
        }
    }

    @Override
    public BoundingBox getBounds() {
        return new BoundingBox(this.func_174877_v()).expand((double)(this.getRange() + (this.range == 0 ? 0.03125f : 0.0f)));
    }

    public float getRange() {
        return this.range;
    }

    @Override
    public boolean getRedstoneControlStatus() {
        return this.redstoneCheckPassed;
    }
}

