/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.inhibitor;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.Maps;
import crazypants.enderio.GuiID;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.machine.obelisk.AbstractBlockObelisk;
import crazypants.enderio.machine.obelisk.GuiRangedObelisk;
import crazypants.enderio.machine.obelisk.inhibitor.ContainerInhibitorObelisk;
import crazypants.enderio.machine.obelisk.inhibitor.TileInhibitorObelisk;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockInhibitorObelisk
extends AbstractBlockObelisk<TileInhibitorObelisk> {
    public static BlockInhibitorObelisk instance;
    public Map<BlockCoord, BoundingBox> activeInhibitors = Maps.newHashMap();

    public static BlockInhibitorObelisk create() {
        BlockInhibitorObelisk res = new BlockInhibitorObelisk();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        instance = res;
        return instance;
    }

    protected BlockInhibitorObelisk() {
        super(ModObject.blockInhibitorObelisk, TileInhibitorObelisk.class);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileInhibitorObelisk te = (TileInhibitorObelisk)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z));
        if (te != null) {
            return new ContainerInhibitorObelisk(player.field_71071_by, te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileInhibitorObelisk te = (TileInhibitorObelisk)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z));
        if (te != null) {
            return new GuiRangedObelisk(player.field_71071_by, te, (Container)new ContainerInhibitorObelisk(player.field_71071_by, te), "inhibitor");
        }
        return null;
    }

    @Override
    protected GuiID getGuiId() {
        return GuiID.GUI_ID_INHIBITOR;
    }

    @SubscribeEvent
    public void onTeleport(TeleportEntityEvent event) {
        if (this.isTeleportPrevented(event.getEntity().field_70170_p, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v)) {
            event.setCanceled(true);
        }
        if (this.isTeleportPrevented(event.getEntity().field_70170_p, event.targetX, event.targetY, event.targetZ)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (this.isTeleportPrevented(event.getEntity().field_70170_p, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v)) {
            event.setCanceled(true);
        }
        if (this.isTeleportPrevented(event.getEntity().field_70170_p, event.getTargetX(), event.getTargetY(), event.getTargetZ())) {
            event.setCanceled(true);
        }
    }

    private boolean isTeleportPrevented(World entityWorld, double d, double f, double g) {
        if (!this.activeInhibitors.isEmpty()) {
            Vec3d pos = new Vec3d(d, f, g);
            for (Map.Entry<BlockCoord, BoundingBox> e : this.activeInhibitors.entrySet()) {
                TileEntity te;
                BlockCoord bc;
                if (!e.getValue().func_72318_a(pos) || !entityWorld.func_175667_e((bc = e.getKey()).getBlockPos()) || !((te = bc.getTileEntity((IBlockAccess)entityWorld)) instanceof TileInhibitorObelisk) || !((TileInhibitorObelisk)te).isActive() || !((TileInhibitorObelisk)te).getBounds().func_72318_a(pos)) continue;
                return true;
            }
        }
        return false;
    }
}

