/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.NetworkPowerManager;
import crazypants.enderio.conduit.power.PowerConduitNetwork;
import crazypants.enderio.conduit.power.PowerTracker;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.monitor.DynaTextureProvider;
import crazypants.enderio.machine.monitor.PacketPowerMonitorGraph;
import crazypants.enderio.machine.monitor.PacketPowerMonitorStatData;
import crazypants.enderio.machine.monitor.StatCollector;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TilePowerMonitor
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    private static final int iconUpdateRate = 1500;
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats10s = new StatCollector(2);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats01m = new StatCollector(12);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats10m = new StatCollector(120);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats01h = new StatCollector(720);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats06h = new StatCollector(7200);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats24h = new StatCollector(17280);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector stats07d = new StatCollector(120960);
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.ITEM})
    protected StatCollector statsIcn = new StatCollector(1500, 28);
    protected StatCollector[] stats = new StatCollector[]{this.stats10s, this.stats01m, this.stats10m, this.stats01h, this.stats06h, this.stats24h, this.stats07d, this.statsIcn};
    @Store(value={Store.StoreFor.SAVE, Store.StoreFor.CLIENT})
    private boolean advanced;
    @Store
    private boolean engineControlEnabled = false;
    @Store
    private float startLevel = 0.75f;
    @Store
    private float stopLevel = 0.99f;
    @Store(value={Store.StoreFor.CLIENT})
    private boolean redStoneOn;
    private boolean initialized = false;
    private int slowstart = 100;
    private static final long bit62 = Integer.MAX_VALUE;
    private static final long bit63 = 0xFFFFFFFEL;
    private long[] lastUpdateRequest = new long[this.stats.length];
    protected Object dynaTextureProvider = null;
    protected int[] iconMins = new int[32];
    protected int[] iconMaxs = new int[32];
    protected StatData statData = null;
    private long lastUpdateRequestStatData = -1L;

    public TilePowerMonitor() {
        super(new SlotDefinition(0, 0, 0), CapacitorKey.POWER_MONITOR_POWER_INTAKE, CapacitorKey.POWER_MONITOR_POWER_BUFFER, CapacitorKey.POWER_MONITOR_POWER_USE);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockPowerMonitorv2.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, @Nullable ItemStack item) {
        return false;
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode == IoMode.NONE;
    }

    @Override
    protected boolean checkProgress(boolean redstoneChecksPassed) {
        this.usePower();
        if (!this.advanced && !this.engineControlEnabled) {
            return false;
        }
        if (this.slowstart > 0) {
            --this.slowstart;
            return false;
        }
        NetworkPowerManager pm = this.getPowerManager();
        if (pm != null) {
            if (this.advanced) {
                int capPower = TilePowerMonitor.logSrqt2(pm.getPowerInCapacitorBanks());
                for (StatCollector statCollector : this.stats) {
                    statCollector.addValue(capPower);
                }
            }
            if (this.engineControlEnabled) {
                float level = this.getPercentFull(pm);
                if (level < this.startLevel) {
                    if (!this.redStoneOn) {
                        this.redStoneOn = true;
                        this.broadcastSignal();
                    }
                } else if (level >= this.stopLevel && this.redStoneOn) {
                    this.redStoneOn = false;
                    this.broadcastSignal();
                }
                if (!this.initialized) {
                    this.broadcastSignal();
                }
            }
        }
        if (this.advanced && this.shouldDoWorkThisTick(150)) {
            PacketHandler.sendToAllAround(PacketPowerMonitorGraph.sendUpdate(this, this.stats.length - 1), (TileEntity)this);
        }
        return false;
    }

    private float getPercentFull(NetworkPowerManager pm) {
        return (float)((long)pm.getPowerInConduits() + pm.getPowerInCapacitorBanks()) / (float)((long)pm.getMaxPowerInConduits() + pm.getMaxPowerInCapacitorBanks());
    }

    private void broadcastSignal() {
        this.initialized = true;
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
    }

    private static int logSrqt2(long value) {
        if (value <= 0L) {
            return 0;
        }
        if (value >= 0xFFFFFFFEL) {
            return 63;
        }
        if (value >= Integer.MAX_VALUE) {
            return 62;
        }
        for (int i = 30; i >= 0; --i) {
            if ((value & (long)(1 << i)) == 0L) continue;
            if (i == 0) {
                return 1;
            }
            if ((value & (long)(1 << i - 1)) != 0L) {
                return i * 2 + 1;
            }
            return i * 2;
        }
        return 0;
    }

    public NetworkPowerManager getPowerManager() {
        for (EnumFacing dir : EnumFacing.values()) {
            NetworkPowerManager pm;
            AbstractConduitNetwork n;
            IPowerConduit con = ConduitUtil.getConduit(this.field_145850_b, (TileEntity)this, dir, IPowerConduit.class);
            if (con == null || !((n = con.getNetwork()) instanceof PowerConduitNetwork) || (pm = ((PowerConduitNetwork)n).getPowerManager()) == null) continue;
            return pm;
        }
        return null;
    }

    @Override
    protected IPoweredTask createTask(IMachineRecipe nextRecipe, float chance) {
        return new ContinuousTask(this.getPowerUsePerTick());
    }

    @Override
    public void onCapacitorDataChange() {
        this.currentTask = this.createTask(null, 0.0f);
        this.initialized = false;
    }

    @SideOnly(value=Side.CLIENT)
    public StatCollector getStatCollector(int id) {
        if (id < 0 || id >= this.stats.length) {
            return null;
        }
        long now = EnderIO.proxy.getTickCount();
        if (this.lastUpdateRequest[id] < now) {
            this.lastUpdateRequest[id] = now + 10L;
            PacketHandler.INSTANCE.sendToServer(PacketPowerMonitorGraph.requestUpdate(this, id));
        }
        return this.stats[id];
    }

    @SideOnly(value=Side.CLIENT)
    public void bindTexture() {
        if (this.dynaTextureProvider == null) {
            this.dynaTextureProvider = new DynaTextureProvider(this);
        }
        ((DynaTextureProvider)this.dynaTextureProvider).bindTexture();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_145843_s() {
        super.func_145843_s();
        if (this.dynaTextureProvider != null) {
            ((DynaTextureProvider)this.dynaTextureProvider).free();
            this.dynaTextureProvider = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int[][] getIconValues() {
        return this.statsIcn.getValues();
    }

    @SideOnly(value=Side.CLIENT)
    public StatData getStatData() {
        long now = EnderIO.proxy.getTickCount();
        if (this.lastUpdateRequestStatData < now) {
            this.lastUpdateRequestStatData = now + 10L;
            PacketHandler.INSTANCE.sendToServer(PacketPowerMonitorStatData.requestUpdate(this));
        }
        return this.statData;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
        this.func_70296_d();
    }

    public boolean isEngineControlEnabled() {
        return this.engineControlEnabled;
    }

    public void setEngineControlEnabled(boolean engineControlEnabled) {
        this.engineControlEnabled = engineControlEnabled;
        if (!engineControlEnabled && this.redStoneOn) {
            this.redStoneOn = false;
            this.broadcastSignal();
        }
        this.func_70296_d();
    }

    public float getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(float startLevel) {
        this.startLevel = startLevel;
        this.func_70296_d();
    }

    public float getStopLevel() {
        return this.stopLevel;
    }

    public void setStopLevel(float stopLevel) {
        this.stopLevel = stopLevel;
        this.func_70296_d();
    }

    public int getRedstoneLevel() {
        return this.redStoneOn ? 15 : 0;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    static class StatData {
        int powerInConduits;
        int maxPowerInConduits;
        long powerInCapBanks;
        long maxPowerInCapBanks;
        long powerInMachines;
        long maxPowerInMachines;
        float aveRfSent;
        float aveRfReceived;

        StatData(NetworkPowerManager pm) {
            this.powerInConduits = pm.getPowerInConduits();
            this.maxPowerInConduits = pm.getMaxPowerInConduits();
            this.powerInCapBanks = pm.getPowerInCapacitorBanks();
            this.maxPowerInCapBanks = pm.getMaxPowerInCapacitorBanks();
            this.powerInMachines = pm.getPowerInReceptors();
            this.maxPowerInMachines = pm.getMaxPowerInReceptors();
            PowerTracker tracker = pm.getNetworkPowerTracker();
            this.aveRfSent = tracker.getAverageRfTickSent();
            this.aveRfReceived = tracker.getAverageRfTickRecieved();
        }

        StatData() {
        }
    }
}

