/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.server;

import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.machine.invpanel.server.AbstractInventory;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

class NormalInventory
extends AbstractInventory {
    final NetworkedInventory ni;

    NormalInventory(NetworkedInventory ni) {
        this.ni = ni;
    }

    @Override
    int scanInventory(InventoryDatabaseServer db) {
        IItemHandler inv = this.ni.getInventory();
        if (inv == null) {
            this.setEmpty(db);
            return 0;
        }
        int numSlots = inv.getSlots();
        if (numSlots < 1) {
            this.setEmpty(db);
            return 0;
        }
        if (numSlots != this.slotKeys.length) {
            this.reset(db, numSlots);
        }
        for (int slot = 0; slot < numSlots; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack != null) {
                if (stack.field_77994_a == 0) {
                    stack = null;
                } else {
                    ItemStack extracted = inv.extractItem(slot, stack.field_77994_a, true);
                    if (extracted == null) {
                        stack = null;
                    } else if (stack.field_77994_a > stack.func_77976_d()) {
                        if (extracted.field_77994_a < stack.func_77976_d()) {
                            stack = null;
                        }
                    } else if (extracted.field_77994_a != stack.field_77994_a) {
                        stack = null;
                    }
                }
            }
            this.updateSlot(db, slot, stack);
        }
        return numSlots;
    }

    @Override
    public int extractItem(InventoryDatabaseServer db, ItemEntry entry, int slot, int count) {
        IItemHandler inv = this.ni.getInventory();
        if (inv == null) {
            return 0;
        }
        ItemStack stack = inv.getStackInSlot(slot);
        if (stack == null || stack.field_77994_a == 0 || db.lookupItem(stack, entry, false) != entry) {
            return 0;
        }
        ItemStack extracted = inv.extractItem(slot, count, false);
        if (extracted == null || extracted.field_77994_a == 0) {
            return 0;
        }
        this.ni.onItemExtracted(slot, extracted.field_77994_a);
        stack = inv.getStackInSlot(slot);
        if (stack != null) {
            this.updateCount(db, slot, entry, stack.field_77994_a);
        } else {
            this.updateCount(db, slot, entry, 0);
        }
        return extracted.field_77994_a;
    }

    @Override
    protected void markForScanning(BlockPos pos) {
        if (this.ni.isAt(pos)) {
            this.markForScanning();
        }
    }
}

