/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.GuiID;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.invpanel.BlockItemInventoryPanel;
import crazypants.enderio.machine.invpanel.GuiInventoryPanel;
import crazypants.enderio.machine.invpanel.InvPanelRenderMapper;
import crazypants.enderio.machine.invpanel.InventoryPanelContainer;
import crazypants.enderio.machine.invpanel.PacketDatabaseReset;
import crazypants.enderio.machine.invpanel.PacketFetchItem;
import crazypants.enderio.machine.invpanel.PacketGuiSettings;
import crazypants.enderio.machine.invpanel.PacketGuiSettingsUpdated;
import crazypants.enderio.machine.invpanel.PacketItemInfo;
import crazypants.enderio.machine.invpanel.PacketItemList;
import crazypants.enderio.machine.invpanel.PacketMoveItems;
import crazypants.enderio.machine.invpanel.PacketRequestMissingItems;
import crazypants.enderio.machine.invpanel.PacketSetExtractionDisabled;
import crazypants.enderio.machine.invpanel.PacketStoredCraftingRecipe;
import crazypants.enderio.machine.invpanel.PacketUpdateExtractionDisabled;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.remote.PacketPrimeInventoryPanelRemote;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.property.EnumRenderMode6;
import crazypants.enderio.render.registry.SmartModelAttacher;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInventoryPanel
extends AbstractMachineBlock<TileInventoryPanel> {
    private static final float BLOCK_SIZE = 0.25f;

    public static BlockInventoryPanel create() {
        PacketHandler.INSTANCE.registerMessage(PacketItemInfo.class, PacketItemInfo.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketItemList.class, PacketItemList.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketRequestMissingItems.class, PacketRequestMissingItems.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketFetchItem.class, PacketFetchItem.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketMoveItems.class, PacketMoveItems.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketDatabaseReset.class, PacketDatabaseReset.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketGuiSettings.class, PacketGuiSettings.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketStoredCraftingRecipe.class, PacketStoredCraftingRecipe.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketSetExtractionDisabled.class, PacketSetExtractionDisabled.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpdateExtractionDisabled.class, PacketUpdateExtractionDisabled.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketPrimeInventoryPanelRemote.class, PacketPrimeInventoryPanelRemote.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketGuiSettingsUpdated.class, PacketGuiSettingsUpdated.class, PacketHandler.nextID(), Side.CLIENT);
        BlockInventoryPanel panel = new BlockInventoryPanel();
        panel.init();
        return panel;
    }

    public BlockInventoryPanel() {
        super(ModObject.blockInventoryPanel, TileInventoryPanel.class);
    }

    protected ItemBlock createItemBlock() {
        return new BlockItemInventoryPanel((Block)this, this.getName());
    }

    @Override
    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode6.RENDER, (Comparable)((Object)EnumRenderMode6.AUTO)));
    }

    @Override
    protected void registerInSmartModelAttacher() {
        SmartModelAttacher.register((Block)this, EnumRenderMode6.RENDER, EnumRenderMode6.DEFAULTS, EnumRenderMode6.AUTO);
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode6.RENDER});
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176212_b(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return this.getFacing(worldIn, pos) == side.func_176734_d();
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    public boolean func_149637_q(IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(IBlockState bs) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = this.getFacing(world, pos);
        return this.getBoundingBox(facing);
    }

    public AxisAlignedBB getBoundingBox(EnumFacing facing) {
        int x = 0;
        int y = 0;
        int z = 0;
        switch (facing) {
            case DOWN: {
                return new AxisAlignedBB((double)x, (double)((float)y + 0.75f), (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case UP: {
                return new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)y + 0.25f), (double)(z + 1));
            }
            case NORTH: {
                return new AxisAlignedBB((double)x, (double)y, (double)((float)z + 0.75f), (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case SOUTH: {
                return new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)((float)z + 0.25f));
            }
            case WEST: {
                return new AxisAlignedBB((double)((float)x + 0.75f), (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case EAST: {
                return new AxisAlignedBB((double)x, (double)y, (double)z, (double)((float)x + 0.25f), (double)(y + 1), (double)(z + 1));
            }
        }
        return new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    private EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        TileEntityBase te = this.getTileEntitySafe(world, pos);
        if (te instanceof TileInventoryPanel) {
            return ((TileInventoryPanel)te).getFacing();
        }
        return EnumFacing.NORTH;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState bs, World world, BlockPos pos, Random rand) {
    }

    @Override
    protected GuiID getGuiId() {
        return GuiID.GUI_ID_INVENTORY_PANEL;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileInventoryPanel te = (TileInventoryPanel)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z));
        if (te != null) {
            return new InventoryPanelContainer(player.field_71071_by, te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileInventoryPanel te = (TileInventoryPanel)this.getTileEntity((IBlockAccess)world, new BlockPos(x, y, z));
        if (te != null) {
            return new GuiInventoryPanel(te, (Container)new InventoryPanelContainer(player.field_71071_by, te));
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return InvPanelRenderMapper.instance;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return InvPanelRenderMapper.instance;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileInventoryPanel tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(tileEntity.isActive());
    }

    @Override
    public boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        return super.openGui(world, pos, entityPlayer, side);
    }
}

