/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.loot;

import crazypants.enderio.capacitor.CapacitorHelper;
import crazypants.enderio.capacitor.CapacitorKey;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.WeightedRandom;

public enum WeightedUpgrade {
    SMELTING(CapacitorHelper.SetType.NAME, CapacitorKey.ALLOY_SMELTER_POWER_USE, "smelting", 10),
    INTAKE(CapacitorHelper.SetType.TYPE, CapacitorKey.ALLOY_SMELTER_POWER_INTAKE, "intake", 20),
    BUFFER(CapacitorHelper.SetType.TYPE, CapacitorKey.ALLOY_SMELTER_POWER_BUFFER, "buffer", 20),
    CRAFTING(CapacitorHelper.SetType.NAME, CapacitorKey.CRAFTER_TICKS, "crafting", 10),
    AREA(CapacitorHelper.SetType.TYPE, CapacitorKey.ATTRACTOR_RANGE, "area", 5),
    GREEN(CapacitorHelper.SetType.NAME, CapacitorKey.FARM_BONUS_SIZE, "green", 10),
    RED(CapacitorHelper.SetType.NAME, CapacitorKey.STIRLING_POWER_GEN, "red", 10),
    MOBBY(CapacitorHelper.SetType.NAME, CapacitorKey.SPAWNER_SPEEDUP, "mobby", 5),
    CRUSHED(CapacitorHelper.SetType.NAME, CapacitorKey.SAG_MILL_POWER_USE, "crushed", 15),
    CLEANCUT(CapacitorHelper.SetType.NAME, CapacitorKey.SLICE_POWER_USE, "cleancut", 5),
    TIGHT(CapacitorHelper.SetType.NAME, CapacitorKey.SOUL_BINDER_POWER_USE, "tight", 5),
    AA(CapacitorHelper.SetType.NAME, CapacitorKey.PAINTER_POWER_USE, "aa", 10);

    public final CapacitorHelper.SetType setType;
    public final CapacitorKey capacitorKey;
    public final String langKey;

    private WeightedUpgrade(CapacitorHelper.SetType setType, CapacitorKey capacitorKey, String langKey, int weight) {
        this.setType = setType;
        this.capacitorKey = capacitorKey;
        this.langKey = "loot.capacitor." + langKey;
        WeightedUpgradeImpl.weightedUpgrades.add(new WeightedUpgradeImpl(weight, this));
    }

    public static List<WeightedUpgradeImpl> getWeightedupgrades() {
        return WeightedUpgradeImpl.weightedUpgrades;
    }

    public static class WeightedUpgradeImpl
    extends WeightedRandom.Item {
        private static final List<WeightedUpgradeImpl> weightedUpgrades = new ArrayList<WeightedUpgradeImpl>();
        private final WeightedUpgrade upgrade;

        private WeightedUpgradeImpl(int weight, WeightedUpgrade upgrade) {
            super(weight);
            this.upgrade = upgrade;
        }

        public WeightedUpgrade getUpgrade() {
            return this.upgrade;
        }
    }
}

