/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.fluid;

import crazypants.enderio.fluid.SmartTank;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class SmartTankFluidHandler {
    protected final IFluidHandler[] tanks;
    private final SideHandler[] sides = new SideHandler[EnumFacing.values().length];

    public SmartTankFluidHandler(IFluidHandler ... tanks) {
        this.tanks = tanks;
    }

    public boolean has(EnumFacing facing) {
        return facing != null && this.canAccess(facing);
    }

    public SideHandler get(EnumFacing facing) {
        if (this.has(facing)) {
            if (this.sides[facing.ordinal()] == null) {
                this.sides[facing.ordinal()] = new SideHandler(facing);
            }
            return this.sides[facing.ordinal()];
        }
        return null;
    }

    protected abstract boolean canFill(EnumFacing var1);

    protected abstract boolean canDrain(EnumFacing var1);

    protected abstract boolean canAccess(EnumFacing var1);

    private class SideHandler
    implements IFluidHandler {
        private final EnumFacing facing;

        public SideHandler(EnumFacing facing) {
            this.facing = facing;
        }

        public IFluidTankProperties[] getTankProperties() {
            if (!SmartTankFluidHandler.this.canAccess(this.facing)) {
                return new IFluidTankProperties[0];
            }
            if (SmartTankFluidHandler.this.tanks.length == 1) {
                return SmartTankFluidHandler.this.tanks[0].getTankProperties();
            }
            ArrayList<IFluidTankProperties> result = new ArrayList<IFluidTankProperties>();
            for (IFluidHandler smartTank : SmartTankFluidHandler.this.tanks) {
                IFluidTankProperties[] tankProperties = smartTank.getTankProperties();
                if (tankProperties == null) continue;
                for (IFluidTankProperties tankProperty : tankProperties) {
                    result.add(tankProperty);
                }
            }
            return result.toArray(new IFluidTankProperties[result.size()]);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (!SmartTankFluidHandler.this.canFill(this.facing)) {
                return 0;
            }
            if (SmartTankFluidHandler.this.tanks.length == 1) {
                return SmartTankFluidHandler.this.tanks[0].fill(resource, doFill);
            }
            for (IFluidHandler smartTank : SmartTankFluidHandler.this.tanks) {
                if (smartTank instanceof SmartTank) {
                    if (!((SmartTank)smartTank).canFill(resource)) continue;
                    return smartTank.fill(resource, doFill);
                }
                if (smartTank instanceof FluidTank) {
                    if (!((FluidTank)smartTank).canFill()) continue;
                    return smartTank.fill(resource, doFill);
                }
                return smartTank.fill(resource, doFill);
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (!SmartTankFluidHandler.this.canDrain(this.facing)) {
                return null;
            }
            if (SmartTankFluidHandler.this.tanks.length == 1) {
                return SmartTankFluidHandler.this.tanks[0].drain(resource, doDrain);
            }
            for (IFluidHandler smartTank : SmartTankFluidHandler.this.tanks) {
                if (smartTank instanceof FluidTank && !((FluidTank)smartTank).canDrainFluidType(resource)) continue;
                return smartTank.drain(resource, doDrain);
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (!SmartTankFluidHandler.this.canDrain(this.facing)) {
                return null;
            }
            if (SmartTankFluidHandler.this.tanks.length == 1) {
                return SmartTankFluidHandler.this.tanks[0].drain(maxDrain, doDrain);
            }
            for (IFluidHandler smartTank : SmartTankFluidHandler.this.tanks) {
                if (smartTank instanceof FluidTank && !((FluidTank)smartTank).canDrain()) continue;
                return smartTank.drain(maxDrain, doDrain);
            }
            return null;
        }
    }
}

