/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.facade;

import com.enderio.core.common.TileEntityBase;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.facade.EnumFacadeType;
import crazypants.enderio.conduit.facade.ItemConduitFacade;
import crazypants.enderio.machine.RenderMappers;
import crazypants.enderio.machine.painter.blocks.TileEntityPaintedBlock;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintHelper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.property.EnumRenderMode;
import crazypants.enderio.render.registry.SmartModelAttacher;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockConduitFacade
extends BlockEio<TileEntityPaintedBlock>
implements IPaintable.IBlockPaintableBlock,
ISmartRenderAwareBlock {
    public static BlockConduitFacade create() {
        BlockConduitFacade result = new BlockConduitFacade();
        result.init();
        return result;
    }

    private BlockConduitFacade() {
        super(ModObject.blockConduitFacade.getUnlocalisedName(), TileEntityPaintedBlock.class, new Material(MapColor.field_151665_m));
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(EnderIOTab.tabEnderIOItems);
        this.initDefaultState();
    }

    protected ItemBlock createItemBlock() {
        return new ItemConduitFacade((Block)this, this.name);
    }

    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)).func_177226_a(EnumFacadeType.TYPE, (Comparable)((Object)EnumFacadeType.BASIC)));
    }

    protected void init() {
        super.init();
        SmartModelAttacher.register((Block)this);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER, EnumFacadeType.TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(EnumFacadeType.TYPE, (Comparable)((Object)EnumFacadeType.getTypeFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return EnumFacadeType.getMetaFromType((EnumFacadeType)((Object)state.func_177229_b(EnumFacadeType.TYPE)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO));
    }

    public int func_180651_a(IBlockState st) {
        return this.func_176201_c(st);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (EnumFacadeType type : EnumFacadeType.values()) {
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, RenderMappers.FRONT_MAPPER_NO_IO);
            blockStateWrapper.addCacheKey(0);
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityBase te = this.getTileEntitySafe(world, pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)te).getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public IBlockState getFacade(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState paintSource = this.getPaintSource(this.func_176223_P(), world, pos);
        return paintSource != null ? paintSource : world.func_180495_p(pos);
    }

    @Override
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.FRONT_MAPPER_NO_IO;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }
}

