/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.gui.IconEIO;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ConduitDisplayMode {
    public static final ConduitDisplayMode NEUTRAL = new ConduitDisplayMode("neutral", (IWidgetIcon)IconEIO.YETA_GEAR, (IWidgetIcon)IconEIO.YETA_GEAR);
    public static final ConduitDisplayMode ALL = new ConduitDisplayMode("all", (IWidgetIcon)IconEIO.TICK, (IWidgetIcon)IconEIO.TICK);
    public static final ConduitDisplayMode NONE = new ConduitDisplayMode("none", (IWidgetIcon)IconEIO.CROSS, (IWidgetIcon)IconEIO.CROSS);
    private static final List<ConduitDisplayMode> registrar = Lists.newArrayList((Object[])new ConduitDisplayMode[]{NONE, ALL, new ConduitDisplayMode(IItemConduit.class, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_ITEM, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_ITEM_OFF), new ConduitDisplayMode(ILiquidConduit.class, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_FLUID, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_FLUID_OFF), new ConduitDisplayMode(IPowerConduit.class, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_POWER, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_POWER_OFF), new ConduitDisplayMode(IRedstoneConduit.class, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_REDSTONE, (IWidgetIcon)IconEIO.WRENCH_OVERLAY_REDSTONE_OFF), NEUTRAL});
    private final Class<? extends IConduit> conduitType;
    private final IWidgetIcon widgetSelected;
    private final IWidgetIcon widgetUnselected;
    private String overrideName = null;
    private static final String NBT_KEY = "enderio.displaymode";

    public static void registerDisplayMode(ConduitDisplayMode mode) {
        if (!registrar.contains(mode)) {
            registrar.add(mode);
        }
    }

    public ConduitDisplayMode(String name, IWidgetIcon widgetSelected, IWidgetIcon widgetUnselected) {
        this(IConduit.class, widgetSelected, widgetUnselected);
        this.setName(name);
    }

    public ConduitDisplayMode(@Nonnull Class<? extends IConduit> conduitType, IWidgetIcon widgetSelected, IWidgetIcon widgetUnselected) {
        this.conduitType = conduitType;
        this.widgetSelected = widgetSelected;
        this.widgetUnselected = widgetUnselected;
    }

    @Nullable
    public Class<? extends IConduit> getConduitType() {
        return this.conduitType;
    }

    public boolean renderConduit(Class<? extends IConduit> conduitTypeIn) {
        if (this == ALL || this == NEUTRAL || conduitTypeIn == null) {
            return true;
        }
        if (this == NONE) {
            return false;
        }
        return this.conduitType.isAssignableFrom(conduitTypeIn);
    }

    @Nonnull
    public String getName() {
        return this.overrideName == null ? this.conduitType.getSimpleName() : this.overrideName;
    }

    public void setName(@Nullable String name) {
        this.overrideName = name;
    }

    public IWidgetIcon getWidgetSelected() {
        return this.widgetSelected;
    }

    public IWidgetIcon getWidgetUnselected() {
        return this.widgetUnselected;
    }

    public static ConduitDisplayMode next(ConduitDisplayMode mode) {
        int index = registrar.indexOf(mode) + 1;
        if (index >= registrar.size()) {
            index = 0;
        }
        return registrar.get(index);
    }

    public static ConduitDisplayMode previous(ConduitDisplayMode mode) {
        int index = registrar.indexOf(mode) - 1;
        if (index < 0) {
            index = registrar.size() - 1;
        }
        return registrar.get(index);
    }

    public static ConduitDisplayMode fromName(String name) {
        for (ConduitDisplayMode mode : registrar) {
            if (!mode.getName().equals(name)) continue;
            return mode;
        }
        return null;
    }

    public int ordinal() {
        return registrar.indexOf(this);
    }

    public static ConduitDisplayMode getDisplayMode(ItemStack equipped) {
        if (equipped == null || !(equipped.func_77973_b() instanceof IConduitControl)) {
            return ALL;
        }
        ConduitDisplayMode.initDisplayModeTag(equipped);
        String name = equipped.func_77978_p().func_74779_i(NBT_KEY);
        ConduitDisplayMode mode = ConduitDisplayMode.fromName(name);
        if (mode == null) {
            ConduitDisplayMode.setDisplayMode(equipped, ALL);
            return ALL;
        }
        return mode;
    }

    public static void setDisplayMode(ItemStack equipped, ConduitDisplayMode mode) {
        if (mode == null || equipped == null || !(equipped.func_77973_b() instanceof IConduitControl)) {
            return;
        }
        ConduitDisplayMode.initDisplayModeTag(equipped);
        equipped.func_77978_p().func_74778_a(NBT_KEY, mode.getName());
    }

    private static void initDisplayModeTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            NBTTagCompound stackTagCompound = new NBTTagCompound();
            stackTagCompound.func_74778_a(NBT_KEY, ALL.getName());
            stack.func_77982_d(stackTagCompound);
        }
    }

    public ConduitDisplayMode next() {
        return ConduitDisplayMode.next(this);
    }

    public ConduitDisplayMode previous() {
        return ConduitDisplayMode.previous(this);
    }

    public boolean isAll() {
        return this == ALL || this == NEUTRAL;
    }

    public static int registrySize() {
        return registrar.size() - 2;
    }

    public static Iterable<ConduitDisplayMode> getRenderableModes() {
        return FluentIterable.from(registrar).filter((Predicate)new Predicate<ConduitDisplayMode>(){

            public boolean apply(@Nullable ConduitDisplayMode input) {
                return input != ALL && input != NONE;
            }

            public boolean equals(@Nullable Object obj) {
                return super.equals(obj);
            }
        });
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conduitType == null ? 0 : this.conduitType.hashCode());
        result = 31 * result + (this.overrideName == null ? 0 : this.overrideName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConduitDisplayMode other = (ConduitDisplayMode)obj;
        if (this.conduitType == null ? other.conduitType != null : !this.conduitType.equals(other.conduitType)) {
            return false;
        }
        return !(this.overrideName == null ? other.overrideName != null : !this.overrideName.equals(other.overrideName));
    }
}

