/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.solderer.ISoldererRecipe;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.inventory.IItemValidator;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataProducer;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileSolderer
extends TileNode {
    public static final TileDataParameter<Integer> DURATION = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileSolderer>(){

        @Override
        public Integer getValue(TileSolderer tile) {
            return tile.recipe != null ? tile.recipe.getDuration() : 0;
        }
    });
    public static final TileDataParameter<Integer> PROGRESS = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileSolderer>(){

        @Override
        public Integer getValue(TileSolderer tile) {
            return tile.progress;
        }
    });
    public static final TileDataParameter<Boolean> WORKING = new TileDataParameter<Boolean>(DataSerializers.field_187198_h, false, new ITileDataProducer<Boolean, TileSolderer>(){

        @Override
        public Boolean getValue(TileSolderer tile) {
            return tile.working;
        }
    });
    private static final String NBT_WORKING = "Working";
    private static final String NBT_PROGRESS = "Progress";
    private ItemHandlerBasic items = new ItemHandlerBasic(3, this, new IItemValidator[0]){

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            for (ISoldererRecipe recipe : API.instance().getSoldererRegistry().getRecipes()) {
                if (!API.instance().getComparer().isEqual(recipe.getRow(slot), stack, 27)) continue;
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private ItemHandlerBasic result = new ItemHandlerBasic(1, this, new IItemValidator[0]){

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }
    };
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2);
    private ISoldererRecipe recipe;
    private boolean working = false;
    private boolean wasWorking = false;
    private int progress = 0;

    public TileSolderer() {
        this.dataManager.addWatchedParameter(DURATION);
        this.dataManager.addWatchedParameter(PROGRESS);
        this.dataManager.addWatchedParameter(WORKING);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.soldererUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void updateNode() {
        if (this.items.getStackInSlot(1) == null && this.items.getStackInSlot(2) == null && this.result.getStackInSlot(0) == null) {
            this.stop();
        } else {
            ISoldererRecipe newRecipe = API.instance().getSoldererRegistry().getRecipe((IItemHandler)this.items);
            if (newRecipe == null) {
                this.stop();
            } else if (newRecipe != this.recipe) {
                boolean sameItem;
                boolean bl = sameItem = this.result.getStackInSlot(0) != null && API.instance().getComparer().isEqualNoQuantity(this.result.getStackInSlot(0), newRecipe.getResult());
                if (this.result.getStackInSlot(0) == null || sameItem && this.result.getStackInSlot((int)0).field_77994_a + newRecipe.getResult().field_77994_a <= this.result.getStackInSlot(0).func_77976_d()) {
                    this.recipe = newRecipe;
                    this.progress = 0;
                    this.working = true;
                    this.func_70296_d();
                }
            } else if (this.working) {
                this.progress += 1 + this.upgrades.getUpgradeCount(2);
                if (this.progress >= this.recipe.getDuration()) {
                    if (this.result.getStackInSlot(0) != null) {
                        this.result.getStackInSlot((int)0).field_77994_a += this.recipe.getResult().field_77994_a;
                    } else {
                        this.result.setStackInSlot(0, this.recipe.getResult().func_77946_l());
                    }
                    for (int i = 0; i < 3; ++i) {
                        if (this.recipe.getRow(i) == null) continue;
                        this.items.extractItem(i, this.recipe.getRow((int)i).field_77994_a, false);
                    }
                    this.recipe = null;
                    this.progress = 0;
                    this.func_70296_d();
                }
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.working != this.wasWorking) {
            this.wasWorking = this.working;
            this.updateBlock();
        }
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        if (!state) {
            this.stop();
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    private void stop() {
        this.progress = 0;
        this.working = false;
        this.recipe = null;
        this.func_70296_d();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.items, 0, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.upgrades, 1, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.result, 2, tag);
        this.recipe = API.instance().getSoldererRegistry().getRecipe((IItemHandler)this.items);
        if (tag.func_74764_b(NBT_WORKING)) {
            this.wasWorking = this.working = tag.func_74767_n(NBT_WORKING);
        }
        if (tag.func_74764_b(NBT_PROGRESS)) {
            this.progress = tag.func_74762_e(NBT_PROGRESS);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        RSUtils.writeItems((IItemHandler)this.items, 0, tag);
        RSUtils.writeItems((IItemHandler)this.upgrades, 1, tag);
        RSUtils.writeItems((IItemHandler)this.result, 2, tag);
        tag.func_74757_a(NBT_WORKING, this.working);
        tag.func_74768_a(NBT_PROGRESS, this.progress);
        return tag;
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74757_a(NBT_WORKING, this.working);
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        if (tag.func_74764_b(NBT_WORKING)) {
            this.working = tag.func_74767_n(NBT_WORKING);
        }
    }

    public ItemHandlerBasic getItems() {
        return this.items;
    }

    public ItemHandlerBasic getResult() {
        return this.result;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.items, this.result, this.upgrades});
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)(facing == EnumFacing.DOWN ? this.result : this.items));
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

